/************************************************************************************************************
* Slice32 1.0 Copyright (c) 1999
* Ziff-Davis, Inc.
* All rights reserved
* First Published in PC Magazine, US Edition, 12/01/1999
* Programmer: Paul Trout
************************************************************************************************************/

/************************************************************************************************************
* The following height and width values were arrived at empirically.
************************************************************************************************************/
#define SLC_WDT 448                                             /* Main window width */
#define SLC_HGT 422                                             /* Main window height */

/************************************************************************************************************
* These are the control identifiers used by the WM_COMMAND event in WndProc to determine which control got 
*   the event.  These are similar to the #define statements you will see in the header files generated by the
*   dialog box editor.  Since I'm not using a dialog box for the main window, I have to do my own.
************************************************************************************************************/
#define FRA_SOURCE        0
#define FRA_METHOD        1
#define FRA_DEST          2
#define LBL_SIZE          3
#define LBL_NUMPORTIONS   4
#define LBL_NUMBER        5
#define LBL_SIZEPORTIONS  6
#define TXT_SOURCE        7
#define CMD_SOURCE        8
#define RAD_REMOVE        9
#define CBO_REMOVE       10
#define RAD_SIZE         11
#define CBO_SIZE         12
#define CBO_UNITS        13
#define RAD_NUMBER       14
#define TXT_NUMBER       15
#define SPN_NUMBER       16
#define TXT_DEST         17
#define CMD_DEST         18
#define CMD_SLICE        19
#define CMD_HELP         20
#define CMD_ABOUT        21
#define CMD_EXIT         22

#define PATH_LEN    1024                                        /* Length of of slice32.exe path */
#define D2880       2922496                                     /* Usable space on a 2.88MB disk */
#define D1440       1456640                                     /* Usable space on a 1.44MB disk */
#define D1200       1213952                                     /* Usable space on a 1.2MB disk */
#define D720         724480                                     /* Usable space on a 720KB disk */
#define D360         358400                                     /* Usable space on a 360KB disk */
#define K720         737280                                     /* 720KB */
#define K600         614400                                     /* 600KB */
#define K360         368640                                     /* 360KB */
#define K180         184320                                     /* 180KB */

/************************************************************************************************************
* Macros required for the About dialog box, and the splice32 resource.  These were originally generated by
*   the visual studio resource editor.
************************************************************************************************************/
#define CMD_OK                          1026
#define IDR_SPLICER1                    101
#define IDI_ICON1                       102

/************************************************************************************************************
* All sorts of stuff needs this global.
************************************************************************************************************/
HWND      hwnd_main;

/************************************************************************************************************
* This string holds the SLICE32.EXE startup directory.
************************************************************************************************************/
char      slice32_dir[MAX_PATH+1];

/************************************************************************************************************
* This string holds the remembered destination browse directory.
************************************************************************************************************/
char      slice32_dest[MAX_PATH+1];

/************************************************************************************************************
* This string holds the remembered source browse directory.
************************************************************************************************************/
char      slice32_source[MAX_PATH+1];

/************************************************************************************************************
* Function prototypes:
*  WndProc              - main window procedure
*  AboutDialogProc      - handles the About dialog box
*  TabProc              - default child window subclass procedure.  Takes care of forward TAB for most controls.
*  CboSizeProc          - subclass procedure for the edit box of the cbo_size combo box.  Takes care of
*                           forward TAB.
*  folder_callback      - Callback procedure for SHBrowseForFolder.
*  get_drive_free_bytes - Returns the absolute number of free bytes one the specified drive.
*  make_splice32        - Creates SPLICE32.EXE on destination from the resource included in SLICE32.EXE.
*  slice                - Thread dispatch and control wrapper for slice_thread.
*  slice_thread         - Performs the actual slice operation.
*  init_startup         - Initialize slice32's startup directory.
*  write_ini            - Update SLICE32.INI at program exit.
*  read_ini             - Read SLICE32.INI at program startup, and initialize slice32_source and slice32_dest.
************************************************************************************************************/
LONG FAR PASCAL WndProc(HWND,UINT,WPARAM,LPARAM);
BOOL CALLBACK AboutDialogProc(HWND hwnd,UINT messg,WPARAM wParam,LPARAM lParam);
LRESULT CALLBACK TabProc(HWND hwnd,UINT messg,WPARAM wParam,LPARAM lParam);
LRESULT CALLBACK CboSizeProc(HWND hwnd,UINT messg,WPARAM wParam,LPARAM lParam);
int CALLBACK folder_callback(HWND hwnd,UINT messg,LPARAM lParam,LPARAM pData);
unsigned long int get_drive_free_bytes(unsigned char *drv);
unsigned long int make_splice32(unsigned char *dst_drv);
unsigned long int slice(char *file, char *drv, unsigned long portion_size);
unsigned long int __stdcall slice_thread(unsigned long *);
void init_startup(void);
void write_ini(void);
void read_ini(void);

/************************************************************************************************************
* Header written to the beginning of each destination piece.
************************************************************************************************************/
struct slice32_header {
  unsigned char      rstlast;                                   /* Last disk flag */
  unsigned long int  rstattr;                                   /* File attributes */
  FILETIME           creat_time;                                /* File creation time */
  FILETIME           acces_time;                                /* File access time */
  FILETIME           write_time;                                /* File write time */
  unsigned long int  rstlsiz;                                   /* Lo dword source file size */
  unsigned long int  rsthsiz;                                   /* Hi dword source file size */
  unsigned char      rstname[256];                              /* Filename */
  SYSTEMTIME         slice_time;                                /* Date/time file sliced */
};

