/************************************************************************************************************
* Slice32 1.0 Copyright (c) 1999
* Ziff-Davis, Inc.
* All rights reserved
* First Published in PC Magazine, US Edition, 12/01/1999
* Programmer: Paul Trout
*
* This is the user interface code for slice32.
*
* 07 Jul. 1999 - Initial implementation.  Works!!
*              - Changed background color to light gray by changing the GetStockObject argument from 
*                  WHITE_BRUSH to LTGRAY_BRUSH.
*              - By adjusting the style parameter of the CreateWindow function, I was able to disable the 
*                  maximize button, but not get rid of it entirely.
*              - By removing the WS_THICKFRAME flag from the style, I disabled window resizing.
*
* 08 Jul. 1999 - Changed name and caption to Slice32.
*
* 09 Jul. 1999 - Trying to get the window size the same as my VB prototype, I am trying all sorts of things.  
*                  Modifying the Mapping Mode, and using SetWindowExtEx does not work.
*              - By empiric analysis, WIDTH is 448 and HEIGHT is 422.  This works out to 15 twips per pixel.
*              - Added a static child window to act as the "Choose file to slice" frame.  The text is not 
*                  displayed, and the control is not initially visible; only partially visible after a redraw.
*              - By adding the WS_CLIPCHILDREN style to the main window, I was able to get the frame to 
*                  display on startup.  However, the text is still not displayed, and the contents of the 
*                  frame don't get repainted easily.
*              - By removing the SS_BLACKRECT style from the frame, I was able to get the text displayed, and 
*                  get it to refresh properly.  However, it doesn't really look or act like a frame.
*
* 10 Jul. 1999 - Still working with the frame.  It looks as though the frame control (or GROUPBOX) comes from 
*                  the MFC library (of course).
*
* 11 Jul. 1999 - Got a trial dialog box linked into the basicwin executable.  Modified the LINK statement
*                  accordingly.
*              - Removed the frame entirely.
*              - The CreateDialog function is failing.  Don't know why.
*
* 12 Jul. 1999 - Working on getting the DIALOG box to show.  Trying it with the DialogBox function, rather 
*                  than the CreateDialogBox function.  No joy.
*              - Moved the DialogBox call from WM_CREATE to WM_PAINT area of the WndProc.  No joy.
*              - Manually edited the dialog box resource file (.rc) and got it to work.  SUCCESS!!
*              - Since DialogBox creates a MODAL dialog box, and I want a modeless box, I am going back to the
*                  CreateDialog function.  SUCCESS!!
*              - Modified the WinMain message loop to pass the dialog box messages appropriately.
*              - Centered the MAIN window.
*              - Centered the Slice32 dialog box window.
*              - Wrapped the main window around the dialog box window.
*
* 02 Aug. 1999 - Removed ALL dialog box code.  Blank window works including Minimize, Close, and ALT+F4.
*              - Added fra_source creation in WM_CREATE.  No errors with fra_source creation, but it does not
*                  display.
*              - Added trapping of the WM_SIZE event: no frame.
*              - Got rid of the WM_PAINT event trap, and the frame now displays.
*              - Eliminated ALL non-essential code, and got the frame displayed properly.  Minimize and Exit 
*                  buttons still work, as well as ALT+F4.
*              - Added code to center the window on screen.
*              - All controls are placed on the screen.  (2 hrs work)
*              - Reordered the CreateWindow calls to be in control order from top to bottom, left to right.
*              - Added macros to easily access controls within the WM_COMMAND event trap.
*              - CMD_EXIT works.
*              - Moved over the extra includes from c1.ui\basicwin.c.
*              - Added the extra libraries to the link statement.
*              - Moved the makefile over from ..\c1.ui.
*              - CMD_ABOUT works.
*              - CMD_SOURCE works.
*              - CMD_DEST works.
*              - CBO_REMOVE works as well or as poorly as it ever did.
*
* 03 Aug. 1999 - Got RAD_REMOVE, RAD_SIZE, and RAD_NUMBER working like normal radio buttons.
*              - TXT_SOURCE gets focus on startup.
*              - Began to add the code for the SPIN control next to TXT_NUMBER.
*              - Added a call to InitCommonControls in WinMain to make sure the common controls DLL is loaded.
*              - SPN_NUMBER is being created and displayed properly.  Inserted it between TXT_NUMBER and 
*                  LBL_NUMBER.
*              - SPN_NUMBER is working like a normal spinner for the TXT_NUMBER control.
*              - Added WS_TABSTOP to all of the working controls.
*              - Time to look at the window subclassing for TABbing between controls.
*              - Subclassed the TXT_SOURCE control to TAB to the CMD_SOURCE control.  Works, but still causes 
*                  the error sound.
*              - By snagging the WM_CHAR message instead of the WM_KEYDOWN message, the TAB from TXT_SOURCE to
*                  CMD_SOURCE works with no sound!
*              - Reordered both the CreateWindow calls, and the Control ID defines so that all user interactive
*                  controls are at the end of the list, and all frames and labels are at the beginning.
*              - Added code to TabProc to automatically increment the control ID, and wrap back to TXT_SOURCE 
*                  if CMD_EXIT is current control.  Now, I just need to implement subclassing for the user 
*                  interactive controls.
*              - Upon startup RAD_REMOVE is checked, with RAD_SIZE and RAD_NUMBER unchecked.
*              - Figured out a relatively clean mechanism to control all control TABbing with TabProc.
*              - TABbing forward through all of the controls works except for cbo_number and cbo_units.
*              - Moved the CBO_REMOVE initialization code into the WndProc function from WinMain.
*              - Changed CBO_UNITS from a DROPDOWN to a DROPDOWNLIST style combo box (like CBO_REMOVE).
*              - Added code to WM_CREATE to initialize CBO_UNITS.
*              - TABbing from CBO_UNITS now works properly.
*              - Made universal the usage of hwnd instead of hWnd.
*              - Added code to the CMD_SOURCE and CMD_DEST buttons to reset the focus to these buttons after 
*                  the respective browse windows have returned.  This fixes a problem with TABbing caused by 
*                  no control having focus.
*              - Added code to WM_CREATE to initialize the list box of CBO_SIZE.
*              - Added code to subclass the edit box of the CBO_SIZE control.  This required me to create a 
*                  CboSizeProc function, as well as doing some odd things in order to get a handle to the edit
*                  box.  However, got it done, and can now TAB forward through ALL of the controls.  The error 
*                  sound does play for a TAB from CBO_SIZE.
*              - By setting the WM_CHAR event in CboSizeProc to return 0 if a TAB is encountered, the error
*                  sound is silenced.
*
* 04 Aug. 1999 - Added some block comments for the hairier and less intuitive sections of code.  Still works.
*              - Reformatted all of the CreateWindow calls in WM_CREATE.  Still works.
*              - Changed the font on the About box.  Still works.
*              - Fixed the problem with TabProc that was causing the application to require two TABs to 
*                  actually move the focus from TXT_NUMBER to TXT_DEST.
*              - Modified TabProc to properly capture the state of the Shift key whenever TAB is pressed.  
*                  This allows reverse as well as forward TABbing through all controls except CB_SIZE.
*              - Modified CboSizeProc to set the focus to CBO_UNITS directly rather than going through the 
*                  WM_SLC32_NEXT message and WndProc.
*              - Removed the WM_SLC32_NEXT definition and message handler in WndProc.
*              - Modified CboSizeProc to properly accommodate reverse as well as forward TABs.  It is now 
*                  possible to cycle forward through the controls with TAB or backward through the controls
*                  with SHIFT+TAB.
*              - By trapping the WM_ACTIVATE message in WndProc, I was able to ensure that control focus was 
*                  preserved even between application switches with either the ALT+TAB or the mouse.
*
* 06 Aug. 1999 - Changed TabProc so that CBO_REMOVE, and CBO_UNITS set focus to TXT_DEST rather than the next
*                  radio button (on TAB).  This behavior is more correct.
*              - Fixed the reverse TAB for CBO_REMOVE and CBO_UNITS.
*              - Fixed the reverse TAB for TXT_DEST so that focus is returned to the control corresponding to 
*                  the checked radio button.
*
* 07 Aug. 1999 - Changed the name from basicwin to slice32.  Rebuilt and it still works.
*              - Reformatted some of the code in TabProc, still works.
*              - Changed the WM_KEYDOWN event processing in TabProc to switch statement from an if structure.
*              - Added code to TabProc to allow the DOWN ARROW to choose between the radio buttons.
*              - Added code to TabProc to allow the UP ARROW to choose between the radio buttons.
*              - Added code to TabProc to set focus to CMD_SOURCE when SHIFT+TAB is hit on a radio button.
*              - Added code to TabProc to properly set the focus from CMD_SOURCE to the currently checked 
*                  radio button.
*
* 08 Aug. 1999 - Established that WndProc is getting the WM_COMMAND messages for CBO_REMOVE, particularly the
*                  CBN_DROPDOWN and CBN_CLOSUP messages.
*              - Added the styles WS_VSCROLL, CBS_OWNERDRAWFIXED, and CBS_HASSTRINGS to the CreateWindow call
*                  for cbo_remove.
*              - WndProc is receiving the WM_MEASUREITEM message for cbo_remove.
*              - Added code to the WM_MEASUREITEM message handler in WndProc to set the vertical height of 
*                  each item in cbo_remove.
*              - To get the cbo_remove combo box to drop down, all I had to do was set the height to be 
*                  greater than the height of the text box, and make sure the WS_VSCROLL style was enabled.  
*                  CBO_REMOVE now drops the way it is supposed to.  Keyboard interface needs to be tweaked.
*              - CBO_SIZE and CBO_UNITS now drop down correctly.
*              - Changed the VK_DOWN key processing in TabProc from an if construct to a switch construct.  
*                  Still works.
*              - Changed the VK_UP key processing in TabProc from an if construct to a switch construct.
*              - Added a default case to the switch statement that controls the return from TabProc.  This 
*                  eliminated a compile warning about TabProc not always exiting.
*              - Added DOWN arrow scrolling through the list items of cbo_remove.
*              - Added UP arrow scrolling through the list items of cbo_remove.
*              - Added UP and DOWN arrow scrolling through the list items of cbo_units.
*              - cbo_size doesn't use the TabProc subclass procedure because it's a true combo box.  Changed 
*                  the VK_TAB code in CboSizeProc to use a switch construct rather than an if construct.
*              - Added code to CboSizeProc to manually process the UP and DOWN arrow keys.  This is necessary 
*                  to allow synchronization of CBO_SIZE with CBO_UNITS.
*              - Added code to CboSizeProc to synchronize the selection of one of the predefined disk sizes
*                  (with the ARROW keys) with CBO_UNITS.  Of course, if you select one with the mouse, it
*                  doesn't sync.
*              - Added code to WndProc to synchronize CBO_UNITS with CBO_SIZE when the CBO_SIZE selection is 
*                  made with a mouse.
*
* 10 Aug. 1999 - When I enabled the UP and DOWN arrow processing on the combo boxes, I broke it on the spinner
*                  control.  This is now fixed.
*              - Reformatted WndProc message processing FSM so all indents are consistent.  Still works.
*              - When the main window was minimized and then restored, focus was not restored to a control, 
*                  but the main window.  Fixed this.  Now, whenever the window is minimized, or moved to the 
*                  background, focus is restored to the appropriate control whenever the application window 
*                  is restored, or back in the foreground.
*              - Reformatted WndProc message processing FSM so all indents are consistent.  Still works.
*              - Changed the code in TabProc's WM_CHAR tab processing from an if to a switch.  Still works.
*              - Enabled the ENTER key to activate the command buttons.  Did this by sending a WM_COMMAND 
*                  message to WndProc via hwnd_main.  Worked GREAT!!
*              - TabProc does receive the WM_KILLFOCUS messages for the subclassed controls.  This message is
*                  currently stubbed with just a break.
*
* 11 Aug. 1999 - Don't need the WM_KILLFOCUS processing in TabProc.  Instead, will trap the EN_KILLFOCUS 
*                  message for the TXT_SOURCE edit control.  This trap goes in the WM_COMMAND processing in 
*                  WndProc.
*              - Installed the EN_KILLFOCUS trap for TXT_SOURCE in the WM_COMMAND processing in WndProc.  
*                  Works, but currently does NO error trapping.
*              - Will need to install a similar trap for BN_KILLFOCUS on CMD_SOURCE in WndProc.  Will need to 
*                  add the BS_NOTIFY style to the CreateWindow call that makes CMD_SOURCE.
*              - Added the BS_NOTIFY style to CMD_SOURCE and CMD_DEST.
*              - Reformatted the CMD_SOURCE code in WndProc to allow trapping of the BN_KILLFOCUS message.
*              - Stubbed in the BN_KILLFOCUS message handler for CMD_SOURCE.
*              - Since I add the BS_NOTIFY style to the CMD_DEST button as well, I also had to reformat it to
*                  trap the BN_KILLFOCUS message in WndProc.  Both CMD_SOURCE and CMD_DEST have the browse 
*                  windows displayed on a BN_CLICKED message.
*              - Fixed TabProc so that if RAD_REMOVE is checked, CBO_REMOVE sends focus to CMD_SLICE rather 
*                  than TXT_DEST.  Minor, but necessary.
*              - The above change in TabProc required another change to handle the TAB and SHIFT+TAB on 
*                  CMD_SLICE.
*              - Removed the WS_VISIBLE style from the LBL_NUMPORTIONS and LBL_SIZEPORTIONS.  These will be 
*                  displayed later in the processing.
*              - In the CreateWindow code for LBL_NUMPORTIONS and LBL_SIZEPORTIONS to NULL.  This will be set
*                  later in the processing.
*              - In the BN_CLICKED processing for RAD_REMOVE, RAD_SIZE, and RAD_NUMBER to control the 
*                  visibility of LBL_NUMPORTIONS and LBL_SIZEPORTIONS.
*              - Filled in the BN_KILLFOCUS coed for CMD_SOURCE.  Currently is the same as the EN_KILLFOCUS 
*                  code for TXT_SOURCE.
*              - Changed the range on the spinner control from 0 to 99 to 1 to 100.
*              - By trapping the EN_CHANGE message for TXT_NUMBER, I was able to get LBL_SIZEPORTIONS 
*                  displaying and synchronized with the SPN_NUMBER control.  Currently, for this to work, a 
*                  valid filename must be in TXT_SOURCE.
*              - By trapping EN_SETFOCUS for TXT_NUMBER, the initial caption for LBL_SIZEPORTIONS is correct.
*
* 12 Aug. 1999 - Removing WS_VISIBLE style from the labels was wrong.  Create them visible, and then hide 
*                  them with a call to ShowWindow in the initial condition setup.  NOTE: I actually did this 
*                  on 11 Aug. 1999, but forgot to note it in the comments for that day.
*              - Added code the the CBN_SELCHANGE code for CBO_SIZE to update LBL_NUMPORTIONS.  Still need to
*                  do this for CBO_UNITS, as well as trapping CBN_EDITCHANGE for CBO_SIZE.
*              - Trapped CBN_SELCHANGE for CBO_UNITS.
*              - Trapped CBN_EDITCHANGE for CBO_SIZE.  Now, when the user enters a size in the edit box 
*                  portion of the combo box, LBL_NUMPORTIONS displays correctly.
*              - Fixed CBN_SELCHANGE for CBO_UNITS to pull the user entered value from CBO_SIZE if present.
*                  Otherwise, it pulls the selected value.
*              - Added code to CBN_SELCHANGE for CBO_UNITS to prevent division by 0 errors.  If sz_portions 
*                  winds up as 0, then it kicks down the units selection by one and remultiplies.
*              - Worked on controlling user flow through the app.  Initially, this means controlling which 
*                  controls are active, and when.
*              - Set the window styles of all controls between RAD_REMOVE and CMD_SLICE (inclusive) to 
*                  WS_DISABLE.  When a control is disabled, it cannot receive focus.
*              - Backed out the WS_DISABLE style - too many problems redrawing the individual controls.  Also 
*                  got rid of the WS_TABSTOP style on all controls.
*
* 13 Aug. 1999 - Prior to beginning the engine integration, renamed all of this code, slc32_ui.*.
*
* 23 Aug. 1999 - NMAKE must be used to build.
*              - Deleted the list of displayed and working controls.
*              - Moved all #defines and function prototypes into slice32.h.
*              - Stubbed in CMD_HELP and CMD_SLICE in WM_COMMAND.
*              - CMD_HELP displays a Message Box when pressed.
*              - Modified slc32lib.c and slice32.h so make_splice32 does not take a src_fil parameter.  That 
*                  was left over from the days of attempting to create a batch file on the fly.
*              - CMD_SLICE now writes SPLICE32.EXE to the destination drive when the RAD_REMOVE button is 
*                  checked.
*              - Moved hwnd_main from Module level globals to a true application global in slcie32.h.
*              - Added call to the actual slice function in the CMD_SLICE button code.
*              - Had to make source_path static so it would keep its value between calls to WndProc.
*
* 24 Aug. 1999 - Added a slice complete message after Slice to Removable Media.
*
* 25 Aug. 1999 - Back to the focus control and guiding the user thru the application.  Added WS_DISABLED 
*                  style to the CreateWindow calls for rad_remove and cbo_remove.
*              - Added code to txt_source and cmd_source to enable and then redraw the rad_remove and 
*                  cbo_remove controls after a valid file has been selected as the source.  The combination 
*                  of EnableWindow and RedrawWindow certainly works nicely for these two.
*              - Turns out RedrawWindow is not necessary, even for the combo boxes.  Added the WS_DISABLED 
*                  style to the CreateWindow calls for rad_size, cbo_size, cbo_units, rad_number, txt_number,
*                  and spn_number.
*              - Also added code to txt_source and cmd_source to enable the entire center Slice method frame
*                  after a valid source file has been selected.
*              - Added WS_DISABLED style to the CreateWindow calls for txt_dest, cmd_dest, and cmd_slice.
*              - Added code to TabProc to enable cmd_slice on exit cbo_remove with a TAB.
*
* 26 Aug. 1999 - Fixed error in cmd_source that allowed the slice method frame controls to be enabled even if
*                  no source file had been selected.
*              - Removed the cmd_slice enable code from the cbo_remove TAB code in TabProc.  cmd_slice gets 
*                  enabled when rad_remove is clicked, and txt_dest and cmd_dest get enabled when either 
*                  rad_size or rad_number are clicked.
*              - Added code to support the enabling and disabling of cmd_slice based on which radio button in
*                  the slice method frame is checked.
*              - Added code to support the enabling and disabling of txt_dest and cmd_dest based on which 
*                  radio button in the slice method frame is checked.
*              - Added the WS_DISABLED style to the CreateWindow calls for lbl_size and lbl_number.
*              - Added EnableWindow calls for lbl_number and lbl_size to the other EnableWindows for the 
*                  slice method frame.
*              - Added three global variables: meth_disabled, dest_disabled, and slic_disabled to track the 
*                  enable/disabled status of the various sections of the application.  Added code at the end
*                  of the WM_CREATE processing in WndProc to set these to TRUE along with the other initial 
*                  settings processing.
*              - In TabProc: Added code to cmd_source to set focus to cmd_help if meth_disabled is TRUE.
*                            Added a CMD_HELP case to the TAB code, and added code to set focus properly
*                              on a SHIFT+TAB based on which controls are enabled or disabled.
*                            Added a CMD_DEST case to the TAB code, and added code to set the focus to 
*                              cmd_help if cmd_slice is disabled.
*                  For the moment, TAB and SHIFT+TAB are working correctly, regardless of the enabled/disabled
*                    state of the main controls.
*              - By trapping the EN_CHANGE message for TXT_SOURCE, I was relieved of the responsibility for 
*                  trapping BN_KILLFOCUS on CMD_SOURCE.
*              - Added code to trap the EN_CHANGE and EN_KILLFOCUS messages for the TXT_DEST control.  
*                  Validation for the contents of TXT_DEST now occurs, and controls the enabled/disabled 
*                  state of CMD_SLICE.
*              - Fixed error in the code that displayed the number of portions required for slicing a file 
*                  into chunks based on the predefined disk sizes.
*              - Added an D2880 entry in slice.h for a 2.88 MB floppy.  Made appropriate modifications to the
*                  cbo_size code.
*
* 05 Sep. 1999 - Since the slice function now accepts a portion_size as the third argument, I changed the 
*                  CMD_SLICE code to pass 0 if slicing to removable media.  Still works.
*              - Changed source_path from static to auto in WndProc.  Was able to do this by adding code to 
*                  CMD_SLICE to retrieve source name from TXT_SOURCE.  Still works.
*              - Changed sz_portions from auto to static in WndProc.
*              - Added code to CMD_SLICE to retrieve the destination folder from TXT_DEST.  This is for 
*                  slicing to a specified number of portions and slicing to portions of a specified size.
*              - Added the code to CMD_SLICE to slice to a specified number of portions or portions of a 
*                  specified size.
*              - Worked.  However, need to add code to CMD_SLICE to append a \ to the destination if not 
*                  present.
*              - Added code to append the \.  It's ugly, but working.
*              - When slicing to a specified number of portions, need to add the size of the slice32 header 
*                  to the calculated portion size.  Did this.  There is still a problem with the number of 
*                  portions required.  It may not be here, but in the actual slice function.  Otherwise, it
*                  works.
*              - Fixed the slicing to specified number of portions portion size calculation problem.  Had to
*                  add back the combined size of each portion's file header, and add one to the portion size
*                  if there was a remainder from the division operation.
*              - Changed the code that appended a \ to the destination if one wasn't present.  Much prettier,
*                  and it still works.
*              - In CMD_SLICE, combined the two if statements that handled RAD_SIZE and RAD_NUMBER into one 
*                  if statement.
*              - By sending an EN_CHANGE message to TXT_NUMBER when RAD_NUMBER is clicked, I was able to get
*                  the LBL_SIZEPORTIONS to update properly on entry.
*              - When I add all of the items to CBO_SIZE, I wasn't setting the first item as the default.  
*                  That is now fixed.
*              - By sending a CBN_SELCHANGE message to CBO_SIZE when RAD_SIZE is clicked, I was able to get 
*                  the LBL_NUMPORTIONS to update properly on entry.
*              - In the CBN_EDITCHANGE code for CBO_SIZE, added code to check for 0 in the edit box, and set
*                  size to 1 if 0 is present.
*              - For CBO_SIZE and CBO_UNITS added code that accounted for the size of the slice32 header 
*                  added to each piece.  In rare circumstances, not accounting for the header would cause an
*                  incorrect number of portions to be calculated.  Also added code to set the number of 
*                  portions to 1 if the size picked is greater than the file size.
*              - LBL_NUMPORTIONS is not getting updated properly when either CBO_SIZE or CBO_UNITS is changed.
*                  This is a matter of trapping the appropriate messages to force the update.
*
* 06 Sep. 1999 - Working on the LBL_NUMPORTIONS update.  Almost done.  Fixed an error in the 
*                  num_portions calculation, and am adding code to prevent a portion size less than the size
*                  of the slice32 header.  Done.
*
* 12 Sep. 1999 - Added code to prevent the number of portions from going over 100 when slicing to portions
*                   of a specified size.
*              - Added code to CMD_HELP to open the stubbed help file.
*
* 13 Sep. 1999 - Source code editing time.  Going with 110 char width.
*              - Block comments all extended, and mostly reformatted.
*
* 18 Sep. 1999 - Worked on setting the window font to the MS Sans Serif - 10 point, rather than the default
*                  fixed pitch system font.  Aesthetics, only, are governing this decision.  Added code to 
*                  the WM_CREATE handler for the main window.  No joy.  Possibly need to do this with the
*                  WM_PAINT message in main?  WM_PAINT in WndProc is definitely not the way to go.
*              - Added WM_PAINT processing to TabProc.  This isn't right either.
*              - Added WM_CREATE processing to TabProc.  No joy.  Abandoned for now.
*              - All revision comments are reformatted to 110 char width.
*              - Removed all need for resrc1.h
*
* 20 Sep. 1999 - Removed GB as a unit in CBO_UNITS.  Also removed all accompanying sizing code.  Still works.
*              - In TabProc, replaced all occurrences of GetParent(hwnd) with hwnd_main.  Still works.
*              - Added Ziff-Davis copyright to all source files.
*              - Removed the message boxes just prior to a slice into portions.
*              - Moved the Slice complete message so it displays regardless of the slice method.
*              - Fixed a bug in the update logic for the CBO_UNITS combo box.  It was updating LBL_NUMPORTIONS
*                  based entirely on the value in CBO_SIZE, and not taking its own state into account.  This
*                  is now working properly.
*              - Made num_portions a static variable in WndProc.
*              - When slicing to portions of a specified size, I moved the code that resizes the portion to 
*                  keep the total number of portions less than or equal to 100 to CBN_KILLFOCUS code for
*                  both CBO_SIZE and CBO_UNITS,  Manually keying in a size works much better, now.
*
* 21 Sep. 1999 - Added issue date of 12/01/1999 to copyright notice in all files.  Set version number to 
*                  1.0 in all source files.
*
* 22 Sep. 1999 - Fixed the width parameter of LBL_NUMPORTIONS.  It was obscuring part of the methods frame.
*              - Doing some experimenting with automatic messagebox retiring in CBO_UNITS and CBO_SIZE.  It
*                  is possible to kill message boxes without user input by adding MB_SETFOREGROUND to their
*                  style, and then using the GetForegroundWindow function to retrieve a handle to the 
*                  MessageBox, and finally calling EndDialog to destroy the modal message box.
*              - Reformatted block comments before static, module level variables, and global variables.
*              - Removed the message box kill code from CBO_SIZE.
*              - Added the MB_SETFOREGROUND style to all MessageBox calls.
*              - Moved th mb_kill function to slc32lib.c
*
* 23 Sep. 1999 - Trapped the slice function return code.  If an error occurs during slice(), then the
*                  slice complete messagebox no longer is displayed.  Rather, a messagebox explaining that
*                  errors were encountered during the slice is displayed.
*              - Added the MB_ICONERROR style to all message boxes in error handlers.
*
* 26 Sep. 1999 - In the WinHelp call, changed the command from HELP_CONTENTS to HELP_FINDER.  Help contents
*                  now displays properly.
*              - Moved the HELP_QUIT WinHelp call from the WM_DESTROY processing, into the CMD_EXIT code.
*                  Help now terminates properly when the application exits, and it's still active.
*              - Added code to disable the slice method frame and CMD_SLICE button if the source file gets
*                  changed to an invalid filename after they have been enabled by an earlier valid name.
*              - Added code to save the source file directory, and use that as the initial directory the
*                  next time CMD_SOURCE is pressed.  If a filename is manually entered before CMD_SOURCE is
*                  clicked, and it is valid, and contains a \, then that directory will be the starting dir
*                  for the browse.  If the filename is valid, does not contain a \, but does contain a :,
*                  then that default drive will be the starting dir for the browse.  If it is valid, and 
*                  does not contain either a \ or a :, then the directory that was current when slice32 was
*                  started is the starting directory for the browse.
*
* 27 Sep. 1999 - Worked on the code to save the source file directory.  My theory on why this is happening
*                  depends on the beta tester having Windows 98/2000 rather than NT 4.0 or lower or 95.
*
* 28 Sep. 1999 - Added an application icon, slice32.ico, and code to load it for while registering the 
*                  window.
*              - Added code to track the application startup directory, and use that as the location for
*                  the help files.  This keeps the help file working regardless of the current directory.
*              - Added code to track the status of the destination folder.  If TXT_DEST contains a valid
*                  directory, then moving back and forth between RAD_SIZE and RAD_NUMBER does not cause
*                  CMD_SLICE to be disabled.
*              - Added code to fix the source destination browse folder memory.  I had to add the same 
*                  code after a successful call to GetOpenFileName that is in the TXT_SOURCE EN_CHANGE and
*                  EN_KILLFOCUS events.
*              - Added code to trap the user hitting CANCEL on the GetOpenFileName call.  If the user hits
*                  cancel, then TXT_SOURCE is not modified, and the remembered source folder is not changed.
*              - Cannot add memory to the CMD_DEST button.  SHBrowseForFolder does not allow you to specify
*                  the starting location in the tree, only the root of the tree.  If I were to save and
*                  restore it, then I would be limiting it to the last folder selected.
*
* 02 Oct. 1999 - Changed the slice32_dir variable to a global variable in slice32.h.  I have to do this in
*                  order to find the startup directory for SLICE32.EXE.  The current working directory
*                  does not work if slice32 was spec'd on the command line, and found by searching the
*                  PATH variable.  init_startup now sets the slice32 startup directory properly.
*              - Began working on controlling the startup browsing directory for SHBrowseForFolder.  Added
*                  a callback function, folder_callback.  Since the remembered destination directory has
*                  to be accessed by both folder_callback and WndProc, it is a global, declared in slice32.h.
*              - Time to make a decision about remembering the source and destination folders across 
*                  invocations.  INI or registry keys.  Registry keys should have automatic removal upon
*                  uninstall.  INI files don't allow easy multiuser control and separation.  INI file wins.
*                  It will be called SLICE32.INI and reside in the same directory as SLICE32.EXE.  Two
*                  functions will support it: write_ini and read_ini.  read_ini will open SLICE32.INI and
*                  read the remembered source and destination paths.  If SLICE32.INI does not exist, then
*                  read_ini will set the source path to the current directory, and the destination path
*                  to a string of NULLS.  write_ini will be invoked when the program exits, and will always
*                  overwrite the existing SLICE32.INI.  For this to work, the remembered source path must
*                  be as global as the remembered destination path.  I renamed it to slice32_source from
*                  old_source_path, and moved it to slice32.h.
*              - Created write_ini in slc32lib.c.  Added a call to it in the CMD_EXIT processing.
*              - Copied the CMD_EXIT processing to WM_DESTROY processing.  No matter how the application is
*                  terminated, SLICE32.INI will be written, and HELP will be shut down properly.
*              - Created read_ini in slc32lib.c.  Added a call to it in the WM_CREATE processing.
*
* 05 Oct. 1999 - Source editing.  Comment reformatting, etc.
*              - Removed #include <dbt.h>.  Hasn't been used since before beta 0.6.
*
* 27 Oct. 1999 - If you delete the value in txt_number, a Divide by zero error is generated.  Wrapped the
*                  portion size calculation in an if statement to prevent calculation if num_portions is 0.
*              - It is possible to manually enter a number greater than 101 into txt_number (not using the
*                  spinner.  Added code to check for numbers larger than 100 prior to calculating portion
*                  size.
*              - It should not be possible to slice into a single piece.  Corrected the lower limit on the
*                  CreateUpDownControl call,  That fixes only part of the problem.  The user should not be
*                  able to enter 1 as the number of destination pieces.  Trapped the EN_KILLFOCUS event for
*                  txt_number, and had it check for 0 or 1 as the number of portions.  If it is, then the
*                  number of portions is set to 2, the portion size is recalced, and the label is updated.
*                  This allows the value to be temporarily 0 or 1 (while the user is entering data).
*              - If the user had selected a valid file, picked one of the slice methods, and then selected a
*                  new file, the "XXXX portions required" and "Portions will be XXXX bytes" labels were not 
*                  updated.  Added code to the EN_CHANGE code for TXT_SOURCE to refresh these.
*              - The user should not be allowed to enter anything except numbers and one decimal point into
*                  cbo_size.  Replaced the switch statement in the WM_CHAR processing in CboSizeProc with a
*                  series of if statements to block everything except the control characters, one decimal
*                  point and the digits 0-9.
*              - When slicing to portions of a specified size, and the program has to change the portion
*                  size to keep the number of portions less than or equal to 100, the n lbl_numportions does
*                  not update properly.  This was caused by the CBN_SELCHANGE message sent to cbo_size when
*                  rad_size got selected.  Changed that to a CBN_EDITCHANGE, and fixed the problem.
*              - Changed the starting selection for cbo_units from bytes to KB.
*              - Changed the CBN_EDITCHANGE code for CBO_SIZE to not default the units to bytes when the user
*                  begins to manually modify the size.  This necessitated selecting bytes as the units during
*                  the CBN_KILLFOCUS processing if num_portions has to be forced to 100.
*              - If the user deletes the entry in the text box portion of cbo_size, then the units get set
*                  to bytes, and the slice doesn't work properly.  Added code to the CBN_EDITCHANGE event
*                  of cbo_size to make sure it never goes below 1.
*
* 28 Oct. 1999 - Added code to prevent a user from entering anything except a control character or digit into
*                  txt_number.  A default case for the WM_CHAR processing in TabProc took care of this.
*
* 31 Oct. 1999 - Changed the cmd_slice code from a pair of sequential if statements (if rad_remove checked
*                  followed by an if rad_number or rad_size checked) to an if/else statement.  This allows
*                  the user to get ready to slice another file while the current slice is happening.
*              - Added code to disable and enable the cmd_slice button before and after a slice operation.
*              - Added code to disable and enable the cmd_exit button before and after a slice operation.
*              - Added code to write the stored destination directory (from SLICE32.TXT) into txt_dest 
*                  upon startup.
*
* 01 Nov. 1999 - The slice function now returns 246 to indicate the operation was cancelled.  Added code to 
*                  cmd_slice processing to trap this appropriately.
*
* NMAKE to build it all.
************************************************************************************************************/
#include <stdio.h>                                              /* Used in all C programs */
#include <stdlib.h>                                             /* Used in all C programs */
#include <string.h>                                             /* strchr(), etc. */
#include <math.h>                                               /* floor() */

#include <windows.h>                                            /* Used in all Win32 programs */
#include <winnt.h>                                              /* Used in all Win32 programs */
#include <winbase.h>                                            /* Used in all Win32 programs */
#include <shlobj.h>                                             /* SHBrowseForFolder */
#include <commdlg.h>                                            /* GetOpenFileName */
#include <commctrl.h>                                           /* Common controls */

#include "slice32.h"

/* Application name */
char             szProgName[]="Slice32";

/************************************************************************************************************
* Static, module level variables.
*   All of the *_old WNDPROCs are the original control handler for the subclassed controls.
*   cbo_size_edit is the window handle for the edit box of the cbo_size combo box.  
*   hInstance is required to create the Modal About dialog box in the CMD_ABOUT section of the WM_COMMAND 
*     event in WndProc.
************************************************************************************************************/
static WNDPROC   txt_source_old;
static WNDPROC   cmd_source_old;
static WNDPROC   rad_remove_old;
static WNDPROC   cbo_remove_old;
static WNDPROC   rad_size_old;
static WNDPROC   cbo_size_old;                                  /* This is the edit box default */
static WNDPROC   cbo_units_old;
static WNDPROC   rad_number_old;
static WNDPROC   txt_number_old;
static WNDPROC   spn_number_old;
static WNDPROC   txt_dest_old;
static WNDPROC   cmd_dest_old;
static WNDPROC   cmd_slice_old;
static WNDPROC   cmd_help_old;
static WNDPROC   cmd_about_old;
static WNDPROC   cmd_exit_old;
static HWND      cbo_size_edit;                                 /* CBO_SIZE edit box */
static HINSTANCE hInstance;                                     /* Req'd to display ABOUTBOX */

/************************************************************************************************************
* Global variables used to track which controls are active and which are inactive.  These are initially set 
*   at the end of the WM_CREATE processing in WndProc.
*   meth_disabled starts out TRUE.  It means that all of the controls in the slice method frame are disabled.
*   dest_disabled starts out TRUE.  It means that all of the controls in the destination frame are disabled.
*   slic_disabled starts out TRUE.  It means cmd_slice is disabled.
************************************************************************************************************/
BOOL             meth_disabled;
BOOL             dest_disabled;
BOOL             slic_disabled;

/************************************************************************************************************
* This one tracks the status of the destination text box.  If it contains a valid directory, then valid_dest
*   is TRUE.  Otherwise, it's FALSE.
************************************************************************************************************/
BOOL             valid_dest;

/************************************************************************************************************
* WinMain: Registers the application window class
*          Retrieves the screen height and width
*          Creates the application window in the center of the screen
*          Displays the application window
*          Makes sure the common control dll is loaded
*          Initiates the application event loop
************************************************************************************************************/
int PASCAL WinMain(HINSTANCE hInst,HINSTANCE hPreInst,LPSTR lpszCmdLine,int nCmdShow) {
  unsigned long  screen_x;                                      /* Screen width in pixels */
  unsigned long  screen_y;                                      /* Screen height in pixels */
  HWND           hwnd;                                          /* Main window */
  MSG            lpMsg;                                         /* For the Main window */
  WNDCLASS       wcApp;                                         /* Main window */

  if(!hPreInst) {
    wcApp.lpszClassName=szProgName;
    wcApp.hInstance=hInst;
    wcApp.lpfnWndProc=WndProc;                                  /* Main window event handler */
    wcApp.hCursor=LoadCursor(NULL,IDC_ARROW);
    wcApp.hIcon=LoadIcon(hInst,MAKEINTRESOURCE(IDI_ICON1));     /* Slice32.ico */
    wcApp.lpszMenuName=NULL;
    wcApp.hbrBackground=GetStockObject(LTGRAY_BRUSH);           /* Light Gray background */
    wcApp.style=CS_HREDRAW|CS_VREDRAW;
    wcApp.cbClsExtra=0;
    wcApp.cbWndExtra=0;

    if(!RegisterClass(&wcApp))
      return(FALSE);
  }

  /**********************************************************************************************************
  * Get the screen height and width so the window can be centered during the CreateWindow call.
  **********************************************************************************************************/
  screen_x=GetSystemMetrics(SM_CXSCREEN);
  screen_y=GetSystemMetrics(SM_CYSCREEN);

  /**********************************************************************************************************
  * Create the main window, display it, and initialize the global handle to it.
  **********************************************************************************************************/
  hwnd=CreateWindow(szProgName,"Slice32",WS_MINIMIZEBOX|WS_OVERLAPPED|WS_SYSMENU,(screen_x-SLC_WDT)/2,\
                    (screen_y-SLC_HGT)/2,SLC_WDT,SLC_HGT,(HWND)NULL,(HMENU)NULL,(HANDLE)hInst,(LPSTR)NULL);
  ShowWindow(hwnd,SW_SHOW);                                     /* Display the main window */
  hwnd_main=hwnd;                                               /* Req'd for cbo_size subclass */
  
  InitCommonControls();                                         /* Common control dll loaded */

  while(GetMessage(&lpMsg,NULL,0,0)) {                          /* Main window event processing loop */
    TranslateMessage(&lpMsg);
    DispatchMessage(&lpMsg);
  }

  return(lpMsg.wParam);                                         /* Application exits */
}

/************************************************************************************************************
* Event processing function for main window.  The actual user interface processing is primarily split
*   between WndProc and TabProc.  There are a lot of static variables because this function gets called for
*   each message sent to the main window.  If these variables weren't static, then the state would not get
*   preserved, and bizarre things would happen (like none of the child windows working properly).
************************************************************************************************************/
LONG FAR PASCAL WndProc(HWND hwnd,UINT messg,WPARAM wParam,LPARAM lParam) {
  static HWND            fra_source;                            /* Select source frame */
  static HWND            txt_source;                            /* Source text box */
  static HWND            cmd_source;                            /* Source browse button */
  static HWND            fra_dest;                              /* Select destination frame */
  static HWND            txt_dest;                              /* Destination text box */
  static HWND            cmd_dest;                              /* Destination browse button */
  static HWND            cmd_slice;                             /* Slice button */
  static HWND            cmd_exit;                              /* Exit button */
  static HWND            cmd_about;                             /* About button */
  static HWND            cmd_help;                              /* Help button */ 
  static HWND            fra_method;                            /* Slice method frame */ 
  static HWND            rad_remove;                            /* Slice to removable radio btn */
  static HWND            rad_size;                              /* Slice to sized pcs radio btn */
  static HWND            rad_number;                            /* Slice to num of pcs radio btn */
  static HWND            cbo_remove;                            /* Removable drive combo box */
  static HWND            cbo_size;                              /* Size combo box */
  static HWND            cbo_units;                             /* Units combo box */
  static HWND            txt_number;                            /* Number of pieces text box */
  static HWND            lbl_size;                              /* Sized pieces label */
  static HWND            lbl_number;                            /* Number of pieces label */
  static HWND            lbl_numportions;                       /* Number of portions required */
  static HWND            lbl_sizeportions;                      /* Size of each portion */
  static HWND            spn_number;                            /* TXT_NUMBER spinner */
  static HWND            act_control;                           /* Used in WM_ACTIVATE processing */
  static char           *src_browse_path;                       /* Preserve the last source folder browsed */
  static char           *src_tmp;                               /* Scratch pointer */
  static char            help_path[MAX_PATH+MAX_PATH+1];        /* Help file path and name */
  static int             cxchar;                                /* Window width in dialog units */
  static int             cychar;                                /* window height in dialog units */
  static long            src_size_lo;                           /* Size of input file - lo dword */
  static long            src_size_hi;                           /* Size of input file - hi_dword */
  static long            sz_portions;                           /* Size of portions in RAD_SIZE set */
  static long            num_portions;                          /* Number of portions in TXT_NUMBER */
  static BOOL            minimized=FALSE;                       /* Is main window minimized? */
  static BOOL            slicing;                               /* TRUE=middle of slice, FALSE=not */
  static BROWSEINFO      dest_browse;                           /* Parameters for ShBrowseForFolder */
  unsigned char          destination[MAX_PATH+1];               /* TXT_DEST string */
  unsigned char          source_path[MAX_PATH+1];               /* TXT_SOURCE string */
  unsigned char          source_title[MAX_PATH+1];              /* source filename only */
  unsigned char          lbl_msg[256];                          /* Label captions */
  unsigned char          drv_letter;                            /* Bare drive letter */
  unsigned char         *drv_root="_:";                         /* Used to find local removable drives */
  unsigned int           drv_type;                              /* Return value from GetDriveType */
  unsigned long          slice_ret;                             /* Slice function return */
  long                   local_drives=0;                        /* Return from GetLogicalDrives */
  long                   dest_attr;                             /* Used to validate TXT_DEST */
  long                   temp_long;                             /* Used in RAD_SIZE processing */
  double                 tmp_sz;                                /* Used in RAD_SIZE processing */
  BOOL                   tfrtc;                                 /* Win32 boolean return value */
  LPITEMIDLIST           dest_browse_return;                    /* Return from SHBrowseForFolder */
  HANDLE                 src_file;                              /* Used to get file size */
  LPMALLOC               dest_shell_stuff;                      /* Shell allocation return */
  OPENFILENAME           source_browser_open;                   /* Parameters for GetOpenFileName */
  POINT                  cbo_edit_coord;                        /* Used to subclass CBO_SIZE edit box */
  RECT                   cbo_size_coord;                        /* Used to subclass CBO_SIZE edit box */

  switch(messg) {
       /*****************************************************************************************************
       * If either ALT+TAB or the mouse is used to switch to another application, then the WM_ACTIVATE 
       *   message gets sent to WndProc with wParam set to WM_INACTIVE.  When that occurs, this event handler 
       *   stores the current control to act_control with GetFocus.  When the user switches back, WM_ACTIVATE 
       *   gets sent with wParam set to WA_ACTIVE.  When this happens, the event handler sets the focus back 
       *   to act_control with SetFocus.  act_control gets initialized to TXT_SOURCE in WM_CREATE during the 
       *   set initial conditions processing.  If the window is currently minimized or in the process of
       *   minimizing, then the WA_INACTIVE processing does nothing.
       *****************************************************************************************************/
       case WM_ACTIVATE   : if(LOWORD(wParam)==WA_INACTIVE) {   /* Focus switched to another application */
                              if(minimized==FALSE)              /* If we're not minimized */
                                act_control=GetFocus();         /* Save the current control */
                            }
                            else                                /* If focus is returning from another app */
                              SetFocus(act_control);            /* Activate the saved control */
                            return 0;
                            break; 
       /*****************************************************************************************************
       * If the system menu is used to minimize the application, then the current control must be saved so 
       *   that focus can be restored when the window is restored.  Also need to set the minimized flag to 
       *   TRUE so the WM_ACTIVATE:WA_INACTIVE trap doesn't try to save the control state.  Need to exit
       *   this event with a call to the Default Window Procedure so all the other system menu items work.
       *****************************************************************************************************/
       case WM_SYSCOMMAND : switch(wParam) {
                              case SC_MINIMIZE : act_control=GetFocus();
                                                 minimized=TRUE;
                                                 break;
                            }
                            return DefWindowProc(hwnd,messg,wParam,lParam);
                            break;
       /*****************************************************************************************************
       * When the minimized application window is restored, set the minimized flag to FALSE.
       *****************************************************************************************************/
       case WM_SIZE       : switch(wParam) {
                              case SIZE_RESTORED  : minimized=FALSE;
                                                    break;
                            }
                            return 0;
                            break;
       /*****************************************************************************************************
       * Process user interactive control events.
       *****************************************************************************************************/
       case WM_COMMAND    : switch(LOWORD(wParam)) {
                              /******************************************************************************
                              * CMD_EXIT button pressed.  Exit the application as if a WM_DESTROY message was
                              *   sent and processed.  Before then, close all HELP windows, and update the
                              *   SLICE32.INI file.
                              ******************************************************************************/
                              case CMD_EXIT   : tfrtc=WinHelp(hwnd,"slice32.hlp",HELP_QUIT,0);
                                                write_ini();
                                                PostQuitMessage(0);
                                                break;
                              /******************************************************************************
                              * CMD_ABOUT button pressed.  Display the ABOUT dialog box.
                              ******************************************************************************/
                              case CMD_ABOUT  : DialogBox(hInstance,TEXT("AboutBox"),hwnd,AboutDialogProc);
                                                break;
                              /******************************************************************************
                              * CMD_HELP button pressed.  Display the help file.
                              ******************************************************************************/
                              case CMD_HELP   : tfrtc=WinHelp(hwnd,help_path,HELP_FINDER,0);
                                                if(tfrtc==FALSE)
                                                  MessageBox(hwnd,"HELP Error","Slice32 - Error",MB_SETFOREGROUND|MB_OK);
                                                break;
                              /******************************************************************************
                              * CMD_SLICE button pressed.  Decide which type of slicing we're going to do,
                              *   retrieve the destination, and slice it.
                              ******************************************************************************/
                              case CMD_SLICE  : /************************************************************
                                                * Get the source file name and path from TXT_SOURCE.
                                                ************************************************************/
                                                memset(source_path,'\0',MAX_PATH+1);
                                                SendMessage(txt_source,WM_GETTEXT,MAX_PATH+1,\
                                                            (LPARAM)source_path);
                                                /************************************************************
                                                * If we're slicing to removable media, then cbo_remove has
                                                *   the destination.
                                                ************************************************************/
                                                if(SendMessage(rad_remove,BM_GETCHECK,0,0)==BST_CHECKED) {
                                                  memset(destination,'\0',MAX_PATH+1);
                                                  SendMessage(cbo_remove,CB_GETLBTEXT,\
                                                              SendMessage(cbo_remove,CB_GETCURSEL,0,0),\
                                                              (LPARAM)destination);
                                                  tfrtc=EnableWindow(cmd_slice,FALSE);
                                                  tfrtc=EnableWindow(cmd_exit,FALSE);
                                                  slicing=TRUE;
                                                  slice_ret=slice(source_path,destination,0L);
                                                  slicing=FALSE;
                                                  if(SendMessage(rad_size,BM_GETCHECK,0,0)==BST_CHECKED) {
                                                    SetFocus(txt_dest);
                                                  }
                                                  else if(SendMessage(rad_number,BM_GETCHECK,0,0)==BST_CHECKED) {
                                                    SetFocus(txt_dest);
                                                  }
                                                  else {
                                                    tfrtc=EnableWindow(cmd_slice,TRUE);
                                                  }
                                                  tfrtc=EnableWindow(cmd_exit,TRUE);
                                                }
                                                /************************************************************
                                                * If we're slicing to portions of a specified size, or a
                                                *   specified number of portions, TXT_DEST has destination.
                                                ************************************************************/
                                                else {
                                                  memset(destination,'\0',MAX_PATH+1);
                                                  SendMessage(txt_dest,WM_GETTEXT,MAX_PATH+1,\
                                                              (LPARAM)destination);
                                                  if(destination[strlen(destination)-1]!='\\') {
                                                    strcat(destination,"\\");
                                                  }
                                                  tfrtc=EnableWindow(cmd_slice,FALSE);
                                                  tfrtc=EnableWindow(cmd_exit,FALSE);
                                                  slicing=TRUE;
                                                  slice_ret=slice(source_path,destination,sz_portions);
                                                  slicing=FALSE;
                                                  if(SendMessage(rad_size,BM_GETCHECK,0,0)==BST_CHECKED) {
                                                    SetFocus(txt_dest);
                                                  }
                                                  else if(SendMessage(rad_number,BM_GETCHECK,0,0)==BST_CHECKED) {
                                                    SetFocus(txt_dest);
                                                  }
                                                  else {
                                                    tfrtc=EnableWindow(cmd_slice,TRUE);
                                                  }
                                                  tfrtc=EnableWindow(cmd_exit,TRUE);
                                                }
                                                /************************************************************
                                                * If slice succeeded, display success message.
                                                ************************************************************/
                                                if(slice_ret==0) {
                                                  memset(lbl_msg,'\0',256);
                                                  sprintf(lbl_msg,"Slice %s to %s is complete",source_path,\
                                                          destination);
                                                  MessageBox(hwnd,lbl_msg,"Slice32 - Slice Complete",\
                                                             MB_SETFOREGROUND|MB_OK);
                                                }
                                                /************************************************************
                                                * If slice was cancelled, indicate that.
                                                ************************************************************/
                                                else if(slice_ret==246) {
                                                  memset(lbl_msg,'\0',256);
                                                  sprintf(lbl_msg,"Slice %s to %s was cancelled",source_path,\
                                                          destination);
                                                  MessageBox(hwnd,lbl_msg,"Slice32 - Slice Cancelled",\
                                                             MB_SETFOREGROUND|MB_OK);
                                                }
                                                /************************************************************
                                                * Otherwise, display error message.
                                                ************************************************************/
                                                else {
                                                  memset(lbl_msg,'\0',256);
                                                  sprintf(lbl_msg,\
                                                          "Errors were encountered while Slicing %s to %s",\
                                                          source_path,destination);
                                                  MessageBox(hwnd,lbl_msg,"Slice32 - Slice Error",\
                                                             MB_ICONERROR|MB_SETFOREGROUND|MB_OK);
                                                }
                                                break;
                              /******************************************************************************
                              * TXT_SOURCE is the edit box for the source file name and path.  Whenever the
                              *   contents change, or the control loses focus, we need to do things.
                              ******************************************************************************/
                              case TXT_SOURCE : switch(HIWORD(wParam)) {
                                                  case EN_CHANGE    :
                                                  case EN_KILLFOCUS : memset(source_path,'\0',MAX_PATH+1);
                                                                      /**************************************
                                                                      * Retrieve source path and filename.
                                                                      **************************************/
                                                                      SendMessage(txt_source,WM_GETTEXT,\
                                                                                  MAX_PATH+1,\
                                                                                  (LPARAM)source_path);
                                                                      /**************************************
                                                                      * Attempt to open source file.
                                                                      **************************************/
                                                                      src_file=CreateFile(source_path,\
                                                                                          GENERIC_READ,\
                                                                                          0,\
                                                                                          NULL,\
                                                                                          OPEN_EXISTING,\
                                                                                          FILE_ATTRIBUTE_NORMAL,\
                                                                                          NULL);
                                                                      /**************************************
                                                                      * If the file opens, get it's size, 
                                                                      *   close the file, enable the slice
                                                                      *   method controls, refresh the size
                                                                      *   and portion labels, and save the
                                                                      *   path as the starting point for the
                                                                      *   next browse.
                                                                      **************************************/
                                                                      if(src_file!=INVALID_HANDLE_VALUE) {
                                                                        src_size_lo=GetFileSize(src_file,\
                                                                                                &src_size_hi);
                                                                        tfrtc=CloseHandle(src_file);
                                                                        tfrtc=EnableWindow(rad_remove,TRUE);
                                                                        tfrtc=EnableWindow(cbo_remove,TRUE);
                                                                        tfrtc=EnableWindow(rad_size,TRUE);
                                                                        tfrtc=EnableWindow(cbo_size,TRUE);
                                                                        tfrtc=EnableWindow(cbo_units,TRUE);
                                                                        tfrtc=EnableWindow(rad_number,TRUE);
                                                                        tfrtc=EnableWindow(txt_number,TRUE);
                                                                        tfrtc=EnableWindow(spn_number,TRUE);
                                                                        tfrtc=EnableWindow(lbl_size,TRUE);
                                                                        tfrtc=EnableWindow(lbl_number,TRUE);
                                                                        if(slicing==FALSE) {
                                                                          tfrtc=EnableWindow(cmd_slice,TRUE);
                                                                          slic_disabled=FALSE;
                                                                        }
                                                                        meth_disabled=FALSE;
                                                                        SendMessage(hwnd,WM_COMMAND,\
                                                                          (EN_CHANGE<<16)+TXT_NUMBER,\
                                                                          (LPARAM)txt_number);
                                                                        SendMessage(hwnd,WM_COMMAND,\
                                                                          (CBN_SELCHANGE<<16)+CBO_UNITS,\
                                                                          (LPARAM)cbo_units);
                                                                        /************************************
                                                                        * Save the path as the starting place
                                                                        *   for the next browse.
                                                                        ************************************/
                                                                        memset(slice32_source,'\0',MAX_PATH+1);
                                                                        strcpy(slice32_source,source_path);
                                                                        src_tmp=strrchr(slice32_source,'\\');
                                                                        if(src_tmp!=NULL) {
                                                                          *src_tmp='\0';
                                                                          src_browse_path=slice32_source;
                                                                        }
                                                                        else {
                                                                          src_tmp=strrchr(slice32_source,':');
                                                                          if(src_tmp!=NULL) {
                                                                            src_tmp++;
                                                                            *src_tmp='\0';
                                                                            src_browse_path=slice32_source;
                                                                          }
                                                                          else {
                                                                            src_browse_path=slice32_dir;
                                                                          }
                                                                        }
                                                                      }
                                                                      /**************************************
                                                                      * If the file doesn't open, make sure
                                                                      *   the slice method controls are
                                                                      *   disabled.
                                                                      **************************************/
                                                                      else {
                                                                        memset(source_path,'\0',MAX_PATH+1);
                                                                        tfrtc=SetCurrentDirectory(slice32_dir);
                                                                        tfrtc=EnableWindow(rad_remove,FALSE);
                                                                        tfrtc=EnableWindow(cbo_remove,FALSE);
                                                                        tfrtc=EnableWindow(rad_size,FALSE);
                                                                        tfrtc=EnableWindow(cbo_size,FALSE);
                                                                        tfrtc=EnableWindow(cbo_units,FALSE);
                                                                        tfrtc=EnableWindow(rad_number,FALSE);
                                                                        tfrtc=EnableWindow(txt_number,FALSE);
                                                                        tfrtc=EnableWindow(spn_number,FALSE);
                                                                        tfrtc=EnableWindow(lbl_size,FALSE);
                                                                        tfrtc=EnableWindow(lbl_number,FALSE);
                                                                        tfrtc=EnableWindow(cmd_slice,FALSE);
                                                                        meth_disabled=TRUE;
                                                                        slic_disabled=TRUE;
                                                                      }
                                                                      break;
                                                }
                                                break;
                              /******************************************************************************
                              * CMD_SOURCE (source file browse button) pressed.  Use GetOpenFileName to
                              *   display a standard file open dialog box for the user.
                              ******************************************************************************/
                              case CMD_SOURCE : switch(HIWORD(wParam)) {
                                                  case BN_CLICKED   : memset(source_path,'\0',MAX_PATH+1);
                                                                      memset(source_title,'\0',MAX_PATH+1);
                                                                      source_browser_open.lStructSize=\
                                                                        sizeof(OPENFILENAME);
                                                                      source_browser_open.hwndOwner=hwnd;
                                                                      source_browser_open.hInstance=NULL;
                                                                      source_browser_open.lpstrFilter=NULL;
                                                                      source_browser_open.lpstrCustomFilter=NULL;
                                                                      source_browser_open.nMaxCustFilter=0;
                                                                      source_browser_open.nFilterIndex=0;
                                                                      source_browser_open.lpstrFile=source_path;
                                                                      source_browser_open.nMaxFile=MAX_PATH;
                                                                      source_browser_open.lpstrFileTitle=source_title;
                                                                      source_browser_open.nMaxFileTitle=MAX_PATH;
                                                                      source_browser_open.lpstrInitialDir=src_browse_path;
                                                                      source_browser_open.lpstrTitle=NULL;
                                                                      source_browser_open.Flags=\
                                                                        OFN_FILEMUSTEXIST|OFN_PATHMUSTEXIST;
                                                                      source_browser_open.nFileOffset=0;
                                                                      source_browser_open.nFileExtension=0;
                                                                      source_browser_open.lpstrDefExt=NULL;
                                                                      source_browser_open.lCustData=0L;
                                                                      source_browser_open.lpfnHook=NULL;
                                                                      source_browser_open.lpTemplateName=NULL;
                                                                      tfrtc=GetOpenFileName(&source_browser_open);
                                                                      /**************************************
                                                                      * If the user selected a file, get it,
                                                                      *   and save the path as the starting
                                                                      *   point for the next browse.
                                                                      **************************************/
                                                                      if(tfrtc==TRUE) {
                                                                        SendMessage(txt_source,WM_SETTEXT,0,\
                                                                                    (LPARAM)(LPCTSTR)source_path);
                                                                        memset(slice32_source,'\0',MAX_PATH+1);
                                                                        strcpy(slice32_source,source_path);
                                                                        src_tmp=strrchr(slice32_source,'\\');
                                                                        if(src_tmp!=NULL) {
                                                                          *src_tmp='\0';
                                                                          src_browse_path=slice32_source;
                                                                        }
                                                                        else {
                                                                          src_tmp=strrchr(slice32_source,':');
                                                                          if(src_tmp!=NULL) {
                                                                            src_tmp++;
                                                                            *src_tmp='\0';
                                                                            src_browse_path=slice32_source;
                                                                          }
                                                                          else {
                                                                            src_browse_path=slice32_dir;
                                                                          }
                                                                        }
                                                                        src_browse_path=slice32_source;
                                                                      }
                                                                      /**************************************
                                                                      * Return focus to button after browse.
                                                                      **************************************/
                                                                      SetFocus(cmd_source);
                                                                      break;
                                                }
                                                break;
                              /******************************************************************************
                              * TXT_DEST is the edit box for the destination folder path.  Processing is
                              *   similar to TXT_SOURCE.  Need to know when it changes, and when it loses
                              *   focus.
                              ******************************************************************************/
                              case TXT_DEST   : switch(HIWORD(wParam)) {
                                                  case EN_CHANGE    :
                                                  case EN_KILLFOCUS : memset(destination,'\0',MAX_PATH+1);
                                                                      SendMessage(txt_dest,WM_GETTEXT,\
                                                                                  MAX_PATH+1,\
                                                                                  (LPARAM)destination);
                                                                      dest_attr=GetFileAttributes(destination);
                                                                      /**************************************
                                                                      * If destination is a valid directory,
                                                                      *   enable CMD_SLICE, and save dir as
                                                                      *   the starting place for next browse.
                                                                      **************************************/
                                                                      if(dest_attr!=0xFFFFFFFF && \
                                                                         dest_attr&FILE_ATTRIBUTE_DIRECTORY) {
                                                                        tfrtc=EnableWindow(cmd_slice,TRUE);
                                                                        valid_dest=TRUE;
                                                                        slic_disabled=FALSE;
                                                                        memset(slice32_dest,'\0',MAX_PATH);
                                                                        strcpy(slice32_dest,destination);
                                                                      }
                                                                      /**************************************
                                                                      * If destination is invalid directory,
                                                                      *   disable CMD_SLICE.
                                                                      **************************************/
                                                                      else {
                                                                        tfrtc=EnableWindow(cmd_slice,FALSE);
                                                                        valid_dest=FALSE;
                                                                        slic_disabled=TRUE;
                                                                      }
                                                                      break;
                                                }
                                                break;
                              /******************************************************************************
                              * CMD_DEST (destination folder browse button) pressed.
                              ******************************************************************************/
                              case CMD_DEST   : switch(HIWORD(wParam)) {
                                                  case BN_CLICKED   : /**************************************
                                                                      * If the shell can allocate memory.
                                                                      **************************************/
                                                                      if(SHGetMalloc(&dest_shell_stuff)==\
                                                                         NOERROR) {
                                                                        dest_browse.hwndOwner=hwnd;
                                                                        dest_browse.pidlRoot=NULL;
                                                                        dest_browse.pszDisplayName=0;
                                                                        dest_browse.lpszTitle=\
                                                                          "Select Destination Folder for SLICE";
                                                                        dest_browse.ulFlags=BIF_RETURNONLYFSDIRS;
                                                                        /************************************
                                                                        * Per July, 1999 MSDN library, call-
                                                                        *   back function allows specifying
                                                                        *   starting folder in browse.
                                                                        *   Article ID: Q179378
                                                                        ************************************/
                                                                        dest_browse.lpfn=folder_callback;
                                                                        dest_browse_return=SHBrowseForFolder\
                                                                                             (&dest_browse);
                                                                        /************************************
                                                                        * If user selected a folder, convert
                                                                        *   ID to path, display it in
                                                                        *   TXT_DEST, and then free ID list.
                                                                        ************************************/
                                                                        if(dest_browse_return) {
                                                                          if(SHGetPathFromIDList(\
                                                                             dest_browse_return,destination)) {
                                                                            SendMessage(GetDlgItem(hwnd,TXT_DEST),\
                                                                                        WM_SETTEXT,0,\
                                                                                        (LPARAM)(LPCTSTR)destination);
                                                                          }
                                                                          dest_shell_stuff->lpVtbl->Free(\
                                                                            dest_shell_stuff,dest_browse_return);
                                                                          dest_shell_stuff->lpVtbl->Release(\
                                                                            dest_shell_stuff);
                                                                        }
                                                                      }
                                                                      /**************************************
                                                                      * Return focus to button after browse.
                                                                      **************************************/
                                                                      SetFocus(cmd_dest);
                                                                      break;
                                                }
                                                break;
                              /******************************************************************************
                              * CBO_SIZE combo box code.
                              ******************************************************************************/
                              case CBO_SIZE  :  switch(HIWORD(wParam)) {
                                                  /**********************************************************
                                                  * If the user enters a number in the edit box, get the 
                                                  *   number, and calc the portion size.
                                                  **********************************************************/
                                                  case CBN_EDITCHANGE : memset(lbl_msg,'\0',256);
                                                                        SendMessage(cbo_size,WM_GETTEXT,256,\
                                                                                    (LPARAM)lbl_msg);
                                                                        tmp_sz=atof(lbl_msg);
                                                                        /************************************
                                                                        * If the entered number is less than
                                                                        *   1, set the size to 1 and update
                                                                        *   the edit box.
                                                                        ************************************/
                                                                        if(tmp_sz<1.0) {
                                                                          tmp_sz=1.0;
                                                                          memset(lbl_msg,'\0',256);
                                                                          sprintf(lbl_msg,"%1.lf",tmp_sz);
                                                                          SendMessage(cbo_size,WM_SETTEXT,0,\
                                                                            (LPARAM)lbl_msg);
                                                                        }
                                                                        switch(SendMessage(cbo_units,\
                                                                               CB_GETCURSEL,0,0)) {
                                                                          case 0 : sz_portions=\
                                                                                     (int)floor(tmp_sz);
                                                                                   break;
                                                                          case 1 : sz_portions=\
                                                                                     (int)floor(tmp_sz*1024);
                                                                                   break;
                                                                          case 2 : sz_portions=\
                                                                                     (int)floor(tmp_sz*1048576);
                                                                                   break;
                                                                        }
                                                                        break;
                                                  /**********************************************************
                                                  * When it loses focus, check to see if the number of 
                                                  *   portions is greater than 100.  If it is, then recalc
                                                  *   the size for exactly 100 portions, and redisplay.
                                                  **********************************************************/
                                                  case CBN_KILLFOCUS  : if(num_portions>100) {
                                                                          MessageBox(hwnd_main,\
                                                                            "Number of Portions MUST be less than 100 - Resizing",\
                                                                            "Slice32",MB_SETFOREGROUND|MB_OK);
                                                                          temp_long=src_size_lo+\
                                                                             (sizeof(struct slice32_header)*100);
                                                                          temp_long/=100;
                                                                          if((src_size_lo%100)>0)
                                                                            temp_long++;
                                                                          memset(lbl_msg,'\0',256);
                                                                          sprintf(lbl_msg,"%ld",temp_long);
                                                                          SendMessage(cbo_size,WM_SETTEXT,\
                                                                            0,(LPARAM)lbl_msg);
                                                                          SendMessage(cbo_units,\
                                                                            CB_SETCURSEL,0,0);
                                                                          sz_portions=temp_long;
                                                                          memset(lbl_msg,'\0',256);
                                                                          sprintf(lbl_msg,\
                                                                            "100 Portions will be required");
                                                                          SendMessage(lbl_numportions,\
                                                                            WM_SETTEXT,0,(LPARAM)lbl_msg);
                                                                        }
                                                                        break;
                                                  /**********************************************************
                                                  * Whenever the user changes the current selection, sync
                                                  *   the units with the disk size, and then calc the size
                                                  *   and number of portions.
                                                  **********************************************************/
                                                  case CBN_SELCHANGE  : switch(SendMessage(cbo_size,\
                                                                               CB_GETCURSEL,0,0)) {
                                                                          case 0 : /* 360, 720 units - KB */
                                                                          case 1 : SendMessage(cbo_units,\
                                                                                     CB_SETCURSEL,1,0);
                                                                                   break;
                                                                          case 2 : /* 1.2, 1.44, and 2.88 */
                                                                          case 3 : /* units - MB */
                                                                          case 4 : SendMessage(cbo_units,\
                                                                                     CB_SETCURSEL,2,0);
                                                                                   break;
                                                                        }
                                                                        memset(lbl_msg,'\0',256);
                                                                        /************************************
                                                                        * CB_GETCURSEL returns a subscript.
                                                                        *  CB_GETLBTEXT returns the value.
                                                                        ************************************/
                                                                        sz_portions=SendMessage(cbo_size,\
                                                                          CB_GETCURSEL,0,0);
                                                                        SendMessage(cbo_size,CB_GETLBTEXT,\
                                                                          sz_portions,(LPARAM)lbl_msg);
                                                                        tmp_sz=atof(lbl_msg);
                                                                        if(tmp_sz==2.88)
                                                                          sz_portions=D2880;
                                                                        else if(tmp_sz==1.44)
                                                                          sz_portions=D1440;
                                                                        else if(tmp_sz==1.2)
                                                                          sz_portions=D1200;
                                                                        else if(tmp_sz==720)
                                                                          sz_portions=D720;
                                                                        else if(tmp_sz==360)
                                                                          sz_portions=D360;
                                                                        else {
                                                                          switch(SendMessage(cbo_units,\
                                                                                 CB_GETCURSEL,0,0)) {
                                                                            case 0 : sz_portions=\
                                                                                       (int)floor(tmp_sz);
                                                                                     break;
                                                                            case 1 : sz_portions=\
                                                                                       (int)floor(tmp_sz*1024);
                                                                                     break;
                                                                            case 2 : sz_portions=\
                                                                                       (int)floor(tmp_sz*1048576);
                                                                                     break;
                                                                          }
                                                                        }
                                                                        break;
                                                }
                                                /************************************************************
                                                * If the size of each portion is less than 309 bytes, then
                                                *   display a message to the user.
                                                ************************************************************/
                                                if(sz_portions<=sizeof(struct slice32_header)) {
                                                  memset(lbl_msg,'\0',256);
                                                  sprintf(lbl_msg,"Portions must be larger than 309 bytes");
                                                  SendMessage(lbl_numportions,WM_SETTEXT,0,(LPARAM)lbl_msg);
                                                }
                                                /************************************************************
                                                * Otherwise, calc number of portions, and display.
                                                ************************************************************/
                                                else {
                                                  temp_long=sz_portions;
                                                  temp_long-=sizeof(struct slice32_header);
                                                  num_portions=(src_size_lo/temp_long);
                                                  if((src_size_lo%temp_long)>0)
                                                    num_portions++;
                                                  memset(lbl_msg,'\0',256);
                                                  sprintf(lbl_msg,"%ld Portions will be required",\
                                                          num_portions);
                                                  SendMessage(lbl_numportions,WM_SETTEXT,0,(LPARAM)lbl_msg);
                                                }
                                                break;
                              /******************************************************************************
                              * CBO_UNITS combo box code.  Very similar to CBO_SIZE code.
                              ******************************************************************************/
                              case CBO_UNITS :  switch(HIWORD(wParam)) {
                                                  /**********************************************************
                                                  * When it loses focus, check to see if the number of 
                                                  *   portions is greater than 100.  If it is, then recalc
                                                  *   the size for exactly 100 portions, and redisplay.
                                                  **********************************************************/
                                                  case CBN_KILLFOCUS  : if(num_portions>100) {
                                                                          MessageBox(hwnd_main,\
                                                                            "Number of Portions MUST be less than 100 - Resizing",\
                                                                            "Slice32",MB_SETFOREGROUND|MB_OK);
                                                                          temp_long=src_size_lo+\
                                                                            (sizeof(struct slice32_header)*100);
                                                                          temp_long/=100;
                                                                          if((src_size_lo%100)>0)
                                                                            temp_long++;
                                                                          memset(lbl_msg,'\0',256);
                                                                          sprintf(lbl_msg,"%ld",temp_long);
                                                                          SendMessage(cbo_size,WM_SETTEXT,0,\
                                                                            (LPARAM)lbl_msg);
                                                                          SendMessage(cbo_units,\
                                                                            CB_SETCURSEL,0,0);
                                                                          sz_portions=temp_long;
                                                                          memset(lbl_msg,'\0',256);
                                                                          sprintf(lbl_msg,\
                                                                            "100 Portions will be required");
                                                                          SendMessage(lbl_numportions,\
                                                                            WM_SETTEXT,0,(LPARAM)lbl_msg);
                                                                        }
                                                                        break;
                                                  /**********************************************************
                                                  * Whenever the user changes the current selection, calc the
                                                  *   size and number of portions.
                                                  **********************************************************/
                                                  case CBN_SELCHANGE  : memset(lbl_msg,'\0',256);
                                                                        SendMessage(cbo_size,WM_GETTEXT,256,\
                                                                          (LPARAM)lbl_msg);
                                                                        tmp_sz=atof(lbl_msg);
                                                                        /************************************
                                                                        * If nothing in edit box, then list
                                                                        *   box item must have it.
                                                                        ************************************/
                                                                        if(tmp_sz==0) {
                                                                          sz_portions=SendMessage(cbo_size,\
                                                                            CB_GETCURSEL,0,0);
                                                                          SendMessage(cbo_size,CB_GETLBTEXT,\
                                                                            sz_portions,(LPARAM)lbl_msg);
                                                                        }
                                                                        tmp_sz=atof(lbl_msg);
                                                                        /************************************
                                                                        * Similar to the switch in CBO_SIZE,
                                                                        *   except it has fewer cases, due to
                                                                        *   units controlling here rather 
                                                                        *   than size.
                                                                        ************************************/
                                                                        switch(SendMessage(cbo_units,\
                                                                               CB_GETCURSEL,0,0)) {
                                                                          case 0 : sz_portions=\
                                                                                     (int)floor(tmp_sz);
                                                                                   break;
                                                                          case 1 : if(tmp_sz==720)
                                                                                     sz_portions=D720;
                                                                                   else if(tmp_sz==360)
                                                                                     sz_portions=D360;
                                                                                   else
                                                                                     sz_portions=\
                                                                                       (int)floor(tmp_sz*1024);
                                                                                   break;
                                                                          case 2 : if(tmp_sz==2.88)
                                                                                     sz_portions=D2880;
                                                                                   else if(tmp_sz==1.44)
                                                                                     sz_portions=D1440;
                                                                                   else if(tmp_sz==1.2)
                                                                                     sz_portions=D1200;
                                                                                   else
                                                                                     sz_portions=\
                                                                                       (int)floor(tmp_sz*1048576);
                                                                                   break;
                                                                        }
                                                                        break;
                                                }
                                                /************************************************************
                                                * Exactly like CBO_SIZE from here to break.
                                                ************************************************************/
                                                if(sz_portions<=sizeof(struct slice32_header)) {
                                                  memset(lbl_msg,'\0',256);
                                                  sprintf(lbl_msg,"Portions must be larger than 309 bytes");
                                                  SendMessage(lbl_numportions,WM_SETTEXT,0,(LPARAM)lbl_msg);
                                                }
                                                else {
                                                  temp_long=sz_portions;
                                                  temp_long-=sizeof(struct slice32_header);
                                                  num_portions=(src_size_lo/temp_long);
                                                  if((src_size_lo%temp_long)>0)
                                                    num_portions++;
                                                  memset(lbl_msg,'\0',256);
                                                  sprintf(lbl_msg,"%ld Portions will be required",num_portions);
                                                  SendMessage(lbl_numportions,WM_SETTEXT,0,(LPARAM)lbl_msg);
                                                }
                                                break;
                              /******************************************************************************
                              * When the control gets focus, or the spinner changes the value, calculate the 
                              *   size of each portion, and display it in LBL_SIZEPORTIONS.
                              ******************************************************************************/
                              case TXT_NUMBER : switch(HIWORD(wParam)) {
                                                  /**********************************************************
                                                  * Check to make sure the number of portions is at least
                                                  *   two.  If it's not, make it two.
                                                  **********************************************************/
                                                  case EN_KILLFOCUS: memset(lbl_msg,'\0',256);
                                                                     SendMessage(txt_number,WM_GETTEXT,255,\
                                                                       (LPARAM)lbl_msg);
                                                                     num_portions=atol(lbl_msg);
                                                                     if(num_portions<=1) {
                                                                       num_portions=2;
                                                                       memset(lbl_msg,'\0',256);
                                                                       sprintf(lbl_msg,"%d",num_portions);
                                                                       SendMessage(txt_number,WM_SETTEXT,0,\
                                                                         (LPARAM)lbl_msg);
                                                                     }
                                                                     break; 
                                                  case EN_SETFOCUS :
                                                  case EN_CHANGE   : memset(lbl_msg,'\0',256);
                                                                     SendMessage(txt_number,WM_GETTEXT,255,\
                                                                       (LPARAM)lbl_msg);
                                                                     num_portions=atol(lbl_msg);
                                                                     /***************************************
                                                                     * Prevent the user from manually 
                                                                     *   entering a number greater than 100.
                                                                     ***************************************/
                                                                     if(num_portions>100) {
                                                                       num_portions=100;
                                                                       memset(lbl_msg,'\0',256);
                                                                       sprintf(lbl_msg,"%d",num_portions);
                                                                       SendMessage(txt_number,WM_SETTEXT,0,\
                                                                         (LPARAM)lbl_msg);
                                                                     }
                                                                     /***************************************
                                                                     * Wrapping in an if avoids divide by 0.
                                                                     ***************************************/
                                                                     if(num_portions>0) {
                                                                       /*************************************
                                                                       * Calc portion size
                                                                       *************************************/
                                                                       sz_portions=(src_size_lo+\
                                                                         (num_portions*sizeof\
                                                                         (struct slice32_header)))/num_portions;

                                                                       /*************************************
                                                                       * If the filesize is not evenly 
                                                                       *   divisible by the portion size, then
                                                                       *   we need another portion.
                                                                       *************************************/
                                                                       if(((src_size_lo+(num_portions*sizeof\
                                                                          (struct slice32_header)))%\
                                                                          num_portions)>0) {
                                                                         sz_portions+=1;
                                                                       }

                                                                       /*************************************
                                                                       * Display portion size.
                                                                       *************************************/
                                                                       memset(lbl_msg,'\0',256);
                                                                       sprintf(lbl_msg,\
                                                                         "Portions will be %ld bytes",\
                                                                         sz_portions);
                                                                       SendMessage(lbl_sizeportions,WM_SETTEXT,\
                                                                         0,(LPARAM)lbl_msg);
                                                                     }
                                                                     break;
                                                }
                                                break;
                              /******************************************************************************
                              * If the RAD_REMOVE radio button is checked, make sure that RAD_SIZE and 
                              *   RAD_NUMBER are not checked.  Also, hide LBL_NUMPORTIONS and 
                              *   LBL_SIZEPORTIONS.  Enable cmd_slice.  Disable txt_dest and cmd_dest.
                              *******************************************************************************/
                              case RAD_REMOVE : switch(HIWORD(wParam)) {
                                                  case BN_CLICKED : SendMessage(rad_remove,BM_SETCHECK,1,0);
                                                                    SendMessage(rad_size,BM_SETCHECK,0,0);
                                                                    SendMessage(rad_number,BM_SETCHECK,0,0);
                                                                    tfrtc=EnableWindow(cmd_slice,TRUE);
                                                                    slic_disabled=FALSE;
                                                                    tfrtc=EnableWindow(txt_dest,FALSE);
                                                                    tfrtc=EnableWindow(cmd_dest,FALSE);
                                                                    dest_disabled=TRUE;
                                                                    ShowWindow(lbl_sizeportions,SW_HIDE);
                                                                    ShowWindow(lbl_numportions,SW_HIDE);
                                                                    break;
                                                }
                                                break;
                              /******************************************************************************
                              * If the RAD_SIZE button is checked, make sure that RAD_REMOVE and 
                              *   RAD_NUMBER are not checked.  Also, hide LBL_SIZEPORTIONS and show
                              *   LBL_NUMPORTIONS.  Disable cmd_slice.  Enable txt_dest and cmd_dest.Send a 
                              *   CBN_SELCHANGE message to CBO_SIZE so that lbl_numportions gets set properly 
                              *   when the radio button is clicked.
                              *******************************************************************************/
                              case RAD_SIZE   : switch(HIWORD(wParam)) {
                                                  case BN_CLICKED : SendMessage(rad_remove,BM_SETCHECK,0,0);
                                                                    SendMessage(rad_size,BM_SETCHECK,1,0);
                                                                    SendMessage(rad_number,BM_SETCHECK,0,0);
                                                                    if(valid_dest==FALSE)
                                                                      tfrtc=EnableWindow(cmd_slice,FALSE);
                                                                    slic_disabled=TRUE;
                                                                    tfrtc=EnableWindow(txt_dest,TRUE);
                                                                    tfrtc=EnableWindow(cmd_dest,TRUE);
                                                                    dest_disabled=FALSE;
                                                                    ShowWindow(lbl_sizeportions,SW_HIDE);
                                                                    ShowWindow(lbl_numportions,SW_SHOW);
                                                                    SendMessage(hwnd,WM_COMMAND,\
                                                                                (CBN_EDITCHANGE<<16)+CBO_SIZE,0);
                                                                    break;
                                                }
                                                break;
                              /******************************************************************************
                              * If the RAD_NUMBER button is checked, make sure that RAD_REMOVE and 
                              *   RAD_SIZE are not checked.  Also, hide LBL_NUMPORTIONS and show
                              *   LBL_SIZEPORTIONS.  Disable cmd_slice.  Enable txt_dest and cmd_dest.  Send 
                              *   an EN_CHANGE message to TXT_NUMBER so that lbl_sizeportions gets set 
                              *   properly when the radio button is clicked.
                              ******************************************************************************/
                              case RAD_NUMBER : switch(HIWORD(wParam)) {
                                                  case BN_CLICKED : SendMessage(rad_remove,BM_SETCHECK,0,0);
                                                                    SendMessage(rad_size,BM_SETCHECK,0,0);
                                                                    SendMessage(rad_number,BM_SETCHECK,1,0);
                                                                    if(valid_dest==FALSE)
                                                                      tfrtc=EnableWindow(cmd_slice,FALSE);
                                                                    slic_disabled=TRUE;
                                                                    tfrtc=EnableWindow(txt_dest,TRUE);
                                                                    tfrtc=EnableWindow(cmd_dest,TRUE);
                                                                    dest_disabled=FALSE;
                                                                    ShowWindow(lbl_sizeportions,SW_SHOW);
                                                                    ShowWindow(lbl_numportions,SW_HIDE);
                                                                    SendMessage(hwnd,WM_COMMAND,\
                                                                                (EN_CHANGE<<16)+TXT_NUMBER,0);
                                                                    break;
                                                }
                                                break;
                            }
                            return 0;
                            break;
     /*******************************************************************************************************
     * Create all of the controls, set up the window subclassing for the keyboard interface, and set the
     *   initial conditions.
     *******************************************************************************************************/
     case WM_CREATE       : hInstance=((LPCREATESTRUCT)lParam)->hInstance;

                            cxchar=LOWORD(GetDialogBaseUnits());
                            cychar=HIWORD(GetDialogBaseUnits());
 
                            /********************************************************************************
                            * Frame around TXT_SOURCE and CMD_SOURCE
                            ********************************************************************************/
                            fra_source=CreateWindow("BUTTON","Choose file to slice",WS_CHILD|WS_VISIBLE|\
                                                    BS_GROUPBOX,cxchar,cychar,53*cxchar,3*cychar,hwnd,\
                                                    (HMENU)0,((LPCREATESTRUCT)lParam)->hInstance,NULL);

                            /********************************************************************************
                            * Frame around the Slice method and parameters controls
                            ********************************************************************************/
                            fra_method=CreateWindow("BUTTON","Slice method",WS_CHILD|WS_VISIBLE|BS_GROUPBOX,\
                                                    cxchar,5*cychar,53*cxchar,12*cychar,hwnd,(HMENU)1,\
                                                    ((LPCREATESTRUCT)lParam)->hInstance,NULL);

                            /********************************************************************************
                            * Frame around TXT_DEST and CMD_DEST
                            ********************************************************************************/
                            fra_dest=CreateWindow("BUTTON","Choose destination folder",WS_CHILD|WS_VISIBLE|\
                                                  BS_GROUPBOX,cxchar,18*cychar,53*cxchar,3*cychar,hwnd,\
                                                  (HMENU)2,((LPCREATESTRUCT)lParam)->hInstance,NULL);

                            /********************************************************************************
                            * A simple text label to the right of the CBO_UNITS control.
                            ********************************************************************************/
                            lbl_size=CreateWindow("STATIC","portions",WS_CHILD|WS_VISIBLE|WS_DISABLED,\
                                                  38*cxchar,9*cychar,8*cxchar,(int)(1.5*cychar),hwnd,(HMENU)3,\
                                                  ((LPCREATESTRUCT)lParam)->hInstance,NULL);
  
                            /********************************************************************************
                            * Displays "XXXXX Portions will be required" when slicing to specified size.
                            ********************************************************************************/
                            lbl_numportions=CreateWindow("STATIC",NULL,WS_CHILD|WS_VISIBLE,14*cxchar,\
                                                         11*cychar,35*cxchar,(int)(1.5*cychar),hwnd,(HMENU)4,\
                                                         ((LPCREATESTRUCT)lParam)->hInstance,NULL);

                            /********************************************************************************
                            * A simple text label to the right of the SPN_NUMBER control.
                            ********************************************************************************/
                            lbl_number=CreateWindow("STATIC","equal-size portions",WS_CHILD|WS_VISIBLE|\
                                                    WS_DISABLED,28*cxchar,13*cychar,19*cxchar,\
                                                    (int)(1.5*cychar),hwnd,(HMENU)5,\
                                                    ((LPCREATESTRUCT)lParam)->hInstance,NULL);

                            /********************************************************************************
                            * Displays "Portions will be XXXXX bytes" when slicing to number of portions.
                            ********************************************************************************/
                            lbl_sizeportions=CreateWindow("STATIC",NULL,WS_CHILD|WS_VISIBLE,14*cxchar,\
                                                          15*cychar,30*cxchar,(int)(1.5*cychar),hwnd,(HMENU)6,\
                                                          ((LPCREATESTRUCT)lParam)->hInstance,NULL);

                            /********************************************************************************
                            * Source filename edit box.
                            ********************************************************************************/
                            txt_source=CreateWindow("EDIT",NULL,WS_CHILD|WS_VISIBLE|WS_BORDER|ES_AUTOHSCROLL,\
                                                    2*cxchar,2*cychar,42*cxchar,(int)(1.5*cychar),hwnd,\
                                                    (HMENU)7,((LPCREATESTRUCT)lParam)->hInstance,NULL);

                            /********************************************************************************
                            * Browse for source.
                            ********************************************************************************/
                            cmd_source=CreateWindow("BUTTON","Browse",WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON|\
                                                    BS_NOTIFY,45*cxchar,2*cychar,8*cxchar,(int)(1.5*cychar),\
                                                    hwnd,(HMENU)8,((LPCREATESTRUCT)lParam)->hInstance,NULL);

                            /********************************************************************************
                            * Radio button to select Slice to removable drive.
                            ********************************************************************************/
                            rad_remove=CreateWindow("BUTTON","Slice to removable drive",WS_CHILD|WS_VISIBLE|\
                                                    WS_DISABLED|BS_RADIOBUTTON,2*cxchar,7*cychar,22*cxchar,\
                                                    (int)(1.5*cychar),hwnd,(HMENU)9,\
                                                    ((LPCREATESTRUCT)lParam)->hInstance,NULL);

                            /********************************************************************************
                            * List box of removable media drives.
                            ********************************************************************************/
                            cbo_remove=CreateWindow("COMBOBOX",NULL,WS_CHILD|WS_VISIBLE|WS_VSCROLL|\
                                                    WS_DISABLED|CBS_DROPDOWNLIST,26*cxchar,7*cychar,15*cxchar,\
                                                    (int)(10.5*cychar),hwnd,(HMENU)10,\
                                                    ((LPCREATESTRUCT)lParam)->hInstance,NULL);

                            /********************************************************************************
                            * Radio button to select Slice to portions of a specified size.
                            ********************************************************************************/
                            rad_size=CreateWindow("BUTTON","Slice into",WS_CHILD|WS_VISIBLE|WS_DISABLED|\
                                                  BS_RADIOBUTTON,2*cxchar,9*cychar,10*cxchar,\
                                                  (int)(1.5*cychar),hwnd,(HMENU)11,\
                                                  ((LPCREATESTRUCT)lParam)->hInstance,NULL);

                            /********************************************************************************
                            * Combo box to either enter number or pick preset disk sizes.
                            ********************************************************************************/
                            cbo_size=CreateWindow("COMBOBOX",NULL,WS_CHILD|WS_VISIBLE|WS_VSCROLL|WS_DISABLED|\
                                                  CBS_DROPDOWN,14*cxchar,9*cychar,10*cxchar,\
                                                  (int)(10.5*cychar),hwnd,(HMENU)12,\
                                                  ((LPCREATESTRUCT)lParam)->hInstance,NULL);

                            /********************************************************************************
                            * List box with units for size.
                            ********************************************************************************/
                            cbo_units=CreateWindow("COMBOBOX",NULL,WS_CHILD|WS_VISIBLE|WS_VSCROLL|WS_DISABLED|\
                                                   CBS_DROPDOWNLIST,26*cxchar,9*cychar,10*cxchar,\
                                                   (int)(10.5*cychar),hwnd,(HMENU)13,\
                                                   ((LPCREATESTRUCT)lParam)->hInstance,NULL);

                            /********************************************************************************
                            * Radio button to select Slice to equal size portions.
                            ********************************************************************************/
                            rad_number=CreateWindow("BUTTON","Slice into",WS_CHILD|WS_VISIBLE|WS_DISABLED|\
                                                    BS_RADIOBUTTON,2*cxchar,13*cychar,10*cxchar,\
                                                    (int)(1.5*cychar),hwnd,(HMENU)14,\
                                                    ((LPCREATESTRUCT)lParam)->hInstance,NULL);

                            /********************************************************************************
                            * Enter a number of portions.  This is also the buddy control for SPN_NUMBER.
                            ********************************************************************************/
                            txt_number=CreateWindow("EDIT",NULL,WS_CHILD|WS_VISIBLE|WS_BORDER|WS_DISABLED,\
                                                    14*cxchar,13*cychar,10*cxchar,(int)(1.5*cychar),hwnd,\
                                                    (HMENU)15,((LPCREATESTRUCT)lParam)->hInstance,NULL);

                            /********************************************************************************
                            * Spinner control to select number of portions.
                            ********************************************************************************/
                            spn_number=CreateUpDownControl(WS_CHILD|WS_BORDER|WS_VISIBLE|WS_DISABLED|\
                                                           UDS_SETBUDDYINT|UDS_ARROWKEYS,24*cxchar,13*cychar,\
                                                           10,24,hwnd,16,((LPCREATESTRUCT)lParam)->hInstance,\
                                                           txt_number,100,2,1);

                            /********************************************************************************
                            * Edit box for destination folder path.
                            ********************************************************************************/
                            txt_dest=CreateWindow("EDIT",NULL,WS_CHILD|WS_VISIBLE|WS_BORDER|WS_DISABLED|\
                                                  ES_AUTOHSCROLL,2*cxchar,19*cychar,42*cxchar,\
                                                  (int)(1.5*cychar),hwnd,(HMENU)17,\
                                                  ((LPCREATESTRUCT)lParam)->hInstance,NULL);

                            /********************************************************************************
                            * Browse for destination folder.
                            ********************************************************************************/
                            cmd_dest=CreateWindow("BUTTON","Browse",WS_CHILD|WS_VISIBLE|WS_DISABLED|\
                                                  BS_PUSHBUTTON|BS_NOTIFY,45*cxchar,19*cychar,8*cxchar,\
                                                  (int)(1.5*cychar),hwnd,(HMENU)18,\
                                                  ((LPCREATESTRUCT)lParam)->hInstance,NULL);

                            /********************************************************************************
                            * The button that causes slice to happen.
                            ********************************************************************************/
                            cmd_slice=CreateWindow("BUTTON","Slice",WS_CHILD|WS_VISIBLE|WS_DISABLED|\
                                                   BS_PUSHBUTTON,cxchar,22*cychar,8*cxchar,(int)(1.5*cychar),\
                                                   hwnd,(HMENU)19,((LPCREATESTRUCT)lParam)->hInstance,NULL);
 
                            /********************************************************************************
                            * Click this for help.
                            ********************************************************************************/
                            cmd_help=CreateWindow("BUTTON","Help",WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON,26*cxchar,\
                                                  22*cychar,8*cxchar,(int)(1.5*cychar),hwnd,(HMENU)20,\
                                                  ((LPCREATESTRUCT)lParam)->hInstance,NULL);

                            /********************************************************************************
                            * Click this for an About dialog box.
                            ********************************************************************************/
                            cmd_about=CreateWindow("BUTTON","About",WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON,\
                                                   36*cxchar,22*cychar,8*cxchar,(int)(1.5*cychar),hwnd,\
                                                   (HMENU)21,((LPCREATESTRUCT)lParam)->hInstance,NULL);

                            /********************************************************************************
                            * Click this to end it all.
                            ********************************************************************************/
                            cmd_exit=CreateWindow("BUTTON","Exit",WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON,46*cxchar,\
                                                  22*cychar,8*cxchar,(int)(1.5*cychar),hwnd,(HMENU)22,\
                                                  ((LPCREATESTRUCT)lParam)->hInstance,NULL);
  
                            /********************************************************************************
                            * Initialize the list for CBO_REMOVE and set the default to the first entry.
                            ********************************************************************************/
                            local_drives=GetLogicalDrives(); 
                            for(drv_letter='A'; drv_letter<='Z'; drv_letter++) {
                              if(local_drives & 0x01) { 
                                drv_root[0]=drv_letter; 
                                drv_type=GetDriveType(drv_root); 
                                if(drv_type==DRIVE_REMOVABLE) { 
                                  SendMessage(cbo_remove,CB_ADDSTRING,0,(LPARAM)drv_root);
                                } 
                              } 
                              local_drives>>=1;
                            }
                            SendMessage(cbo_remove,CB_SETCURSEL,(WPARAM)0,0);

                            /********************************************************************************
                            * Initialize the list for CBO_UNITS and set the default to the second entry (KB).
                            ********************************************************************************/ 
                            SendMessage(cbo_units,CB_ADDSTRING,0,(LPARAM)"bytes");
                            SendMessage(cbo_units,CB_ADDSTRING,0,(LPARAM)"KB");
                            SendMessage(cbo_units,CB_ADDSTRING,0,(LPARAM)"MB");
                            SendMessage(cbo_units,CB_SETCURSEL,(WPARAM)1,0);

                            /********************************************************************************
                            * Initialize the list for CBO_SIZE and set the default to the first entry.
                            ********************************************************************************/
                            SendMessage(cbo_size,CB_ADDSTRING,0,(LPARAM)"360");
                            SendMessage(cbo_size,CB_ADDSTRING,0,(LPARAM)"720");
                            SendMessage(cbo_size,CB_ADDSTRING,0,(LPARAM)"1.2");
                            SendMessage(cbo_size,CB_ADDSTRING,0,(LPARAM)"1.44");
                            SendMessage(cbo_size,CB_ADDSTRING,0,(LPARAM)"2.88");
                            SendMessage(cbo_size,CB_SETCURSEL,(WPARAM)0,0);

                            /********************************************************************************
                            * Subclass all of the controls in order to establish the standard windows
                            *   keyboard type interface.
                            ********************************************************************************/
                            txt_source_old=(WNDPROC)SetWindowLong(txt_source,GWL_WNDPROC,(LONG)TabProc);
                            cmd_source_old=(WNDPROC)SetWindowLong(cmd_source,GWL_WNDPROC,(LONG)TabProc);
                            rad_remove_old=(WNDPROC)SetWindowLong(rad_remove,GWL_WNDPROC,(LONG)TabProc);
                            cbo_remove_old=(WNDPROC)SetWindowLong(cbo_remove,GWL_WNDPROC,(LONG)TabProc);
                            rad_size_old=(WNDPROC)SetWindowLong(rad_size,GWL_WNDPROC,(LONG)TabProc);
                            cbo_units_old=(WNDPROC)SetWindowLong(cbo_units,GWL_WNDPROC,(LONG)TabProc);
                            rad_number_old=(WNDPROC)SetWindowLong(rad_number,GWL_WNDPROC,(LONG)TabProc);
                            txt_number_old=(WNDPROC)SetWindowLong(txt_number,GWL_WNDPROC,(LONG)TabProc);
                            spn_number_old=(WNDPROC)SetWindowLong(spn_number,GWL_WNDPROC,(LONG)TabProc);
                            txt_dest_old=(WNDPROC)SetWindowLong(txt_dest,GWL_WNDPROC,(LONG)TabProc);
                            cmd_dest_old=(WNDPROC)SetWindowLong(cmd_dest,GWL_WNDPROC,(LONG)TabProc);
                            cmd_slice_old=(WNDPROC)SetWindowLong(cmd_slice,GWL_WNDPROC,(LONG)TabProc);
                            cmd_help_old=(WNDPROC)SetWindowLong(cmd_help,GWL_WNDPROC,(LONG)TabProc);
                            cmd_about_old=(WNDPROC)SetWindowLong(cmd_about,GWL_WNDPROC,(LONG)TabProc);
                            cmd_exit_old=(WNDPROC)SetWindowLong(cmd_exit,GWL_WNDPROC,(LONG)TabProc);

                            /********************************************************************************
                            * Subclassing CBO_SIZE is more complicated because it is a true combo box.
                            *   That means we have to subclass only the edit control of the box.
                            ********************************************************************************/
                            tfrtc=GetWindowRect(cbo_size,&cbo_size_coord);
                            cbo_edit_coord.x=(cbo_size_coord.right-cbo_size_coord.left)/2;
                            cbo_edit_coord.y=(cbo_size_coord.bottom-cbo_size_coord.top)/2;
                            cbo_size_edit=ChildWindowFromPoint(cbo_size,cbo_edit_coord);
                            cbo_size_old=(WNDPROC)SetWindowLong(cbo_size_edit,GWL_WNDPROC,(LONG)CboSizeProc);
  
                            /********************************************************************************
                            * Set initial conditions: TXT_SOURCE has focus, RAD_REMOVE is only radio button
                            *   checked, LBL_SIZEPORTIONS and LBL_NUMPORTIONS are hidden, active control is
                            *   TXT_SOURCE, file size is set to 0, The methods frame, destination frame, and
                            *   SLICE button are disabled, valid_dest is FALSE, slicing is FALSE, 
                            *   slice32_source, slice32_dir is set to the correct startup directory, the 
                            *   help_path is initialized, read_ini is called to remember the last set of
                            *   source and destination browse directories, and the remembered destination
                            *   path is written into txt_dest (if it's length is greater than 0).
                            ********************************************************************************/
                            SetFocus(txt_source);
                            SendMessage(rad_remove,BM_SETCHECK,1,0);
                            SendMessage(rad_size,BM_SETCHECK,0,0);
                            SendMessage(rad_number,BM_SETCHECK,0,0);
                            ShowWindow(lbl_sizeportions,SW_HIDE);
                            ShowWindow(lbl_numportions,SW_HIDE);
                            act_control=txt_source;
                            src_size_lo=0;
                            src_size_hi=0;
                            meth_disabled=TRUE;
                            dest_disabled=TRUE;
                            slic_disabled=TRUE;
                            valid_dest=FALSE;
                            slicing=FALSE;
                            init_startup();
                            memset(help_path,'\0',MAX_PATH+MAX_PATH+1);
                            strcpy(help_path,slice32_dir);
                            if(help_path[strlen(help_path)-1]!='\\')
                              help_path[strlen(help_path)]='\\';
                            strcat(help_path,"slice32.hlp");
                            read_ini();
                            src_browse_path=slice32_source;
                            if(strlen(slice32_dest)>0)
                              SendMessage(txt_dest,WM_SETTEXT,0,(LPARAM)slice32_dest);
                            return 0;
                            break;
    /********************************************************************************************************
    * Terminate the event processing loop.  This is the same processing as that for CMD_EXIT.
    ********************************************************************************************************/
    case WM_DESTROY       : tfrtc=WinHelp(hwnd,"slice32.hlp",HELP_QUIT,0);
                            write_ini();
                            PostQuitMessage(0);
                            break;
    default               : return(DefWindowProc(hwnd,messg,wParam,lParam));
  }

  return(0L);
}

/************************************************************************************************************
* AboutDialogProc only has to handle the OK button on the ABOUTBOX dialog box.  When it's clicked, the 
*   dialog box is shut down.
************************************************************************************************************/
BOOL CALLBACK AboutDialogProc(HWND hdlg,UINT messg,WPARAM wParam,LPARAM lParam) {
  switch(messg) {
    case WM_INITDIALOG : return TRUE;
                         break;
    case WM_COMMAND    : switch(LOWORD(wParam)) {
                           case CMD_OK : return EndDialog(hdlg,0);
                                         break;
                         }
                         break;
    default            : return FALSE;
  }
  return TRUE;
}

/************************************************************************************************************
* TabProc checks for the TAB key on all of the controls except for cbo_size.  When one occurs, focus is 
*   transferred to the next user control.  Labels and frames never receive focus.  Since it is a subclass 
*   procedure, it returns the value of the original control handler.
************************************************************************************************************/
LRESULT CALLBACK TabProc(HWND hwnd,UINT messg,WPARAM wParam,LPARAM lParam) {
  int                cur_control;                               /* Control snagging the TAB */
  int                cbo_count;                                 /* Number of items in combo box list */
  int                cbo_cur;                                   /* Current combo box list item */
  static signed int  adder;                                     /* Step needed to get to next control */

  cur_control=GetDlgCtrlID(hwnd);                               /* Get current control ID */

  switch(messg) {
    case WM_KEYDOWN : switch(wParam) {
                        /************************************************************************************
                        * If the TAB key was pressed, check to see if SHIFT was down, and record its state.
                        ************************************************************************************/
                        case VK_TAB  : if(GetKeyState(VK_SHIFT)<0) {
                                         adder=-1;
                                       }
                                       else {
                                        adder=1;
                                       }
                                       return 0;
                                       break;
                        /************************************************************************************
                        * The DOWN arrow allows movement on the radio buttons as well as the list box 
                        *   components of the combo boxes.
                        ************************************************************************************/
                        case VK_DOWN : switch(cur_control) {
                                         case RAD_REMOVE : SetFocus(GetDlgItem(hwnd_main,RAD_SIZE));
                                                           break;
                                         case RAD_SIZE   : SetFocus(GetDlgItem(hwnd_main,RAD_NUMBER));
                                                           break;
                                         case CBO_UNITS  :
                                         case CBO_REMOVE : cbo_count=SendMessage(GetDlgItem(hwnd_main,\
                                                                       cur_control),CB_GETCOUNT,0,0);
                                                           cbo_cur=SendMessage(GetDlgItem(hwnd_main,\
                                                                     cur_control),CB_GETCURSEL,0,0);
                                                           if(cbo_cur==(cbo_count-1)) {
                                                             SendMessage(GetDlgItem(hwnd_main,cur_control),\
                                                               CB_SETCURSEL,0,0);
                                                           }
                                                           else {
                                                             SendMessage(GetDlgItem(hwnd_main,cur_control),\
                                                               CB_SETCURSEL,cbo_cur+1,0); 
                                                           }
                                                           if(cur_control==CBO_UNITS) {
                                                             SendMessage(hwnd_main,WM_COMMAND,\
                                                               (CBN_SELCHANGE<<16)+CBO_UNITS,(LPARAM)hwnd);
                                                           }
                                                           break;
                                         case TXT_NUMBER : return CallWindowProc(txt_number_old,hwnd,messg,\
                                                                                 wParam,lParam);
                                                           break;
                                         case SPN_NUMBER : return CallWindowProc(spn_number_old,hwnd,messg,\
                                                                                 wParam,lParam);
                                                           break;
                                       }
                                       return 0;
                                       break;
                        /************************************************************************************
                        * The UP arrow allows movement on the radio buttons as well as the list
                        *   box components of the combo boxes.
                        ************************************************************************************/
                        case VK_UP   : switch(cur_control) {
                                         case RAD_NUMBER : SetFocus(GetDlgItem(hwnd_main,RAD_SIZE));
                                                           break;
                                         case RAD_SIZE   : SetFocus(GetDlgItem(hwnd_main,RAD_REMOVE));
                                                           break;
                                         case CBO_UNITS  :
                                         case CBO_REMOVE : cbo_count=SendMessage(GetDlgItem(hwnd_main,\
                                                                       cur_control),CB_GETCOUNT,0,0);
                                                           cbo_cur=SendMessage(GetDlgItem(hwnd_main,\
                                                                     cur_control),CB_GETCURSEL,0,0);
                                                           if(cbo_cur==0) {
                                                             SendMessage(GetDlgItem(hwnd_main,cur_control),\
                                                               CB_SETCURSEL,cbo_count-1,0);
                                                           }
                                                           else {
                                                             SendMessage(GetDlgItem(hwnd_main,cur_control),\
                                                               CB_SETCURSEL,cbo_cur-1,0); 
                                                           }
                                                           if(cur_control==CBO_UNITS) {
                                                             SendMessage(hwnd_main,WM_COMMAND,\
                                                               (CBN_SELCHANGE<<16)+CBO_UNITS,(LPARAM)hwnd); 
                                                           }
                                                           break;
                                         case TXT_NUMBER : return CallWindowProc(txt_number_old,hwnd,messg,\
                                                                                 wParam,lParam);
                                                           break;
                                         case SPN_NUMBER : return CallWindowProc(spn_number_old,hwnd,messg,\
                                                                                 wParam,lParam);
                                                           break;
                                       }
                                       return 0;
                                       break;
                      }
                      break;
    case WM_CHAR    : switch(wParam) {
                        /************************************************************************************
                        * Return key being hit on one of the command buttons causes it to act as
                        *   though it was clicked by a mouse.
                        ************************************************************************************/
                        case '\r' : switch(cur_control) {
                                      case CMD_SOURCE :
                                      case CMD_DEST   :
                                      case CMD_SLICE  :
                                      case CMD_HELP   :
                                      case CMD_ABOUT  :
                                      case CMD_EXIT   : SendMessage(hwnd_main,WM_COMMAND,cur_control,0);
                                                        break;
                                    }
                                    return 0;
                                    break;
                        /************************************************************************************
                        * TAB key causes the focus to switch to the next control.
                        ************************************************************************************/
                        case '\t' : switch(cur_control) {
                                      case TXT_SOURCE : if(adder==-1)
                                                          SetFocus(GetDlgItem(hwnd_main,CMD_EXIT));
                                                        else
                                                          SetFocus(GetDlgItem(hwnd_main,CMD_SOURCE));
                                                        break;
                                      case CMD_SOURCE : if(adder==-1)
                                                          SetFocus(GetDlgItem(hwnd_main,TXT_SOURCE));
                                                        else if(meth_disabled==TRUE)
                                                          SetFocus(GetDlgItem(hwnd_main,CMD_HELP));
                                                        else {
                                                          if(meth_disabled==TRUE)
                                                            SetFocus(GetDlgItem(hwnd_main,CMD_HELP));
                                                          else {
                                                            if(SendMessage(GetDlgItem(hwnd_main,RAD_REMOVE),\
                                                                 BM_GETCHECK,0,0)==BST_CHECKED) {
                                                              SetFocus(GetDlgItem(hwnd_main,RAD_REMOVE));
                                                            }
                                                            else if(SendMessage(GetDlgItem(hwnd_main,RAD_SIZE),\
                                                                      BM_GETCHECK,0,0)==BST_CHECKED) {
                                                              SetFocus(GetDlgItem(hwnd_main,RAD_SIZE));
                                                            }
                                                            else {
                                                              SetFocus(GetDlgItem(hwnd_main,RAD_NUMBER));
                                                            }
                                                          }
                                                        }
                                                        break;
                                      case TXT_NUMBER : if(adder==-1)
                                                          SetFocus(GetDlgItem(hwnd_main,RAD_NUMBER));
                                                        else
                                                          SetFocus(GetDlgItem(hwnd_main,TXT_DEST));
                                                        break;
                                      case TXT_DEST   : if(adder==-1) {
                                                          if(SendMessage(GetDlgItem(hwnd_main,RAD_REMOVE),\
                                                               BM_GETCHECK,0,0)==BST_CHECKED) {
                                                            SetFocus(GetDlgItem(hwnd_main,CBO_REMOVE));
                                                          }
                                                          else if(SendMessage(GetDlgItem(hwnd_main,RAD_SIZE),\
                                                                    BM_GETCHECK,0,0)==BST_CHECKED) {
                                                            SetFocus(GetDlgItem(hwnd_main,CBO_UNITS));
                                                          }
                                                          else {
                                                            SetFocus(GetDlgItem(hwnd_main,TXT_NUMBER));
                                                          }
                                                        }
                                                        else
                                                          SetFocus(GetDlgItem(hwnd_main,CMD_DEST));
                                                        break;
                                      case CMD_DEST   : if(adder==-1)
                                                          SetFocus(GetDlgItem(hwnd_main,TXT_DEST));
                                                        else {
                                                          if(slic_disabled==TRUE)
                                                            SetFocus(GetDlgItem(hwnd_main,CMD_HELP));
                                                          else
                                                            SetFocus(GetDlgItem(hwnd_main,CMD_SLICE));
                                                        }
                                                        break;
                                      case CBO_REMOVE : if(adder==-1)
                                                          SetFocus(GetDlgItem(hwnd_main,RAD_REMOVE));
                                                        else 
                                                          SetFocus(GetDlgItem(hwnd_main,CMD_SLICE));
                                                        break;
                                      case CBO_UNITS  : if(adder==-1) 
                                                          SetFocus(GetDlgItem(hwnd_main,CBO_SIZE));
                                                        else
                                                          SetFocus(GetDlgItem(hwnd_main,TXT_DEST));
                                                        break;
                                      case CMD_SLICE  : if(adder==-1) {
                                                          if(SendMessage(GetDlgItem(hwnd_main,RAD_REMOVE),\
                                                               BM_GETCHECK,0,0)==BST_CHECKED) {
                                                            SetFocus(GetDlgItem(hwnd_main,CBO_REMOVE));
                                                          }
                                                          else
                                                            SetFocus(GetDlgItem(hwnd_main,CMD_DEST));
                                                        }
                                                        else
                                                          SetFocus(GetDlgItem(hwnd_main,CMD_HELP));
                                                        break;
                                      case CMD_HELP   : if(adder==-1) {
                                                          if(meth_disabled==TRUE && dest_disabled==TRUE \
                                                             && slic_disabled==TRUE) {
                                                            SetFocus(GetDlgItem(hwnd_main,CMD_SOURCE));
                                                          }
                                                          else if(meth_disabled==FALSE && dest_disabled==TRUE \
                                                                  && slic_disabled==TRUE) {
                                                            SetFocus(GetDlgItem(hwnd_main,CBO_REMOVE));
                                                          }
                                                          else if(meth_disabled==FALSE && dest_disabled==FALSE \
                                                                  && slic_disabled==TRUE) {
                                                            SetFocus(GetDlgItem(hwnd_main,CMD_DEST));
                                                          }
                                                          else
                                                            SetFocus(GetDlgItem(hwnd_main,CMD_SLICE));
                                                        }
                                                        else
                                                          SetFocus(GetDlgItem(hwnd_main,CMD_ABOUT));
                                                        break;
                                      case CMD_EXIT   : if(adder==-1)
                                                          SetFocus(GetDlgItem(hwnd_main,CMD_ABOUT));
                                                        else
                                                          SetFocus(GetDlgItem(hwnd_main,TXT_SOURCE));
                                                        break;
                                      case RAD_REMOVE : if(adder==-1)
                                                          SetFocus(GetDlgItem(hwnd_main,CMD_SOURCE));
                                                        else
                                                          SetFocus(GetDlgItem(hwnd_main,CBO_REMOVE));
                                                        break;
                                      case RAD_SIZE   : if(adder==-1)
                                                          SetFocus(GetDlgItem(hwnd_main,CMD_SOURCE));
                                                        else
                                                          SetFocus(GetDlgItem(hwnd_main,CBO_SIZE));
                                                        break;
                                      case RAD_NUMBER : if(adder==-1)
                                                          SetFocus(GetDlgItem(hwnd_main,CMD_SOURCE));
                                                        else
                                                          SetFocus(GetDlgItem(hwnd_main,TXT_NUMBER));
                                                        break;
                                      default         : SetFocus(GetDlgItem(hwnd_main,cur_control+adder));
                                                        break;
                                    }
                                    return 0;
                                    break;
                        default   : switch(cur_control) {
                                      /**********************************************************************
                                      * Don't allow anything except for control characters and numbers to be
                                      *   entered into txt_number, including decimal points (periods).  The
                                      *   number of portions must be a whole number.
                                      **********************************************************************/
                                      case TXT_NUMBER : if(wParam>=58 && wParam<=255) {
                                                          return 0;
                                                        }
                                                        if(wParam>=32 && wParam<=47) {
                                                          return 0;
                                                        }
                                                        break;
                                    }
                                    break;
                      }
                      break;
  }

  /**********************************************************************************************************
  * Because all of these controls are subclassed, you must exit by calling the original (default in this
  *   case) window procedure.  The following switch statement accomplishes this.
  **********************************************************************************************************/
  switch(cur_control) {
    case TXT_SOURCE : return CallWindowProc(txt_source_old,hwnd,messg,wParam,lParam);
                      break;
    case CMD_SOURCE : return CallWindowProc(cmd_source_old,hwnd,messg,wParam,lParam);
                      break;
    case RAD_REMOVE : return CallWindowProc(rad_remove_old,hwnd,messg,wParam,lParam);
                      break;
    case CBO_REMOVE : return CallWindowProc(cbo_remove_old,hwnd,messg,wParam,lParam);
                      break;
    case RAD_SIZE   : return CallWindowProc(rad_size_old,hwnd,messg,wParam,lParam);
                      break;
    case CBO_UNITS  : return CallWindowProc(cbo_units_old,hwnd,messg,wParam,lParam);
                      break;
    case RAD_NUMBER : return CallWindowProc(rad_number_old,hwnd,messg,wParam,lParam);
                      break;
    case TXT_NUMBER : return CallWindowProc(txt_number_old,hwnd,messg,wParam,lParam);
                      break;
    case SPN_NUMBER : return CallWindowProc(spn_number_old,hwnd,messg,wParam,lParam);
                      break;
    case TXT_DEST   : return CallWindowProc(txt_dest_old,hwnd,messg,wParam,lParam);
                      break;
    case CMD_DEST   : return CallWindowProc(cmd_dest_old,hwnd,messg,wParam,lParam);
                      break;
    case CMD_SLICE  : return CallWindowProc(cmd_slice_old,hwnd,messg,wParam,lParam);
                      break;
    case CMD_HELP   : return CallWindowProc(cmd_help_old,hwnd,messg,wParam,lParam);
                      break;
    case CMD_ABOUT  : return CallWindowProc(cmd_about_old,hwnd,messg,wParam,lParam);
                      break;
    case CMD_EXIT   : return CallWindowProc(cmd_exit_old,hwnd,messg,wParam,lParam);
                      break;
    default         : return 0;
                      break;
  }
}

/************************************************************************************************************
* CboSizeProc checks for a TAB key on the edit box of the cbo_size combo box.  When one occurs, it sets focus 
*   to CBO_UNITS.  If SHIFT+TAB is detected, then focus is set to RAD_SIZE.  Specialized case of TabProc.
*   It also prevents unwnated characters (letters, punctuation, and such) to be entered.
************************************************************************************************************/
LRESULT CALLBACK CboSizeProc(HWND hwnd,UINT messg,WPARAM wParam,LPARAM lParam) {
  unsigned char      temp[256];                                 /* Scratch buffer used to count periods */
  unsigned char     *period0;                                   /* Also used in counting periods */
  static signed int  adder;                                     /* Step needed to get to next control */
  int                cbo_count;                                 /* Number of items in combo box list */
  int                cbo_cur;                                   /* Current combo box list item */

  switch(messg) {
    case WM_KEYDOWN : switch(wParam) {
                        case VK_TAB  : if(GetKeyState(VK_SHIFT)<0)
                                         adder=-1;
                                       else
                                         adder=1;
                                       return 0;
                                       break;
                        case VK_DOWN : cbo_count=SendMessage(GetDlgItem(hwnd_main,CBO_SIZE),CB_GETCOUNT,0,0);
                                       cbo_cur=SendMessage(GetDlgItem(hwnd_main,CBO_SIZE),CB_GETCURSEL,0,0);
                                       if(cbo_cur==(cbo_count-1))
                                         SendMessage(GetDlgItem(hwnd_main,CBO_SIZE),CB_SETCURSEL,0,0);
                                       else
                                         SendMessage(GetDlgItem(hwnd_main,CBO_SIZE),CB_SETCURSEL,cbo_cur+1,0); 
                                       cbo_cur+=1;
                                       if(cbo_cur==cbo_count)
                                         cbo_cur=0;
                                       if(cbo_cur==0 || cbo_cur==1)
                                         SendMessage(GetDlgItem(hwnd_main,CBO_UNITS),CB_SETCURSEL,1,0);
                                       else if(cbo_cur==2 || cbo_cur==3 || cbo_cur==4)
                                         SendMessage(GetDlgItem(hwnd_main,CBO_UNITS),CB_SETCURSEL,2,0);
                                       else
                                         SendMessage(GetDlgItem(hwnd_main,CBO_UNITS),CB_SETCURSEL,0,0);
                                       SendMessage(hwnd_main,WM_COMMAND,(CBN_SELCHANGE<<16)+CBO_SIZE,0);
                                       return 0;
                                       break;
                        case VK_UP   : cbo_count=SendMessage(GetDlgItem(hwnd_main,CBO_SIZE),CB_GETCOUNT,0,0);
                                       cbo_cur=SendMessage(GetDlgItem(hwnd_main,CBO_SIZE),CB_GETCURSEL,0,0);
                                       if(cbo_cur==0)
                                         SendMessage(GetDlgItem(hwnd_main,CBO_SIZE),CB_SETCURSEL,cbo_count-1,0);
                                       else
                                         SendMessage(GetDlgItem(hwnd_main,CBO_SIZE),CB_SETCURSEL,cbo_cur-1,0); 
                                       if(cbo_cur==0)
                                         cbo_cur=cbo_count-1;
                                       else
                                         cbo_cur-=1;
                                       if(cbo_cur==0 || cbo_cur==1)
                                         SendMessage(GetDlgItem(hwnd_main,CBO_UNITS),CB_SETCURSEL,1,0);
                                       else if(cbo_cur==2 || cbo_cur==3 || cbo_cur==4)
                                         SendMessage(GetDlgItem(hwnd_main,CBO_UNITS),CB_SETCURSEL,2,0);
                                       else
                                         SendMessage(GetDlgItem(hwnd_main,CBO_UNITS),CB_SETCURSEL,0,0);
                                       SendMessage(hwnd_main,WM_COMMAND,(CBN_SELCHANGE<<16)+CBO_SIZE,0);
                                       return 0;
                                       break;
                      }
                      break;
    case WM_CHAR    : if(wParam=='\t') {                        /* TAB Processing */
                        if(adder==-1)                           /* If shift depressed, goto RAD_SIZE */
                          SetFocus(GetDlgItem(hwnd_main,RAD_SIZE));
                        else                                    /* Otherwise, goto CBO_UNITS */
                          SetFocus(GetDlgItem(hwnd_main,CBO_UNITS));
                        return 0;                               /* Return */
                      }
                      if(wParam=='.') {                         /* Allow one and only one decimal point */
                        memset(temp,'\0',256);
                        SendMessage(GetDlgItem(hwnd_main,CBO_SIZE),WM_GETTEXT,255,(LPARAM)temp);
                        period0=strchr(temp,'.');               /* Check for an existing period */
                        if(period0!=NULL) {                     /* If found, return - don't allow another */
                          return 0;
                        }
                      }
                      if(wParam>=58 && wParam<=255) {           /* Don't allow letters or other characters */
                        return 0;                               /* Greater than ASCII 58 (colon)           */
                      }
                      if(wParam==47) {                          /* Don't allow / */
                        return 0;
                      }
                      if(wParam>=32 && wParam<=45) {            /* Don't allow anything from 32 (space) to */
                        return 0;                               /* 45 (minus sign) */
                      }
                      break;                                    /* All else is fair game */
  }
  return CallWindowProc(cbo_size_old,hwnd,messg,wParam,lParam);
}

/************************************************************************************************************
* This callback function allows control over starting browse point in SHBrowseForFolder call.
************************************************************************************************************/
int CALLBACK folder_callback(HWND hwnd,UINT messg,LPARAM lParam,LPARAM pData) {
  switch(messg) {
    case BFFM_INITIALIZED : SendMessage(hwnd,BFFM_SETSELECTION,TRUE,(LPARAM)slice32_dest);
                            break;
    default               : break;
  }
  return 0;
}

