/************************************************************************************************************
* Slice32 1.0 Copyright (c) 1999
* Ziff-Davis, Inc.
* All rights reserved
* First Published in PC Magazine, US Edition, 12/01/1999
* Programmer: Paul Trout
*
* 22 Aug. 1999 - Revised make_splice32 to make SPLICE32.EXE on the target from a resource.
*
* 03 Sep. 1999 - Removed size_xfer_buffer entirely from the library.  Since GetDiskFreeSpace requires a disk 
*                  to be present in the destination before it will work, I was getting "No disk present" 
*                  errors when working with the UI (admittedly, my use of the application has changed).  
*                  Statically fixed the buffer, and removed this function.
*
* 18 Sep. 1999 - Reformatted to 110 character width for  compatibility with the other source files.
*
* 22 Sep. 1999 - Added the function mb_kill.  This allows messageboxes to be killed without user input.
*
* 26 Sep. 1999 - Changed make_splice32 to prompt for overwrite confirmation if SPLICE32.EXE alreadty exists
*                  on destination.
*              - Removed mb_kill function.  The floppy disk does not generate WM_DEVICECHANGE messages.
*
* 02 Oct. 1999 - Added a function, init_startup, to initialize the global slice32_dir string.  This is 
*                  necessary to get the correct startup directory for slice32.exe.
*              - Added a function, write_ini, to write SLICE32.INI out to the SLICE32 directory when the
*                  application exits.
*              - Added a function, read_ini, to read SLICE32.INI from the SLICE32 directory (if it exists)
*                  and initialize slice32_source and slice32_dest with the proper values.
*
* 05 Oct. 1999 - Source editing.  Comment reformatting, etc.
*              - Since win32_ram is no longer used (hasn't been since before first beta), I removed it.
*
* 28 Oct. 1999 - Added code in make_splice32 to use confirm_del flag to control overwrite confirmation.
*
* 28 Oct. 2999 - Removed overwrite protection in make_splice32.
*              - In read_ini and write_ini, changed the fielname from SLICE32.INI to SLICE32.TXT.
*              - SLICE32.TXT was accumulating some extraneous characters after the second line.  This was
*                  actually causing the SHBrowseForFolder to not select the saved destination folder
*                  properly.  This is now fixed.  A missed * was causing a pointer to not dereference.
*
* Compile: cl /nologo /W3 /D "WIN32" /D "CONSOLE"  /Zp1 /c slc32lib.c
* Make Library : LIB /OUT:slc32lib.lib slc32lib.obj
************************************************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <windows.h>
#include <winnt.h>
#include <winbase.h>

#include "slice32.h"

/************************************************************************************************************
* Return the total free bytes on a drive.  A simple wrapper around GetDiskFreeSpace.
************************************************************************************************************/
unsigned long int get_drive_free_bytes(unsigned char *drv) {
  unsigned long int     spc;                                    /* Sectors per cluster */
  unsigned long int     bps;                                    /* Bytes per sector */
  unsigned long int     nfc;                                    /* Number of free clusters */
  unsigned long int     tnc;                                    /* Total number of clusters */
  unsigned long int     rtc;                                    /* Value returned, 0=ERROR */
  BOOL                  tfrtc;                                  /* Boolean return code */

  tfrtc=GetDiskFreeSpace(drv,&spc,&bps,&nfc,&tnc);
  if(tfrtc==FALSE) {                                            /* If error */
    rtc=0L;                                                     /* Function returns 0 */
  }
  else {                                                        /* Otherwise */
    rtc=spc*bps*nfc;                                            /* Function returns free bytes */
  }

  return(rtc);                                                  /* Return the result */
}

/************************************************************************************************************
* Create SPLICE32.EXE on destination by copying it from the resource inside SLICE32.EXE.
************************************************************************************************************/
unsigned long int make_splice32(unsigned char *dst_drv) {
  unsigned char          *exec_dest;                            /* Complete name for dest slice */
  unsigned char          *splc_buff;                            /* Pointer to SPLICE32.EXE in RAM */
  long                    splc_size;                            /* Size in bytes od SPLICE32.EXE */
  long                    bytes_writ=0;                         /* Bytes written with WriteFile */
  HRSRC                   splc_exe;                             /* Resource Handle to SPLICE32.EXE */
  HGLOBAL                 splc_handle;                          /* Global memory handle to resource */
  HANDLE                  splc_app;                             /* File handle used to write SPLICE32.EXE */
  BOOL                    tfrtc;                                /* Win32 boolean return code */

  /**********************************************************************************************************
  * The splice32.exe file is actually a resource of the slice32.exe application.  These four calls 1) Find 
  *   the executable 2) Get its size 3) Load it into memory 4) Retrieve a pointer to its beginning.
  **********************************************************************************************************/
  splc_exe=FindResource(NULL,MAKEINTRESOURCE(IDR_SPLICER1),"SPLICER");
  splc_size=SizeofResource(NULL,splc_exe);
  splc_handle=LoadResource(NULL,splc_exe);
  splc_buff=(unsigned char *)LockResource(splc_handle);

  /**********************************************************************************************************
  * Create the splice32.exe destination path and name.
  **********************************************************************************************************/
  exec_dest=(unsigned char *)calloc(MAX_PATH+1,sizeof(unsigned char));
  strcpy(exec_dest,dst_drv);
  strcat(exec_dest,"SPLICE32.EXE");

  /**********************************************************************************************************
  * Open splice32.exe on the destination, write it out, and close it.
  **********************************************************************************************************/
  splc_app=CreateFile(exec_dest,GENERIC_WRITE,0,NULL,CREATE_NEW,FILE_ATTRIBUTE_NORMAL,NULL);
  if(splc_app==INVALID_HANDLE_VALUE) {                          /* If there was an error */
    if(GetLastError()==ERROR_FILE_EXISTS) {                     /* Because SPLICE32.EXE already exists */
      tfrtc=DeleteFile(exec_dest);                              /* Delete the file */
      splc_app=CreateFile(exec_dest,GENERIC_WRITE,0,NULL,CREATE_NEW,FILE_ATTRIBUTE_NORMAL,NULL);
    }
  }
  tfrtc=WriteFile(splc_app,splc_buff,splc_size,&bytes_writ,NULL);
  tfrtc=CloseHandle(splc_app);
  free(exec_dest);

  return(0L);
}

/************************************************************************************************************
* Initialize slice32_dir with the correct startup directory for slice32.  This directory ALWAYS ends in a \.
************************************************************************************************************/
void init_startup(void) {
  unsigned char *filename;                                      /* File pointer set by SearchPath */
  unsigned long  rtc;                                           /* Win32 return code */
  
  memset(slice32_dir,'\0',MAX_PATH+1);                          /* Zero slice32_dir */
  /**********************************************************************************************************
  * SearchPath locates SLICE32.EXE.  After it does, the complete path (including the slice32.exe) is 
  *   available.  In addition to filling the passed buffer with the complete path and filename, SearchPath
  *   initializes a pointer to the filename portion.  Since I just want the path, I set the first character
  *   of the filename to a NULL, effectively isolating the path.
  **********************************************************************************************************/
  rtc=SearchPath(NULL,"slice32.exe",NULL,MAX_PATH,slice32_dir,&filename);
  *filename='\0';                                               /* Terminate the directory before filename */
}

/************************************************************************************************************
* write_ini writes the slice32_source and slice32_dest strings out to SLICE32.TXT in the SLICE32.EXE startup
*   directory.  Any existing SLICE32.TXT file is ALWAYS overwritten.
************************************************************************************************************/
void write_ini(void) {
  unsigned char  ini_path[512];                                 /* SLICE32.INI path and filename */
  unsigned char  cur_line[512];                                 /* Current line of SLICE32.INI */
  unsigned long  written;                                       /* Bytes written during file write */
  BOOL           tfrtc;                                         /* Win32 boolean return code */
  HANDLE         ini_file;                                      /* File handle to SLICE32.INI */

  memset(ini_path,'\0',512);                                    /* Zero the path and filename */
  strcpy(ini_path,slice32_dir);                                 /* Copy startup directory to ini_path */
  strcat(ini_path,"SLICE32.TXT");                               /* Append the filename to the path */
  ini_file=CreateFile(ini_path,GENERIC_WRITE,0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);

  memset(cur_line,'\0',512);                                    /* Zero current line */
  sprintf(cur_line,"%s\n",slice32_source);                      /* Set it to slice32_source */
  tfrtc=WriteFile(ini_file,cur_line,strlen(cur_line),&written,NULL);

  memset(cur_line,'\0',512);                                    /* Zero current line */
  sprintf(cur_line,"%s\n",slice32_dest);                        /* Set it to slice32_dest */
  tfrtc=WriteFile(ini_file,cur_line,strlen(cur_line),&written,NULL);

  tfrtc=CloseHandle(ini_file);                                  /* Close SLICE32.INI */
}

/************************************************************************************************************
* read_ini opens the SLICE32.TXT file in the SLICE32 startup directory, and sets the slice32_source and
*   slice32_dest variables to the remembered values.  If SLICE32.TXT does not exist, then it simply uses
*   memset to initialize them to NULLS.
************************************************************************************************************/
void read_ini(void) {
  unsigned char  ini_path[512];                                 /* SLICE32.INI path and filename */
  unsigned char  buffer[1024];                                  /* ReadFile buffer.  Statically sized */
  unsigned char *start;                                         /* Beginning of a line from SLICE32.INI */
  unsigned char *end;                                           /* End of a line from SLICE32.INI */
  unsigned long  readfrom;                                      /* Bytes read during file read */
  BOOL           tfrtc;                                         /* Win32 boolean return code */
  HANDLE         ini_file;                                      /* File handle to SLICE32.INI */

  memset(slice32_source,'\0',MAX_PATH);                         /* Zero the slice32_source string */
  memset(slice32_dest,'\0',MAX_PATH);                           /* Zero the slice32_dest string */
  
  memset(ini_path,'\0',512);                                    /* Zero the path and filename */
  strcpy(ini_path,slice32_dir);                                 /* Copy startup directory to ini_path */
  strcat(ini_path,"SLICE32.TXT");                               /* Append the filename to the path */
  ini_file=CreateFile(ini_path,GENERIC_READ,0,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);

  if(ini_file!=INVALID_HANDLE_VALUE) {                          /* If the file could be opened, read it */
    tfrtc=ReadFile(ini_file,buffer,1024,&readfrom,NULL);
    start=buffer;                                               /* First line begins at beginning of buffer */
    end=strchr(start,'\n');                                     /* End is the first CRLF combination */
    *end='\0';                                                  /* Properly terminate the string */
    strcpy(slice32_source,start);                               /* Initialize slice32_source */

    start=end;                                                  /* Second line begins immediately */
    start++;                                                    /* After the CRLF ending the first line */
    end=strchr(start,'\n');                                     /* Second line ends in CRLF combination */
    *end='\0';                                                  /* Terminate the string */
    strcpy(slice32_dest,start);                                 /* Initialize slice32_dest */

    tfrtc=CloseHandle(ini_file);                                /* Close SLICE32.INI */
  }
}

