// +++FHDR+++
//
//
//   Class Name : TcpSocket
//   Super Class: n/a
//
//   Description: This class implements a platform independent TCP socket.
//
//
//   Notes      : none
//
//
//   Method - Description
//   ------------------------------------------------------------------------
//
//
// ---FHDR---

#ifndef _TCPSOCKET_H_
#define _TCPSOCKET_H_


class OutputString;


class TcpSocket {

  private:
	static int _sockets_initialized;

  protected:
	OutputString _err_msg;

	char * _host;
	int _port;

	long _lowlevel_socket;
	int _write_timeout;
	int _read_timeout;
	int _read_buf_size;

  public:
	TcpSocket ();
	TcpSocket (char * host, int port);
	~TcpSocket ();

	char * getHost ();
	int getPort ();

	int open (char * to_addr, int to_port);
	void close ();
	int ok_to_write ();
	int write (char * data, int len);
	char * read ();

	char * getLastError ();

	static int initializeSockets();
	static void deinitializeSockets();
};

#endif // _TCPSOCKET_H_

