package com.vsi.xmlf.beans;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

/**
 *
 */
public class Preferences extends Properties {

	protected File _file = null;
	protected String _header = "DO NOT EDIT!";


	/**
	 * Create a <code>Preferences</code> object.
	 */
	public Preferences () {
	}
	

	/**
	 * Create a <code>Preferences</code> object that will store its 
	 * preferences in <code>filename</code>.
	 *
	 * @param   filename   the name of the preferences file.
	 */
	public Preferences (String filename) {

		/*
		 * Open and read the passed in preference file
		 */
		_file = new File(filename);
		try {	
			load();
		} catch (Exception ignore) {
		}
	}


	public synchronized String getFilename () {
		if (_file == null) {
			return (null);
		}

		return (_file.getAbsolutePath());
	}


	public synchronized void setFilename (String filename) {
		_file = new File(filename);
	}


	/**
	 * Set a default value for a preference. If this preference was already
	 * found in the preferences file this method does nothing.
	 *
	 * @param  name   The name of the preference.
	 * @param  value  The value for the preference.
	 */
	public void setDefault (String name, String value) {
		if (!containsKey(name)) {
			super.put(name, value);
		}
	}



	/**
	 * Set the header (comment) to be displayed at the top of the 
	 * preferences file.
	 *
	 * @param   header   Header (comment) string to display in
	 * prefernces file.
	 */
	public void setFileHeader (String header) {
		_header = header;
	}


	/**
	 * Load the preferences from the set preferences file.
	 *
	 * @exception  IOException when an error occurs writing the file.
	 */
	public void load () throws IOException {
		if (_file == null) {
			return;
		}

		FileInputStream fis = new FileInputStream(_file);
		load(fis);
		fis.close();
	}


	/**
	 * Save the preferences to the set preferences file.
	 *
	 * @exception  IOException when an error occurs writing the file.
	 */
	public void save () throws IOException {
		if (_file == null) {
			return;
		}

		FileOutputStream fos = new FileOutputStream(_file);
		save(fos, _header);
		fos.close();
	}


	public int get (String key, int default_value) {

		String value = (String)get(key);
		if (value != null) {
			return (Integer.parseInt(value));
		} else {
			return (default_value);
		}
	}


	public String get (String key, String default_value) {

		String value = (String)get(key);
		if (value != null) {
			return (value);
		} else {
			return (default_value);
		}
	}


	public void put (String key, int value) {
		put(key, String.valueOf(value));
	}
}

