package com.vsi.xmlf;

import java.util.Vector;

/**
 *
 *
 */
public
class SubmitRequest extends Request {


	protected Vector _content = new Vector();
	protected Vector _recipients = new Vector();

	protected Sender _sender = null;
	protected String _subject = null;

	protected boolean _include_coversheet = false;

	protected String _notify_who = null;
	protected NotifyWhen _notify_when = NotifyWhen.NEVER;

	protected Priority _priority = Priority.NORMAL;

	protected Resolution _resolution = Resolution.FINE;


	protected String _tag = "fax-submit";
	


	/**
	 * Gets the XML tag for this object. This method is implemented by
         * all classes implementing the XmlfObject interface. The tag is
         * utilized in the toXml() method.
	 *
	 * @return  the tag for this XML object
	 * @see     #setTag
	 * @see     #toXml
	 */
	public synchronized String getTag () {
		return (_tag);
	}


	/**
	 * Sets the XML tag for this object. This method is implemented by
         * all classes implementing the XmlfObject interface.
         *
         * @param  tag  the XML tag name for this object
	 * @see    #getTag
	 */
	public synchronized void setTag (String tag) {
		_tag = tag;
	}


	/**
	 * Gets a string containing the XML for this object. Use
	 * <code>toXml(String indent)</code> to output indented XML.
	 *
	 * @return  a String containing the XML for this object
	 * @see     #toXml(String indent)
	 */
	public String toXml () {
		return (toXml(""));
	}

	
	/**
	 * Gets a string containing the indented XML for this object. Use
	 * <code>toXml()</code> to output non-formatted XML.
	 *
	 * @return  a String containing the indented XML for this object
	 * @see     #toXml()
	 */
	public String toXml (String indent) {
		
		StringBuffer xml = new StringBuffer();

		if (indent == null)
			indent = "";

		xml.append(indent + "<?xml version=\"1.0\"?>\n");
		xml.append(indent + "<" + getTag());
		if (getResponseFormat() != null) {
			xml.append(" response-format=\"" +
				getResponseFormat() + "\"");
		}

		if (getResolution() != null) {
			xml.append(" resolution=\"" + getResolution() + "\"");
		}

		if (getPriority() != null) {
			xml.append(" priority=\"" + getPriority() + "\"");
		}

		String include_coversheet = (getIncludeCoversheet() ?
			"yes" : "no");
		xml.append(" coversheet=\"" + include_coversheet + "\">\n");

		xml.append(getAccount().toXml(indent + "\t"));

		Recipient recipients[] = getRecipients();
		for (int i = 0; i < recipients.length; i++) {
			xml.append(recipients[i].toXml(indent + "\t"));
		}

		if (getSender() != null) {
			xml.append(getSender().toXml(indent + "\t"));
		}

		if (getNotifyWho() != null) {
			xml.append(indent + "\t<email-notification when=\"" +
				getNotifyWhen() + "\">" + getNotifyWho() +
				"</email-notification>\n");
		}

		if (getSubject() != null) {
			xml.append(indent + "\t<subject>" +
				getSubject() + "</subject>\n");
		}

		xml.append(indent + "\t<content>\n");
		Body bodylist[] = getContent();
		for (int i = 0; i < bodylist.length; i++) {
			xml.append(bodylist[i].toXml(indent + "\t\t"));
		}
		xml.append(indent + "\t</content>\n");

		if (getApplicationReference() != null) {
			xml.append(indent + "\t<application-reference>" +
				getApplicationReference() + 
				"</application-reference>\n");
		}

		if (getCommandReference() != null) {
			xml.append(indent + "\t<command-reference>" +
				getCommandReference() + 
				"</command-reference>\n");
		}

		xml.append(indent + "</"  + getTag()      + ">\n");
		return (xml.toString());
	}


	/**
	 * Assignes the values/attributes in the XML data to this object.
	 *
	 * @param  root_element  the XML data to assign from
	 */
	public void setFromXml (XmlElement root_element) {

		_content.setSize(0);
		_recipients.setSize(0);
		_sender = null;
		_subject = null;
		_include_coversheet = false;
		_notify_who = null;
		_notify_when = NotifyWhen.NEVER;
		_priority = Priority.NORMAL;
		_resolution = Resolution.FINE;

		if (root_element == null) {
			return;
		}

		super.setFromXml(root_element);


		setResolution(Resolution.stringToObject(
			root_element.getAttribute("resolution")));

		setPriority(Priority.stringToObject(
			root_element.getAttribute("priority")));
					
		setIncludeCoversheet(root_element.getAttribute("coversheet"));
					
					
		XmlElement xml[] = root_element.getSubElements();


		XmlElement notify = 
			XmlElement.findElement(xml, "email-notification");
		if (notify != null) {
			setNotifyWho(notify.getData());
			setNotifyWhen(notify.getAttribute("when"));
		}


		XmlElement sender = XmlElement.findElement(xml, "sender");
		if (sender != null) {
			_sender = new Sender(sender);
		}


		/*
		 * loop thru the sub elements looking for recipients
		 */
		for (int i = 0; i < xml.length; i++) {
			if (xml[i].getName().
				equalsIgnoreCase("recipient")) {
				Recipient r = new Recipient(xml[i]);
				_recipients.addElement(r);
			}
		}


		setSubject(XmlElement.getData(xml, "subject"));

		/*
		 * loop thru the content sub elements looking for body
		 */
		XmlElement content = XmlElement.findElement(xml, "content");
		if (content != null) {	

			XmlElement bodys[] = content.getSubElements();
			for (int i = 0; i < bodys.length; i++) {

				if (bodys[i].getName().
					equalsIgnoreCase("body")) {

					Body body = new InlineBody(bodys[i]);
					_content.addElement(body);
				}
			}
		}
	}
	


	/**
	 *
	 */
	public synchronized Sender getSender () {
		return (_sender);
	}


	/**
	 *
	 */
	public synchronized void setSender (Sender sender) {
		_sender = sender;
	}


	/**
	 *
	 */
	public synchronized String getSubject() {
		return (_subject);
	}


	/**
	 *
	 */
	public synchronized void setSubject (String subject) {
		_subject = subject;
	}


	/**
	 *
	 */
	public synchronized boolean getIncludeCoversheet () {
		return (_include_coversheet);
	}


	/**
	 *
	 */
	public synchronized void setIncludeCoversheet (
		boolean include_coversheet) {

		_include_coversheet = include_coversheet;
	}


	/**
	 *
	 */
	public synchronized void setIncludeCoversheet (
		String str) {

		if (str == null) {
			_include_coversheet = false;
			return;
		}

		if (str.equalsIgnoreCase("yes")) {
			_include_coversheet = true;
		} else if (str.equalsIgnoreCase("true")) {
			_include_coversheet = true;
		} else if (str.equalsIgnoreCase("on")) {
			_include_coversheet = true;
		} else {
			_include_coversheet = false;
		}
	}


	public synchronized NotifyWhen getNotifyWhen () {
		return (_notify_when);
	}


	public synchronized void setNotifyWhen (NotifyWhen notify_when) {
		_notify_when = notify_when;
	}


	public synchronized void setNotifyWhen (String when) {
		_notify_when = NotifyWhen.stringToObject(when);
	}


	public synchronized String getNotifyWho () {
		return (_notify_who);
	}


	public synchronized void setNotifyWho (String notify_who) {
		_notify_who = notify_who;
	}


	public synchronized Priority getPriority () {
		return (_priority);
	}


	public synchronized void setPriority (Priority priority) {
		_priority = priority;
	}


	public synchronized void setPriority (String priority) {
		_priority = Priority.stringToObject(priority);
	}


	public synchronized Resolution getResolution () {
		return (_resolution);
	}


	public synchronized void setResolution(Resolution resolution) {
		_resolution = resolution;
	}


	public synchronized void setResolution(String resolution) {
		_resolution = Resolution.stringToObject(resolution);
	}


	/**
	 * Clears all content from the request.
	 */
	public void clearContent () {
		_content.setSize(0);
	}


	/**
	 *
	 */
	public synchronized int getContentCount () {
		return (_content.size());
	}


	public synchronized Body getContent (int index)
		throws ArrayIndexOutOfBoundsException {

		if (index < 0 || index >= getContentCount()) {
			throw new ArrayIndexOutOfBoundsException();
		}

		return ((Body)_content.elementAt(index));
	}


	public synchronized Body [] getContent () {

		Body list[] = new Body[getContentCount()];
		_content.copyInto(list);
		return (list);
	}


	/**
	 * 
	 */
	public synchronized void addContent (Body body) {

		if (body != null) {
			_content.addElement(body);
		}
	}


	/**
	 * 
	 */
	public synchronized void addContent (String content) {

		if (content != null) {
			_content.addElement(new InlineBody(content));
		}
	}


	/**
	 *
	 */
	public synchronized void setContent (int index, Body body)
		throws ArrayIndexOutOfBoundsException {

		if (index < 0 || index >= getContentCount()) {
			throw new ArrayIndexOutOfBoundsException();
		}

		_content.setElementAt(body, index);
	}


	/**
	 * Sets the content element to contain the array of Body objects.
	 *
	 * @param  list  the array of <code>Body</code> objects.
	 */
	public synchronized void setContent (Body list[]) {

		int num_body = list.length;

		_content.setSize(num_body);

		for (int i = 0; i < num_body; i++) {
			
			try {
				setContent(i, list[i]);
			} catch (ArrayIndexOutOfBoundsException e) {
			}
		}
	}


	public synchronized int getRecipientCount () {
		return (_recipients.size());
	}



	/**
	 *
	 */
	public synchronized Recipient getRecipient (int index)
		throws ArrayIndexOutOfBoundsException {

		if (index < 0 || index >= getRecipientCount()) {
			throw new ArrayIndexOutOfBoundsException();
		}

		return ((Recipient)_recipients.elementAt(index));
	}


	public synchronized Recipient [] getRecipients () {

		Recipient list[] = new Recipient[getRecipientCount()];
		_recipients.copyInto(list);
		return (list);
	}


	/**
	 *
	 */
	public synchronized void addRecipient (Recipient recipient) {

		if (recipient != null) {
			_recipients.addElement(recipient);
		}
	}	


	public synchronized void setRecipients (int index, Recipient recipient)
		throws ArrayIndexOutOfBoundsException {

		if (index < 0 || index >= getRecipientCount()) {
			throw new ArrayIndexOutOfBoundsException();
		}

		_recipients.setElementAt(recipient, index);
	}


	/**
	 *
	 *
	 *
	 */
	public synchronized void setRecipients (Recipient list[]) {

		int num_recipients = list.length;

		_recipients.setSize(num_recipients);

		for (int i = 0; i < num_recipients; i++) {
			
			try {
				setRecipients(i, list[i]);
			} catch (ArrayIndexOutOfBoundsException e) {
			}
		}
	}
}

