package com.vsi.xmlf;

/**
 * This class defines constants for the server response formats.
 *
 */
public
class ResponseFormat {

	public static final ResponseFormat HTML = new ResponseFormat("html");
	public static final ResponseFormat TEXT = new ResponseFormat("text");
	public static final ResponseFormat XML  = new ResponseFormat("xml");


	private String _value = null;

	/**
	 * Constructors are private since this class is for constants only.
	 */
	private ResponseFormat () {
	}

	private ResponseFormat (String value) {
		_value = value;
	}


	public String toString () {
		return (_value);
	}


	/**
	 * Given a response-format string return the corresponding 
	 * <code>ResponseFormat</code> object.
	 *
	 * @returns  The <code>ResponseFromat</code> object corresponding
	 * the the given string.
	 */
	public static ResponseFormat stringToObject (String str) {

		if (str == null) {
			return (null);
		}

		if (str.equalsIgnoreCase("xml")) {
			return (XML);
		} else if (str.equalsIgnoreCase("text")) {
			return (TEXT);
		} else if (str.equalsIgnoreCase("html")) {
			return (HTML);
		} else {
			return (null);
		}
	}
}
	
