package com.vsi.xmlf;

/**
 *
 *
 */
public
class NotifyWhen {


	public static final NotifyWhen NEVER      = new NotifyWhen("none");
	public static final NotifyWhen ALWAYS     = new NotifyWhen("always");
	public static final NotifyWhen ON_SUCCESS = 
						new NotifyWhen("on-success");
	public static final NotifyWhen ON_FAILURE = 
						new NotifyWhen("on-failure");

	private String _value = null;

	/**
	 * Constructors are private since this class is for constants only.
	 */
	private NotifyWhen () {
	}

	private NotifyWhen (String value) {
		_value = value;
	}


	/**
	 * Gets the string representation for this object.
	 */
	public String toString () {
		return (_value);
	}


	/**
	 * Given a notify when string return the corresponding 
	 * <code>NotifyWhen</code> object.
	 *
	 * @returns  The <code>NotifyWhen</code> object corresponding the the 
	 * given string.
	 */
	public static NotifyWhen stringToObject (String str) {

		if (str == null) {
			return (null);
		}

		if (str.equalsIgnoreCase("never") ||
		   str.equalsIgnoreCase("none")) {
			return (NEVER);
		} else if (str.equalsIgnoreCase("always")) {
			return (ALWAYS);
		} else if (str.equalsIgnoreCase("on-success")) {
			return (ON_SUCCESS);
		} else if (str.equalsIgnoreCase("on-failure")) {
			return (ON_FAILURE);
		} else {
			return (null);
		}
	}
}

