package com.vsi.xmlf;

/**
 * This class encapsulates a XML-F canonical-fax-number element.
 *
 */
public 
class CanonicalFaxNumber extends CanonicalPhoneNumber
	implements java.io.Serializable {


	protected String _tag = "canonical-fax";


	/**
	 * No args constructor.
	 */
	public CanonicalFaxNumber () {
		super();
	}


	/**
	 * Construct a CanonicalFaxNumber object based on the passed in
	 * attributes.
	 *
	 * @param  country_code  the country code of the phone number
	 * @param  area_code     the area code of the phone number
	 * @local_number         the local number of the phone number
	 * @extension            the extension of the phone number 
	 */
	public CanonicalFaxNumber (String country_code, String area_code,
		String local_number, String extension) {

		super(country_code, area_code, local_number, extension);
	}


	/**
	 * Creates a CanonicalFaxNumber object initialized with the data from 
	 * element.
	 *
	 * @param  element  the XML element containing the fax number info
	 */
	public CanonicalFaxNumber (XmlElement element) {
		super(element);
	}
		

	/**
	 * Gets the XML tag for this object. This method is implemented by
         * all classes implementing the XmlfObject interface. The tag is
         * utilized in the toXml() method.
	 *
	 * @return  the tag for this XML object
	 * @see     #setTag
	 * @see     #toXml
	 */
	public synchronized String getTag () {
		return (_tag);
	}


	/**
	 * Sets the XML tag for this object. This method is implemented by
         * all classes implementing the XmlfObject interface.
         *
         * @param  tag  the XML tag name for this object
	 * @see    #getTag
	 */
	public synchronized void setTag (String tag) {
		_tag = tag;
	}
}
