package com.vsi.xmlf;

import java.util.Vector;

/**
 * This class encapsulates the attributes for a XML element.
 *
 */
class AttributeList {

	protected Vector _names  = new Vector();
	protected Vector _values = new Vector();


	/**
	 * Construct an empty attribute list
	 */
	public AttributeList () {
	}


	/**
	 * Return the number of attributes in the list.
	 *
	 * @return the number of attributes in the list
	 */
	public int getLength () {
		return (_names.size());
	}


	/**
	 * Add an attribute to an attribute list.
	 *
	 * @param  name   the attribute name
	 * @param  value  the attribute value (must not be null)
	 * @see #remove
	 */
	public void add (String name, String value) {
		_names.addElement(name);
		_values.addElement(value);
	}


	/**
	 * Remove an attribute from the list.<p>
	 *
	 * Note that calling this method will change the length
	 * of the attribute list and some of the attribute's indices.<p>
	 *
	 * If the requested attribute is not in the list, this method
	 * does nothing.
	 *
	 * @param  name  the attribute name
	 * @see #add
	 */
	 public void remove (String name) {

		int i = _names.indexOf(name);
		if (i >= 0) {
			_names.removeElementAt(i);
			_values.removeElementAt(i);
		}
	}


	/**
	 * Clear the attribute list.
	 */
	public void clear () {
		_names.removeAllElements();
		_values.removeAllElements();
	}



	/**
	 * Gets the name of an attribute (by position).
	 *
	 * @param  index  the position of the attribute in the list
	 * @return the attribute name as a string, or null if there
	 *         is no attribute at that position
	 */
	public String getName (int index) {
		try {
			return ((String)_names.elementAt(index));
		} catch (ArrayIndexOutOfBoundsException e) {
			return (null);
		}
	}


	/**
	 * Gets the value of an attribute (by position).
	 *
	 * @param  index  the position of the attribute in the list
	 * @return the attribute value as a string, or null if
	 *         there is no attribute at that position
	 * @see    #getValue()
	 */
	public String getValue (int index) {
		try {
			return ((String)_values.elementAt(index));
		} catch (ArrayIndexOutOfBoundsException e) {
			return (null);
		}
	}


	/**
	 * Gets the value of an attribute (by name).
	 *
	 * @param  name  the attribute name
	 * @return the attribute value as a string, or null if
	 *         there is no attribute at that position
	 * @see    #getValue(int index)
	 */
	public String getValue (String name) {
		return (getValue(_names.indexOf(name)));
  	}
}
