#!/bin/sh
# ------------------------------------------------------------------------
#
#	Description:
#
#	Sample script to interface with the LP spooler
#
#	This "LP destination" assumes the phone number is in
#	the "-o OPTS" parameter
#
# ------------------------------------------------------------------------

# ------------------------------------------------------------------------
# setup the VSI-FAX environment
#
. /etc/vsifax.sh

# ------------------------------------------------------------------------
# get arguments
#
PRINTER=`basename $0`
REQID="$1"
USER="$2"
TITLE="$3"
COPIES="$4"
OPTS="$5"
shift 5
FILES="$*"

LOGNAME=`echo $USER | sed -e 's/.*!//'`
export LOGNAME

# ------------------------------------------------------------------------
# send the fax
#
ERR_FILE=${TMP:-/tmp}/$PRINTER.$$

seqno=`vfx -U $LOGNAME -n "$OPTS" $FILES 2>$ERR_FILE`
rc=$?
if [ $rc -ne 0 ]
then
	mailx -s "Failed fax request" $USER <<- EOF
	Your fax request ($REQID) failed.
	Error message is:
	`cat $ERR_FILE`
	EOF
else
	mailx -s "Fax request" $USER <<- EOF
	Job $REQID: Fax request ID is $seqno
	EOF
fi
rm -f $ERR_FILE

exit $rc
