# +++PHDR+++
#
# Procedure:	modem_adm__BuildMainForm
#
# Description:	Draws the main form for the modem database editor
#
#
# Argument		Description
# --------------------	----------------------------------------------------
# form_shell            Pathname for toplevel shell
#
#
# Returns:	nothing
#
#
# Notes:
#
# ---PHDR---

proc modem_adm__BuildMainForm { form_shell } {
	global modem_adm__default modem_adm__default_saved modem_adm__shell
	global vsimenu__hostname
	global vsimenu__isadmin

	#
	# Create the top level shell if the form_shell is not "."
	#
	if { $form_shell == "." } {
		set form ".frame"
		set modem_adm__shell ".frame"
		catch { destroy $form }
		frame $form
	} else {
        	catch { destroy $form_shell }
		toplevel $form_shell
		set form $form_shell
		set modem_adm__shell $form_shell
	}

	if { $vsimenu__isadmin } {
		set state "normal"
		set double_click modem_adm__Edit
	} else {
		set state "disabled"
		set double_click ""
	}

	#
	# Put the title on the shell
	#
	set vtitle "$vsimenu__hostname - Device Administration"
	wm title $form_shell $vtitle

	#
	# Setup a handler for the window manager "Close" function
	#
	wm protocol $form_shell WM_DELETE_WINDOW modem_adm__Done
	
	#
	# Build scrolled lists that hold the destination name, type,
	# and description
	#
	frame $form.lists -highlightthickness 2
	frame $form.lists.dest
	label $form.lists.dest.label -text "Destination" 
	listbox $form.lists.dest.list -borderwidth 1 -exportselection false \
		-relief sunken -selectmode browse -width 12 \
		-yscrollcommand [ list $form.lists.desc.scroll set ] \
		-highlightthickness 0
	pack $form.lists.dest.label 
	pack $form.lists.dest.list -side left
	pack $form.lists.dest -side left

	frame $form.lists.type -takefocus 0
	label $form.lists.type.label -text "Type"
	listbox $form.lists.type.list -borderwidth 1 -exportselection false \
		-relief sunken -selectmode browse -width 7 -takefocus 0 \
		-yscrollcommand [ list $form.lists.desc.scroll set ] \
		-highlightthickness 0
	pack $form.lists.type.label 
	pack $form.lists.type.list -side left
	pack $form.lists.type -side left

	frame $form.lists.desc
	label $form.lists.desc.label -text "Description"
	listbox $form.lists.desc.list -borderwidth 1 -exportselection false \
		-relief sunken -selectmode browse -width 20 -takefocus 0 \
		-yscrollcommand [ list $form.lists.desc.scroll set ] \
		-highlightthickness 0
	pack $form.lists.desc.label 
	pack $form.lists.desc.list -side left
	pack $form.lists.desc -side left

	#
	# Add a scrollbar to the lists
	#
	scrollbar $form.lists.desc.scroll -takefocus 0 -highlightthickness 0
	pack $form.lists.desc.scroll -side left -fill y
	pack $form.lists -pady 16

	#
	# Bind the lists so they act together
	#
	vclutils__BindMultiScrollbar $form.lists.desc.scroll \
		$form.lists.dest.list $form.lists.type.list \
		 $form.lists.desc.list

	vclutils__BindMultiList $double_click $form.lists.dest.list \
		$form.lists.type.list $form.lists.desc.list

	
	#
	# Setup a combobox to set the default
	#
	set modem_adm__default_saved {}
	ComboBox $form.default -ewidth 12 -listheight 3 -lbltext "Default:" \
		-strict 1 -listwidth 12 -textvariable modem_adm__default \
		-state $state

	pack $form.default

	#
	# Setup a trace for whenever the default destination is changed
	#
	trace variable modem_adm__default w modem_adm__SetDefault


	frame $form.buttons
	button $form.buttons.done -width 7 -height 2 -text Done \
		-command { modem_adm__Done }
	button $form.buttons.edit -width 7 -height 2 -text Edit -state $state \
		-command { modem_adm__Edit }
	button $form.buttons.newdevice  -width 7 -height 2 -state $state \
		-text "New\nDevice" -command { modem_adm__NewDevice }
	button $form.buttons.newclass -width 7 -height 2 -state $state \
		-text "New\nClass" -command { modem_adm__NewClass }
	button $form.buttons.delete -width 7 -height 2 -text Delete \
		-command { modem_adm__Delete } -state $state

	pack $form.buttons.done $form.buttons.edit $form.buttons.newdevice \
		$form.buttons.newclass $form.buttons.delete \
		-side left -expand 1
	pack $form.buttons -padx 16 -pady 16

	catch { pack $form }
	return
}


# +++PHDR+++
#
# Procedure:	modem_adm__FillMainList
#
# Description:
#
#
# Argument		Description
# --------------------	----------------------------------------------------
# n/a
#
#
# Returns: 	nothing
#
#
# Notes:
#
# ---PHDR---

proc modem_adm__FillMainList { } {
	global modem_adm__shell

	#
	# Clear the current lists and default combobox
	#
	${modem_adm__shell}.lists.dest.list delete 0 end
	${modem_adm__shell}.lists.type.list delete 0 end
	${modem_adm__shell}.lists.desc.list delete 0 end
	${modem_adm__shell}.default del 0 end
#	ComboBox_del ${modem_adm__shell}.default 0 end

	#
	# Get a list of destinations and fill in the lists
	#
	set dests [ @modem_adm list ]
	foreach dest $dests {
		@modem_adm list $dest -array rec
		${modem_adm__shell}.lists.dest.list insert end $rec(name)
		${modem_adm__shell}.lists.type.list insert end $rec(type)
		${modem_adm__shell}.lists.desc.list insert end $rec(comment)

		${modem_adm__shell}.default add $rec(name)
	}

	#
	# Set the size of the Default destination popdown list
	#
	set num_dests [llength $dests]
	if { $num_dests < 2 } {
		set num_dests 2
	}

	${modem_adm__shell}.default configure -listheight $num_dests
	return
}


# +++PHDR+++
#
# Procedure:	modem_adm__Delete
#
# Description:
#
#
# Argument		Description
# --------------------	----------------------------------------------------
# n/a
#
#
# Returns: 	nothing
#
#
# Notes:
#
# ---PHDR---

proc modem_adm__Delete {} {
	global modem_adm__shell modem_adm__default_saved


	#
	# Get the selected destination
	#
	set selected [vclutils__GetSelected ${modem_adm__shell}.lists.dest.list]
	if { $selected == {} } { return }

	#
	# Ask if he really wants to delete this destination
	#
	set answer [ tk_messageBox -title "Delete Destination" -type yesno \
			-icon question -parent ${modem_adm__shell} \
			-message "Do you really wish to delete\n\
				the \"$selected\" destination?" ]
			
	if { $answer != "yes" } { 
		return 
	}

	#
	# If it is the default, remind user of that
	#
	if { ${modem_adm__default_saved} == $selected } {
		set answer [ tk_messageBox -title "Delete Default" -type yesno \
				-icon question -parent ${modem_adm__shell} \
			-message "Destination \"$selected\" is the default.\n\
				Do you really want to delete it?" ]
			
		if { $answer != "yes" } { 
			return 
		}
	}

	#
	# Delete the selected item and update the list
	#
	@modem_adm delete $selected
	modem_adm__FillMainList

	#
	# Reset the default destination just in case it was deleted
	#
	set modem_adm__default [ @modem_adm default ]
}



# +++PHDR+++
#
# Procedure:	modem_adm__Done
#
# Description:
#
#
# Argument		Description
# --------------------	----------------------------------------------------
# n/a
#
#
# Returns:	nothing
#
#
# Notes:
#
# ---PHDR---

proc modem_adm__Done {} {
	global modem_adm__done modem_adm__shell

	set modem_adm__done 1
}


# +++PHDR+++
#
# Procedure:	modem_adm__Edit
#
# Description:
#
#
# Argument		Description
# --------------------	----------------------------------------------------
# n/a
#
#
# Returns:	nothing
#
#
# Notes:
#
# ---PHDR---

proc modem_adm__Edit {} {
	global modem_adm__shell

	set selected [vclutils__GetSelected ${modem_adm__shell}.lists.dest.list]

	if { $selected == "" } {
		return
	}

	#
	# Popup the form based on the type of destination
	#
	if { [@modem_adm type $selected] == "class" } {
		vclutils__LoadSource class_adm__Edit classadm.tcl
		catch { set return_code [class_adm__Edit \
			${modem_adm__shell} $selected] }
	} else {
		vclutils__LoadSource device_adm__Edit devadm.tcl
		catch { set return_code [device_adm__Edit \
			${modem_adm__shell} $selected] }
	}

	if { $return_code } {
		set index [${modem_adm__shell}.lists.dest.list curselection]
		
		${modem_adm__shell}.lists.dest.list delete $index
		${modem_adm__shell}.lists.type.list delete $index
		${modem_adm__shell}.lists.desc.list delete $index

		@modem_adm list $selected -array rec
		${modem_adm__shell}.lists.dest.list insert $index $rec(name)
		${modem_adm__shell}.lists.type.list insert $index $rec(type)
		${modem_adm__shell}.lists.desc.list insert $index $rec(comment)

		vclutils__SetSelected $index \
			${modem_adm__shell}.lists.dest.list \
			${modem_adm__shell}.lists.type.list \
			${modem_adm__shell}.lists.desc.list
	}
}


# +++PHDR+++
#
# Procedure:	modem_adm__NewClass
#
# Description:	"New Class" command proc
#
#
# Argument		Description
# --------------------	----------------------------------------------------
# n/a
#
#
# Returns:	nothing
#
#
# Notes:
#
# ---PHDR---

proc modem_adm__NewClass {} {
	global modem_adm__shell

	if { [vclutils__LoadSource class_adm__Edit classadm.tcl] != 1 } {
		return
	}

	if { [class_adm__Edit ${modem_adm__shell} ""] } {
		modem_adm__FillMainList
	}
}


# +++PHDR+++
#
# Procedure:	modem_adm__NewDevice
#
# Description:	"New Device" command proc
#
#
# Argument		Description
# --------------------	----------------------------------------------------
# n/a
#
#
# Returns:	nothing
#
#
# Notes:
#
# ---PHDR---

proc modem_adm__NewDevice {} {
	global modem_adm__shell

	if { [vclutils__LoadSource {device_adm__Edit} devadm.tcl] != 1 } {
		return
	}


	if { [device_adm__Edit ${modem_adm__shell} ""] } {
		modem_adm__FillMainList
	}
}


# +++PHDR+++
#
# Procedure:	modem_adm__SetDefault
#
# Description:	This procedure is called when the modem_adm__default value
#               has changed, so that the new default can be set in the
#               database.
#
#
# Argument		Description
# --------------------	----------------------------------------------------
# varname               Not used (must be specified for trace proc)
# index                 Not used (must be specified for trace proc)
# op                    Not used (must be specified for trace proc)
#
#
# Returns:	nothing
#
#
# Notes:
#
# ---PHDR---

proc modem_adm__SetDefault {varname index op} {
	global modem_adm__shell modem_adm__default modem_adm__default_saved

	if { ${modem_adm__default} == {} } {
		return
	}

	if { ${modem_adm__default} == ${modem_adm__default_saved} } {
		return
	}

	set modem_adm__default_saved ${modem_adm__default}
	@modem_adm default ${modem_adm__default}

	return
}


proc modem_adm__Popup { parent modem_adm_shell } {
	global modem_adm__shell modem_adm__done

	#
	# Get a modem admin object
	#
	catch { vcl destroy @modem_adm }
	vcl modem @modem_adm

	#
	# Build and display the Modem database form
	#
	modem_adm__BuildMainForm $modem_adm_shell

	#
	# Position the dialog (if it's not the toplevel window)
	#
	vclutils__CenterDialog $modem_adm_shell $parent
	vclutils__LockSize $modem_adm_shell


	modem_adm__FillMainList

	vclutils__SetSelected 0 ${modem_adm__shell}.lists.dest.list \
		${modem_adm__shell}.lists.type.list \
		${modem_adm__shell}.lists.desc.list

	#
	# Set the default destination
	#
	set modem_adm__default_saved [ @modem_adm default ]
	set modem_adm__default ${modem_adm__default_saved}
	${modem_adm__shell}.default set ${modem_adm__default}
	
	#
	# Make the dialog modal
	#
	update
	grab ${modem_adm__shell}

	#
	# Wait for the dialog to be done
	#
	tkwait variable modem_adm__done
	grab release ${modem_adm__shell}

	#
	# Destroy the interface and everything else
	#
	catch { vcl destroy @modem_adm }
	if { ${modem_adm__shell} == ".modem_adm" } {
		catch { destroy ${modem_adm__shell} }
	}
}

