# +++PHDR+++
#
# Procedure:	device_params__BuildMainForm
#
# Description:	Draws the main form for the device parameters editor
#
#
# Argument		Description
# --------------------	----------------------------------------------------
# form_shell		Pathname of toplevel shell for interface.
#
#
# Returns:	nothing
#
#
# Notes:
#
# ---PHDR---

proc device_params__BuildMainForm { form_shell } {
	global device_params__default device_params__shell device_params__ini
	global vsimenu__hostname
	global vsimenu__isadmin


	#
	# Get the state for the input controls
	#
	if { $vsimenu__isadmin } {
		set stateflg "normal"
	} else {
		set stateflg "disabled"
	}

	#
	# Create the top level shell if the form_shell is not "."
	#
	if { $form_shell == "." } {
		set form ".frame"
		set device_params__shell ".frame"
		catch { destroy $form }
		frame $form
	} else {
        	catch { destroy $form_shell }
		toplevel $form_shell
		set form $form_shell
		set device_params__shell $form_shell
	}

	#
	# Put the title on the shell
	#
	set vtitle "$vsimenu__hostname - Device Parameters Editor"
	wm title $form_shell $vtitle

	#
	# Setup a handler for the window manager "Close" function
	#
	wm protocol $form_shell WM_DELETE_WINDOW device_params__Cancel


	#
	# Build the Fax Number Modifier Fields
	#
	frame $form.faxmods -relief groove -borderwidth 1
	label $form.faxmods.label -text "Fax Number Modifiers" \
		-anchor w -justify left
	grid $form.faxmods.label -row 0 -column 0 -columnspan 8 \
		-pady 8 -sticky wn

	label $form.faxmods.prefix_label -text "Dial Prefix:"
	grid $form.faxmods.prefix_label -in $form.faxmods -row 1 -column 0 \
		-sticky e -pady 8
	entry $form.faxmods.prefix_entry -relief sunken -state $stateflg \
		-width 16 -textvariable device_params__ini(Dialprefix)
	grid $form.faxmods.prefix_entry -in $form.faxmods -row 1 -column 1 \
		-sticky ew -columnspan 3

	label $form.faxmods.suffix_label -text "Dial Suffix:"
	grid $form.faxmods.suffix_label -in $form.faxmods -row 1 -column 4 \
		-sticky e
	entry $form.faxmods.suffix_entry -relief sunken -state $stateflg \
		-width 18 -textvariable device_params__ini(Dialsuffix)
	grid $form.faxmods.suffix_entry -in $form.faxmods -row 1 -column 5 \
		-sticky ew -columnspan 2

	label $form.faxmods.ldprefix_label -text "LongDist Prefix:"
	grid $form.faxmods.ldprefix_label -in $form.faxmods -row 2 -column 0 \
		-sticky e -pady 8
	entry $form.faxmods.ldprefix_entry -relief sunken -state $stateflg \
		-width 16 -textvariable device_params__ini(Longdistprefix)
	grid $form.faxmods.ldprefix_entry -in $form.faxmods -row 2 -column 1 \
		-sticky ew -columnspan 3

	label $form.faxmods.ldsuffix_label -text "LongDist Suffix:"
	grid $form.faxmods.ldsuffix_label -in $form.faxmods -row 2 -column 4 \
		-sticky e
	entry $form.faxmods.ldsuffix_entry -relief sunken -state $stateflg \
		-width 18 -textvariable device_params__ini(Longdistsuffix)
	grid $form.faxmods.ldsuffix_entry -in $form.faxmods -row 2 -column 5 \
		-sticky ew -columnspan 2

#	label $form.faxmods.ldaccess -text "LongDist Access:"
#	grid $form.faxmods.ldaccess_label -in $form.faxmods -row 2 -column 4 \
#		-sticky e
#	entry $form.faxmods.ldaccess_entry -relief sunken -state $stateflg \
#		-width 5 -textvariable device_params__ini(Longdistaccess)
#	grid $form.faxmods.ldaccess_entry -in $form.faxmods -row 2 -column 5 \
#		-sticky ew -columnspan 2

	label $form.faxmods.inprefix_label -text "Intl Prefix:"
	grid $form.faxmods.inprefix_label -in $form.faxmods -row 3 -column 0 \
		-sticky e -pady 8
	entry $form.faxmods.inprefix_entry -relief sunken -state $stateflg \
		-width 16 -textvariable device_params__ini(Intlprefix)
	grid $form.faxmods.inprefix_entry -in $form.faxmods -row 3 -column 1 \
		-sticky ew -columnspan 3

	label $form.faxmods.insuffix_label -text "Intl Suffix:"
	grid $form.faxmods.insuffix_label -in $form.faxmods -row 3 -column 4 \
		-sticky e
	entry $form.faxmods.insuffix_entry -relief sunken -state $stateflg \
		-width 18 -textvariable device_params__ini(Intlsuffix)
	grid $form.faxmods.insuffix_entry -in $form.faxmods -row 3 -column 5 \
		-sticky ew -columnspan 2

#	label $form.faxmods.inaccess -text "Intl Access:"
#	grid $form.faxmods.inaccess_label -in $form.faxmods -row 3 -column 7 \
#		-sticky e
#	entry $form.faxmods.inaccess_entry -relief sunken -state $stateflg \
#		-width 5 -textvariable device_params__ini(Intlaccess)
#	grid $form.faxmods.inaccess_entry -in $form.faxmods -row 3 -column 8 \
#		-sticky ew -columnspan 2

	label $form.faxmods.country_label -text "Country Code:" 
	grid $form.faxmods.country_label -in $form.faxmods -row 4 -column 0 \
		-sticky e 
	entry $form.faxmods.country_entry -relief sunken -state $stateflg \
		-width 3 -textvariable device_params__ini(Countrycode)
	grid $form.faxmods.country_entry -in $form.faxmods -row 4 -column 1

	label $form.faxmods.area_label -text " Area Code:"
	grid $form.faxmods.area_label -row 4 -column 2 -sticky w
	entry $form.faxmods.area_entry -relief sunken -state $stateflg \
		-width 5 -textvariable device_params__ini(Areacode)
	grid $form.faxmods.area_entry -row 4 -column 3 -sticky w

	label $form.faxmods.len_label -text " Local # Length:"
	grid $form.faxmods.len_label -row 4 -column 4 -sticky w
	entry $form.faxmods.len_entry -width 3 -state $stateflg \
		-textvariable device_params__ini(Localnumlen)
	grid $form.faxmods.len_entry -row 4 -column 5 -sticky w

	frame $form.faxmods.bottom_spacer -height 16
	grid $form.faxmods.bottom_spacer -row 5

	pack $form.faxmods -ipadx 16 -pady 16 -padx 16 -fill x
	

	#
	# Build the Fax Page Header Fields
	#
	frame $form.header -relief groove -borderwidth 1
	frame $form.header.in
	label $form.header.in.label -text "Page Header" -anchor w -justify left
	grid $form.header.in.label -row 0 -column 0 -sticky wn \
		-columnspan 3

	checkbutton $form.header.in.enabled -text "Enable Header" \
		-justify left -var device_params__ini(Enableheaders) \
		-onvalue "yes" -offvalue "no" -state $stateflg
	grid $form.header.in.enabled -row 1 -column 0 \
		-padx 24 -pady 8 -columnspan 3 \
		-sticky w

	checkbutton $form.header.in.printline -text "Print Line Below Header" \
		-justify left -var device_params__ini(Pagehdrline) \
		-onvalue "on" -offvalue "off" -state $stateflg
	grid $form.header.in.printline -row 1 -column 2 -pady 8 \
		-padx 24 -sticky w -columnspan 3

	frame $form.header.in.spacer -width 16
	grid $form.header.in.spacer -row 2 -column 0

	label $form.header.in.string_label -text "Header String:" -width 14 \
		-justify r -anchor e
	grid $form.header.in.string_label -in $form.header.in \
		-row 3 -column 1 -sticky e -pady 8
	entry $form.header.in.string_entry -relief sunken -state $stateflg \
		-width 45 -textvariable device_params__ini(Pagehdrstring)
	grid $form.header.in.string_entry \
		-row 3 -column 2 -sticky ew -columnspan 3

	ComboBox $form.header.in.date -ewidth 10 -lbltext "Date Format:" \
		-lblwidth 14 -listwidth 10 -state $stateflg \
		-listheight 2 -textvariable device_params__ini(Dateformat)
	$form.header.in.date add "%m/%d/%y"
	$form.header.in.date add "%d/%m/%y"
	grid $form.header.in.date -row 4 -column 1 -columnspan 2 -sticky w

	ComboBox $form.header.in.time -ewidth 10 -lbltext "Time Format:" \
		-lblwidth 14 -listwidth 10 -state $stateflg \
		-listheight 2 -textvariable device_params__ini(Timeformat)
	$form.header.in.time add "%I:%M %Z"
	$form.header.in.time add "%H:%M %Z"
	grid $form.header.in.time -row 4 -column 3 -columnspan 2 -sticky w

	pack $form.header.in -ipadx 16 -ipady 16 -anchor w
	pack $form.header -anchor w -padx 16 -pady 8 -fill x


	#
	# Build the TSI & CSI Entries
	#
	frame $form.ids
	label $form.ids.tsi_label -text "TSI:" -anchor e -width 13
	entry $form.ids.tsi_entry -relief sunken -state $stateflg \
		-width 20 -textvariable device_params__ini(Tsistring)
	pack $form.ids.tsi_label $form.ids.tsi_entry -side left
	
	label $form.ids.csi_label -text "CSI:" -anchor e -width 8
	entry $form.ids.csi_entry -relief sunken -state $stateflg \
		-width 20 -textvariable device_params__ini(Csistring)
	pack $form.ids.csi_label $form.ids.csi_entry -side left

	pack $form.ids -pady 8 -padx 16 -anchor w 


	#
	# Separate the form from the dialog buttons
	#
	frame $form.dlg_separator -relief groove -borderwidth 1 -height 2
	pack $form.dlg_separator -padx 2 -pady 8 -fill x 
	

	frame $form.buttons
	button $form.buttons.ok -width 6 -text "OK" \
		-command { device_params__OK }
	button $form.buttons.cancel -width 6 -text "Cancel" \
		-command { device_params__Cancel }
	button $form.buttons.reset -width 6 -text "Reset" \
		-command { device_params__Reset }
	pack $form.buttons.ok $form.buttons.cancel $form.buttons.reset \
		-side left -expand 1
	pack $form.buttons -expand 1 -fill x -pady 8 -padx 16 -ipadx 4
}


# +++PHDR+++
#
# Procedure:	device_params__OK
#
# Description:	Callback for the "OK" button. Commits the addition or 
#               changes to the form.
#
#
# Argument		Description
# --------------------	----------------------------------------------------
# n/a
#
# Returns:	nothing
#
#
# Notes:	
#
# ---PHDR---

proc device_params__OK {} {
	global device_params__done device_params__ini

	set device_params__done 1
}



# +++PHDR+++
#
# Procedure:	 device_params__Cancel
#
# Description:	"Cancel" command proc. Sets the done flag so tkwait returns.
#
#
# Argument		Description
# --------------------	----------------------------------------------------
# n/a
#
#
# Returns:	nothing
#
#
# Notes:
#
# ---PHDR---

proc device_params__Cancel {} {
	global device_params__done

	set device_params__done 0
}


# +++PHDR+++
#
# Procedure:	device_params__Reset
#
# Description:	"Reset" command proc. Resets the edit form to original values.
#
#
# Argument		Description
# --------------------	----------------------------------------------------
# n/a
#
#
# Returns:	nothing
#
#
# Notes:
#
# ---PHDR---

proc device_params__Reset {} {
	global device_params__ini device_params__instance

	catch {
		@devparam_ini get -object DEVICE \
			-inst ${device_params__instance} \
			-array device_params__ini
	}
}


# +++PHDR+++
#
# Procedure:	device_params__Popup
#
# Description:
#
#
# Argument		Description
# --------------------	----------------------------------------------------
#
#
# Returns:
#
#
# Notes:
#
# ---PHDR---

proc device_params__Popup { parent device_params_shell instance } {
	global device_params__shell device_params__ini device_params__done
	global device_params__instance ini_data
	global vsimenu__isadmin

	#
	# Save the instance name
	#
	set device_params__instance $instance

	#
	# Get the device parameters ini object
	#
	catch { vcl destroy @devparam_ini }

	if { $vsimenu__isadmin } {
		vcl ini @devparam_ini -server
	} else {
		vcl ini @devparam_ini -server -mode r
	}

	catch {
		@devparam_ini get -object DEVICE \
			-inst ${device_params__instance} \
			-array device_params__ini
	}

	#
	# Build and display the User database form
	#
	device_params__BuildMainForm $device_params_shell
	vclutils__CenterDialog $device_params_shell $parent
	vclutils__LockSize $device_params_shell


	#
	# Make the dialog modal
	#
	update
	grab ${device_params__shell}


	#
	# Set the focus to Dial Prefix entry
	#
	focus ${device_params__shell}.faxmods.prefix_entry


	#
	# Wait for the dialog to be done
	#
	tkwait variable device_params__done
	grab release ${device_params__shell}


	#
	# Destroy everything we created
	#
	catch { vcl destroy @device_params }
	if { ${device_params__shell} != "." } {
		catch { destroy ${device_params__shell} }
	}

	#
	# Save the ini configuration?
	#
	if { ${device_params__done} } {
		@devparam_ini set -object DEVICE -array device_params__ini \
			-inst ${device_params__instance}

		@devparam_ini save
	}

	catch { vcl destroy @devparam_ini }
}
