# +++PHDR+++
#
# Procedure:	company_info__BuildMainForm
#
# Description:	Draws the main form for the company ionformation editor
#
#
# Argument		Description
# --------------------	----------------------------------------------------
# form_shell		Pathname of toplevel shell for interface.
#
#
# Returns:	nothing
#
#
# Notes:
#
# ---PHDR---

proc company_info__BuildMainForm { form_shell } {
	global company_info__shell company_info__ini
	global force_cvr_update
	global vsimenu__hostname
	global vsimenu__isadmin

	#
	# Get the state for the input controls
	#
	if { $vsimenu__isadmin } {
		set state "normal"
	} else {
		set state "disabled"
	}

	#
	# Create the top level shell if the form_shell is not "."
	#
	if { $form_shell == "." } {
		set form ".frame"
		set company_info__shell ".frame"
		catch { destroy $form }
		frame $form
	} else {
        	catch { destroy $form_shell }
		toplevel $form_shell
		set form $form_shell
		set company_info__shell $form_shell
	}

	#
	# Put the title on the shell
	#
	set vtitle "$vsimenu__hostname - Company Information"
	wm title $form_shell $vtitle

	#
	# Setup a handler for the window manager "Close" function
	#
	wm protocol $form_shell WM_DELETE_WINDOW company_info__Cancel
	
	#
	# Put in the spacers
	#
	frame $form.spacer1 -height 16 -width 16
	grid $form.spacer1 -row 0 -column 0 

	frame $form.spacer2 -height 16 -width 16
	grid $form.spacer2 -row 3 -column 3

	frame $form.spacer3 -height 16 -width 16
	grid $form.spacer3 -row 8 -column 0

	frame $form.spacer4 -height 16
	grid $form.spacer4 -row 16 -column 0


	#
	# Build the Company Field
	#
	label $form.company_label -text "Company:" 
	grid $form.company_label -row 1 -column 1 -sticky e
	entry $form.company_entry -width 32 -state $state \
		-textvariable company_info__ini(Company)
	grid $form.company_entry -row 1 -column 2

	#
	# Build the Address Fields
	#
	label $form.addr1_label -text "Address 1:"
	grid $form.addr1_label -row 4 -column 1 -sticky e
	entry $form.addr1_entry -relief sunken -state $state \
		-width 32 -textvariable company_info__ini(Addr1)
	grid $form.addr1_entry -row 4 -column 2
	
	label $form.addr2_label -text "Address 2:"
	grid $form.addr2_label -row 5 -column 1 -sticky e
	entry $form.addr2_entry -relief sunken -state $state \
		-width 32 -textvariable company_info__ini(Addr2)
	grid $form.addr2_entry -row 5 -column 2
	
	label $form.addr3_label -text "Address 3:"
	grid $form.addr3_label -row 6 -column 1 -sticky e
	entry $form.addr3_entry -relief sunken -state $state \
		-width 32 -textvariable company_info__ini(Addr3)
	grid $form.addr3_entry -row 6 -column 2

	label $form.country_label -text "Country:"
	grid $form.country_label -row 7 -column 1 -sticky e
	entry $form.country_entry -relief sunken -state $state \
		-width 16 -textvariable company_info__ini(Country)
	grid $form.country_entry -row 7 -column 2 -sticky w


	#
	# Build the Voice and Fax phone fields
	#
	label $form.voice_label -text "Voice Phone:"
	grid $form.voice_label -row 9 -column 1 -sticky e
	entry $form.voice_entry -relief sunken -state $state \
		-width 16 -textvariable company_info__ini(Vphone)
	grid $form.voice_entry -row 9 -column 2 -sticky w

	label $form.fax_label -text "FAX Phone:"
	grid $form.fax_label -row 11 -column 1 -sticky e
	entry $form.fax_entry -relief sunken -state $state \
		-width 16 -textvariable company_info__ini(Fphone)
	grid $form.fax_entry -row 11 -column 2 -sticky w


	#
	# Build the email field
	#
	label $form.email_label -text "Email:"
	grid $form.email_label -row 12 -column 1 -sticky e -pady 16
	entry $form.email_entry -relief sunken -state $state \
		-width 32 -textvariable company_info__ini(Email)
	grid $form.email_entry -row 12 -column 2


	#
	# Create the "Update Covers..." button
	#
	if { $force_cvr_update == "" } {
		button $form.update_covers -text "Update Covers..." \
			-command { company_info__UpdateCovers } -state $state
		grid $form.update_covers -row 13 -column 1 -columnspan 2
	}


	#
	# Separate the form from the dialog buttons
	#
	frame $form.dlg_separator -relief groove -borderwidth 1 -height 2
	grid $form.dlg_separator -row 14 -column 0 -columnspan 4 \
		-sticky ew -pady 16
	

	frame $form.buttons
	button $form.buttons.ok -width 6 -text "OK" \
		-command { company_info__OK }
	button $form.buttons.cancel -width 6 -text "Cancel" -state $state \
		-command { company_info__Cancel }
	button $form.buttons.reset -width 6 -text "Reset" -state $state \
		-command { company_info__Reset }
	pack $form.buttons.ok $form.buttons.cancel $form.buttons.reset \
		-side left -expand 1
	grid $form.buttons -row 15 -column 0 -columnspan 4 -sticky ew

	catch { pack $form }
	return
}


# +++PHDR+++
#
# Procedure:	company_info__OK
#
# Description:	Callback for the "OK" button. Coomits the addition or 
#               changes to the form.
#
#
# Argument		Description
# --------------------	----------------------------------------------------
# n/a
#
# Returns:	nothing
#
#
# Notes:	
#
# ---PHDR---

proc company_info__OK {} {
	global company_info__done
	global vsimenu__isadmin

	#
	# Set done to 1 if this is the administrator otherwiae set it to 0
	# this tells us wether to save the info or not
	#
	if { $vsimenu__isadmin } {
		set company_info__done 1
	} else {
		set company_info__done 0
	}
}


# +++PHDR+++
#
# Procedure:	company_info__UpdateCovers
#
# Description:
#
#
# Argument		Description
# --------------------	----------------------------------------------------
#
#
# Returns:
#
#
# Notes:
#
# ---PHDR---

proc company_info__UpdateCovers {} {
	global env company_info__ini company_info__shell
	global force_cvr_update covers_done

	#
	# First get a list of covers that we can update
	#
	set cover_list [vcl resource covers -names]

	#
	# Ask the user if he/she wants to update them
	#
	set answer "yes"
	if { $force_cvr_update == "" } {
		set answer [ tk_messageBox -title "Update Covers" -type yesno \
			-icon question -parent ${company_info__shell} \
			-message "Update the following covers:\n $cover_list" ]
	}

	#
	# If "No" was selected get outa here
	#
	if { $answer == "no" } { 
		return 
	}
	
	set covers_done 1

	#
	# Save the current file data
	#
	@coinfo_ini get -object USERINFO     -array saved_ini

	#
	# Put the form in the file and save it
	#
	@coinfo_ini set -object USERINFO     -array company_info__ini
	@coinfo_ini save


	#
	# Exec the shell script to update the covers. We popup a little
	# message to let them know what's going on
	#
	catch { destroy .update_covers_msg }	
	toplevel .update_covers_msg
	wm title .update_covers_msg "Update Covers"
	label .update_covers_msg.label -text "Updating covers ... Please wait"
	pack .update_covers_msg.label

	vclutils__MoveDialog .update_covers_msg ${company_info__shell} 16 16
	update
		
	#
	# Do each cover in the cover list
	#
	foreach cover $cover_list {

		#
		# update msg box
		#
		.update_covers_msg.label configure \
			-text "Updating $cover ... Please wait"
		update

		#
		# update the cvr
		#
		catch { vcl cvrfix $cover }
	}

	#
	# Destroy the little message window
	destroy .update_covers_msg

	#
	# Restore the file data
	#
	@coinfo_ini set -object USERINFO -array saved_ini
	@coinfo_ini save
}


# +++PHDR+++
#
# Procedure:	 company_info__Cancel
#
# Description:	"Cancel" command proc. Sets the done flag so tkwait returns.
#
#
# Argument		Description
# --------------------	----------------------------------------------------
# n/a
#
#
# Returns:	nothing
#
#
# Notes:
#
# ---PHDR---

proc company_info__Cancel {} {
	global company_info__done

	set company_info__done 0
}


# +++PHDR+++
#
# Procedure:	company_info__Reset
#
# Description:	"Reset" command proc. Resets the edit form to original values.
#
#
# Argument		Description
# --------------------	----------------------------------------------------
# n/a
#
#
# Returns:	nothing
#
#
# Notes:
#
# ---PHDR---

proc company_info__Reset {} {
	global company_info__ini	

	@coinfo_ini get -object USERINFO -array company_info__ini
}


# +++PHDR+++
#
# Procedure:	company_info__Popup
#
# Description:
#
#
# Argument		Description
# --------------------	----------------------------------------------------
#
#
# Returns:
#
#
# Notes:
#
# ---PHDR---

proc company_info__Popup { parent company_info_shell in_install } {
	global company_info__shell company_info__done company_info__ini
	global force_cvr_update covers_done
	global vsimenu__isadmin


	#
	# Get the company-info ini object
	#
	catch { vcl destroy @coinfo_ini }

	if { $vsimenu__isadmin } {
		vcl ini @coinfo_ini -server
	} else {
		vcl ini @coinfo_ini -server -mode r
	}

	@coinfo_ini get -object USERINFO -array company_info__ini

	set force_cvr_update $in_install
	set covers_done 0

	#
	# Build and display the form
	#
	company_info__BuildMainForm $company_info_shell
	vclutils__CenterDialog $company_info_shell $parent
	vclutils__LockSize $company_info_shell


	#
	# Make the dialog modal
	#
	update
	grab ${company_info__shell}

	#
	# Wait for the dialog to be done
	#
	tkwait variable company_info__done
	grab release ${company_info__shell}

	#
	# check if force update covers
	#
	if { $force_cvr_update != "" && $covers_done == 0 } {
		company_info__UpdateCovers
	}

	#
	# Destroy everything we created
	#
	destroy ${company_info__shell}	


	#
	# Save the ini configuration?
	#
	if { ${company_info__done} } {
		@coinfo_ini set -object USERINFO      -array company_info__ini
		@coinfo_ini save
	}
}

