# ------------------------------------------------------------------------
# restorefodc.tcl
#	Restore the main FoDC fim if disabled for more than MAX_DOWN_TIME_MIN 
#	minutes (30 by default).
#
#	Check your crontab.lst file to schedule this script's execution.
# ------------------------------------------------------------------------
set VSIFAX	$env(VSIFAX)

# ------------------------------------------------------------------------
# Configurable globals
# ------------------------------------------------------------------------
set FODC_MAIN_DEVICE "FoDC"
set FODC_FAILOVER_DEVICE "FoDC2"
set MAX_DOWN_TIME_MIN 30

# ------------------------------------------------------------------------
# First, check if the FoDC Failover is enabled and configured
# ------------------------------------------------------------------------
set FODC_MAIN_CONFIGURED ""
set FODC_FAILOVER_CONFIGURED ""
set FODC_FAILOVER_ENABLED "0"
catch {set FODC_FAILOVER_ENABLED [exec "$VSIFAX/bin/vfxadmin" config -slqb -i $FODC_MAIN_DEVICE DEVICE failover]}
catch {set FODC_MAIN_CONFIGURED [exec "$VSIFAX/bin/vfxadmin" config -slq -i $FODC_MAIN_DEVICE DEVICE accountid]}
catch {set FODC_FAILOVER_CONFIGURED [exec "$VSIFAX/bin/vfxadmin" config -slq -i $FODC_FAILOVER_DEVICE DEVICE accountid]}
if {[string compare "$FODC_FAILOVER_ENABLED" "0"] == 0
		|| [string length "$FODC_MAIN_CONFIGURED"] == 0
		|| [string length "$FODC_FAILOVER_CONFIGURED"] == 0 } {
	catch {puts stdout "FoDC not configured or failover is disabled."}
	exit 0
}

catch { set fimdetails [ exec "$VSIFAX/bin/vfxadmin" device -l -F tcl $FODC_MAIN_DEVICE ] }
eval $fimdetails

if { [string compare "$ena" "false"] == 0 } { 
	# RESTORETIME = NOW - MAX_DOWN_TIME
	set RESTORETIME [ clock format [ expr { [ clock seconds ] - [ expr { $MAX_DOWN_TIME_MIN * 60 } ] } ] -format {%Y%m%d%H%M%S} ]
	if { [string compare $esi $RESTORETIME] <= 0 } {
		catch {exec "$VSIFAX/bin/vfxadmin" enable $FODC_MAIN_DEVICE}
		catch {exec "$VSIFAX/bin/vfxadmin" disable $FODC_FAILOVER_DEVICE}
		catch {puts stdout "$FODC_MAIN_DEVICE device restored."}
	} else {
		catch {puts stdout "Maximum allowed down time not reached yet."}
	}
} else {
	catch {puts stdout "Main $FODC_MAIN_DEVICE is already enabled."}
}
