#!/bin/sh
#
#+++FHDR+++
#
#	Description:
#
#	final processing for fxserver installation
#
#---FHDR---

# ------------------------------------------------------------------------
# check if running in windows
#
in_windows ()
{
	[ -d "c:/" ]
}

# ------------------------------------------------------------------------
# add a directory to the path
#
# Note that the directory is ALWAYS added to the end.
#
addpath ()
{
	dir="$1"

	sep=":"
	arg=""
	if in_windows
	then
		sep=";"
		arg="-i"
	fi

	foo=`echo "$PATH" | egrep $arg "^$dir$sep|$sep$dir$sep|$sep$dir$"`
	if [ $? -eq 0 ]
	then
		echo "$PATH"
	else
		echo "$PATH$sep$dir"
	fi

	unset dir sep arg foo
}

# ------------------------------------------------------------------------
# get name of root
#
rootname ()
{
	if in_windows
	then
		echo "Administrator"
	else
		grep '^[^:]*:[^:]*:0:' /etc/passwd | head -1 | cut -f1 -d:
	fi
}

# ------------------------------------------------------------------------
# main()
#
PATH=`addpath "$VSIFAX/bin"`
PATH=`addpath "$VSIFAX/lbin"`

# ------------------------------------------------------------------------
# Fix Stick bit issue for Eicon fim
#
if [ -f "$VSIFAX/lbin/fim-ei" ]
then
	ROOTNAME=`rootname`
	chown "$ROOTNAME" "$VSIFAX/lbin/fim-ei"
	chmod +s "$VSIFAX/lbin/fim-ei"
fi

# ------------------------------------------------------------------------
# Invoke the setup script
#
vsi-server-setup.sh

# ------------------------------------------------------------------------
# now do any configuration
#
if [ "$QUICK_INSTALL" != "yes" ]
then
	vsi-server-config.sh
fi

exit 0
