#!/bin/sh
# ------------------------------------------------------------------------
#
#	Description:
#
#	This is the default system TNP for all jobs
#
#	usage: <tnp> reqid clientid mailaddr time notify grpid \
#			numpgs faxnum aresult rresult attempt done
#
# ------------------------------------------------------------------------

# ------------------------------------------------------------------------
# get all arguments
#
REQID="$1"
CLIENTID="$2"
MAILADDR="$3"
SENDTIME="$4"
NOTIFY="$5"
GRPID="$6"
NUMPGS="$7"
FAXNUM="$8"
ARESULT="$9"
shift
RRESULT="$9"
shift
ATTEMPT="$9"
shift
DONE="$9"
shift
USER_TNP="$9"

# ------------------------------------------------------------------------
# check if LCR notification needed for this job
#
"$VSIFAX/lbin/vlcrstat" $REQID

# ------------------------------------------------------------------------
# check if any print/email of notification/fax to be done
#
"$VSIFAX/lbin/vsend" $REQID

# ------------------------------------------------------------------------
# run the site TNP if it exists
#
"$VSIFAX/lbin/vnotify" -n -t site \
	"$REQID" "$CLIENTID" "$MAILADDR" "$SENDTIME" "$NOTIFY" \
	"$GRPID" "$NUMPGS" "$FAXNUM" "$ARESULT" "$RRESULT" "$ATTEMPT" \
	"$DONE"
status=$?
[ $status -ne 0 ] && exit $status

# ------------------------------------------------------------------------
# run the <user> TNP if it exists
#
if [ "$USER_TNP" != "" ]
then
	"$VSIFAX/lbin/vnotify" -t "$USER_TNP" \
		"$REQID" "$CLIENTID" "$MAILADDR" "$SENDTIME" "$NOTIFY" \
		"$GRPID" "$NUMPGS" "$FAXNUM" "$ARESULT" "$RRESULT" "$ATTEMPT" \
		"$DONE"
	status=$?
	[ $status -ne 0 ] && exit $status
fi

exit 0
