# ------------------------------------------------------------------------
#
#	Description:
#
#	This is the system GNP for all group jobs
#
#	usage: <gnp> reqid clientid mailaddr time notify grpid \
#				num-mems num-sent num-failed
#
# ------------------------------------------------------------------------

global argv argc env

# ------------------------------------------------------------------------
# get all arguments
#
set REQID    [ lindex $argv 0 ]
set CLIENTID [ lindex $argv 1 ]
set MAILADDR [ lindex $argv 2 ]
set SENDTIME [ lindex $argv 3 ]
set NOTIFY   [ lindex $argv 4 ]
set GRPID    [ lindex $argv 5 ]
set NUM_MEMS [ lindex $argv 6 ]
set NUM_SENT [ lindex $argv 7 ]
set NUM_FAIL [ lindex $argv 8 ]
set USER_GNP [ lindex $argv 9 ]

# ------------------------------------------------------------------------
# temp directory
#
set VSIFAX	$env(VSIFAX)

# ------------------------------------------------------------------------
# check if notification was specified
#
catch { exec "$VSIFAX/lbin/vsend" g-$GRPID }

# ------------------------------------------------------------------------
# run the site GNP if it exists
#
set status [ catch \
	{ exec "$VSIFAX/lbin/vnotify" -n -g site \
		"$REQID" \
		"$CLIENTID" \
		"$MAILADDR" \
		"$SENDTIME" \
		"$NOTIFY" \
		"$GRPID" \
		"$NUM_MEMS" \
		"$NUM_SENT" \
		"$NUM_FAIL" \
	} ]
if { $status != 0 } {
	exit 1
}

# ------------------------------------------------------------------------
# run the <user> GNP if it exists
#
if { [string compare "$USER_GNP" ""] == 0 } {
	exit 0
}

set status [ catch \
	{ exec "$VSIFAX/lbin/vnotify" -g "$USER_GNP" \
		"$REQID" \
		"$CLIENTID" \
		"$MAILADDR" \
		"$SENDTIME" \
		"$NOTIFY" \
		"$GRPID" \
		"$NUM_MEMS" \
		"$NUM_SENT" \
		"$NUM_FAIL" \
	} ]
if { $status != 0 } {
	exit 1
}

exit 0
