# +++PHDR+++
#
# Procedure:	device_adm__BuildForm
#
# Description:	Builds the "Device Editor" form
#
#
# Argument		Description
# --------------------	----------------------------------------------------
#
#
# Returns:
#
#
# Notes:
#
# ---PHDR---

proc device_adm__BuildForm { } {
	global device_adm__rec tcl_platform device_adm__shell
	global vsimenu__hostname

	set form ".device_shell"
	set device_adm__shell $form
       	catch { destroy $form}
	toplevel $form

	#
	# Put the title on the shell
	#
	set vtitle "$vsimenu__hostname - Device Editor"
	wm title $form $vtitle

	#
	# Setup a handler for the window manager "Close" function
	#
	wm protocol $form WM_DELETE_WINDOW device_adm__Cancel

	frame $form.topspace -height 16
	pack $form.topspace

	frame $form.name
	label $form.name.label -text "Name:" -width 16 -anchor e
	entry $form.name.entry -relief sunken -state disabled \
		-width 12 -textvariable device_adm__rec(name)
	pack $form.name.label $form.name.entry -side left
	pack $form.name -padx 16 -fill x

	frame $form.comment
	label $form.comment.label -text "Comment:" -width 16 -anchor e
	entry $form.comment.entry -relief sunken \
		-textvariable device_adm__rec(comment)
	pack $form.comment.label -side left
	pack $form.comment.entry -side left -fill x -expand 1
	pack $form.comment -padx 16 -fill x

	frame $form.spacer1 -height 12
	pack $form.spacer1

	frame $form.fim
	ComboBox $form.fim.fim -ewidth 8 -listheight 3 \
		-lbltext "FIM:" -lblwidth 16 -strict 1 -listwidth 3 \
		-textvariable device_adm__rec(fim)

	$form.fim.fim add "c2"

	if { $tcl_platform(os) == "Windows NT" } {
		$form.fim.fim add "bl"
		$form.fim.fim add "bt"
	}

	$form.fim.fim add "lb"
	$form.fim.fim add "sm"

	frame $form.fim.device
	label $form.fim.device.label -text "Device:" \
		-padx 2 -width 7 -anchor e
	entry $form.fim.device.entry -relief sunken -width 12 \
		-textvariable device_adm__rec(device)
	pack $form.fim.device.label -side left -anchor w
	pack $form.fim.device.entry -side left -anchor w

	pack $form.fim.fim -side left
	pack $form.fim.device -side left 
	pack $form.fim -padx 16 -fill x

	frame $form.inbox_rnp
	ComboBox $form.inbox_rnp.inbox -ewidth 8 -lbltext "Inbox:" -strict 1 \
		-lblwidth 16 -listwidth 8 -textvariable device_adm__rec(inbox)
	ComboBox $form.inbox_rnp.rnp -ewidth 12 -lbltext "RNP:" -lblwidth 7 \
		-listwidth 3 -textvariable device_adm__rec(rnp)
	pack $form.inbox_rnp.inbox -side left
	pack $form.inbox_rnp.rnp -side left -fill x
	pack $form.inbox_rnp -padx 16 -fill x


	frame $form.spacer3 -height 12
	pack $form.spacer3


	frame $form.accept
	label $form.accept.label -text "Jobs:" -width 16 -anchor e
	radiobutton $form.accept.on -text "Accept" \
		-width 8 -var device_adm__rec(accept) -value true \
		-command [list $form.rreason.entry configure -state disabled]
	radiobutton $form.accept.off -text "Reject" \
		-width 8 -var device_adm__rec(accept) -value false \
		-command [list $form.rreason.entry configure -state normal]
	pack $form.accept.label $form.accept.on $form.accept.off -side left
	pack $form.accept -padx 16 -fill x

	frame $form.rreason
	label $form.rreason.label -text "Reject Reason:" -width 16 -anchor e
	entry $form.rreason.entry -relief sunken \
		-textvariable device_adm__rec(reject)
	pack $form.rreason.label -side left 
	pack $form.rreason.entry -side left -fill x -expand 1 
	pack $form.rreason -padx 16 -fill x

	frame $form.enabled
	frame $form.enabled.box
	label $form.enabled.box.label -text "FIM State:" -width 16 -anchor e
	radiobutton $form.enabled.box.on -text "Enabled" \
		-width 10 -var device_adm__rec(enable) -value true \
		-command [list $form.enabled.reason.entry \
			configure -state disabled]
	radiobutton $form.enabled.box.off -text "Disabled" \
		-width 10 -var device_adm__rec(enable) -value false \
		-command [list $form.enabled.reason.entry config -state normal]
	pack $form.enabled.box.label $form.enabled.box.on \
		$form.enabled.box.off -side left
	pack $form.enabled.box -padx 16 -fill x

	frame $form.enabled.reason
	label $form.enabled.reason.label -text "Disabled Reason:" \
		-width 16 -anchor e
	entry $form.enabled.reason.entry -relief sunken \
		-textvariable device_adm__rec(disable)
	pack $form.enabled.reason.label -side left 
	pack $form.enabled.reason.entry -side left -fill x -expand 1
	pack $form.enabled.reason -padx 16 -fill x
	pack $form.enabled -pady 12 -fill x


	frame $form.send
	label $form.send.label -text "Send Faxes:" -width 16 -anchor e
	radiobutton $form.send.on -text "Yes" \
		-width 5 -var device_adm__rec(send) -value true \
		-command [list $form.nsreason.entry configure -state disabled]
	radiobutton $form.send.off -text "No" \
		-width 5 -var device_adm__rec(send) -value false \
		-command [list $form.nsreason.entry configure -state normal]
	pack $form.send.label $form.send.on $form.send.off -side left
	pack $form.send -padx 16 -fill x

	frame $form.nsreason
	label $form.nsreason.label -text "No Send Reason:" -width 16 -anchor e
	entry $form.nsreason.entry -relief sunken \
		-textvariable device_adm__rec(nosend)
	pack $form.nsreason.label -side left 
	pack $form.nsreason.entry -side left -fill x -expand 1 
	pack $form.nsreason -padx 16 -fill x

	frame $form.receive
	frame $form.receive.box
	label $form.receive.box.label -text "Receive Faxes:" -width 16 -anchor e
	radiobutton $form.receive.box.on -text "Yes" \
		-width 5 -var device_adm__rec(recv) -value true \
		-command [list $form.receive.reason.entry \
			configure -state disabled]
	radiobutton $form.receive.box.off -text "No" \
		-width 5 -var device_adm__rec(recv) -value false \
		-command [list $form.receive.reason.entry config -state normal]
	pack $form.receive.box.label $form.receive.box.on \
		$form.receive.box.off -side left
	pack $form.receive.box -padx 16 -fill x

	frame $form.receive.reason
	label $form.receive.reason.label -text "No Recv Reason:" \
		-width 16 -anchor e
	entry $form.receive.reason.entry -relief sunken \
		-textvariable device_adm__rec(norecv)
	pack $form.receive.reason.label -side left 
	pack $form.receive.reason.entry -side left -fill x -expand 1
	pack $form.receive.reason -padx 16 -fill x
	pack $form.receive -pady 12 -fill x

	#
	# Build the speaker mode combobox
	#
	frame $form.speaker
	ComboBox $form.speaker.speaker_mode -ewidth 5 -lbltext "Speaker Mode:" \
		-state normal -lblwidth 16 -listwidth 5 -strict 1 \
		-listheight 3 -textvariable device_adm__rec(speaker)
	$form.speaker.speaker_mode add "on"
	$form.speaker.speaker_mode add "off"
	$form.speaker.speaker_mode add "call"
	pack $form.speaker.speaker_mode -side left
	pack $form.speaker -padx 16 -fill x

	frame $form.spacer4 -height 8
	pack $form.spacer4


	#
	# Create the Advanced Options button
	#
	button $form.advanced -text "Advanced Options..." \
		-command device_adm__AdvancedOptions
	pack $form.advanced

	frame $form.spacer5 -height 12
	pack $form.spacer5


	#
	# Separate the form from the dialog buttons
	#
	frame $form.separator -relief groove -borderwidth 1 -height 2
	pack $form.separator -padx 2 -fill x 

	frame $form.buttons
	button $form.buttons.done -width 6 -text "OK" \
		-command device_adm__OK
	button $form.buttons.cancel -width 6 -text "Cancel" \
		-command device_adm__Cancel
	button $form.buttons.reset -width 6 -text "Reset" \
		-command device_adm__Reset
	pack $form.buttons.done $form.buttons.cancel $form.buttons.reset \
		-side left -expand 1
	pack $form.buttons -expand 1 -fill x -padx 16 -ipadx 4 -pady 12
}


# +++PHDR+++
#
# Procedure:	device_adm__FillForm
#
# Description:	Fills in the "Device Editor" form
#
#
# Argument		Description
# --------------------	----------------------------------------------------
#
#
# Returns:
#
#
# Notes:
#
# ---PHDR---

proc device_adm__FillForm { name } {
	global device_adm__rec device_adm__name
	global tcl_platform

	set device_adm__name $name
	device_adm__Reset


	#
	# Fill the inbox list
	#
	vcl user @device_adm_user
	set users [@device_adm_user list -count count]
	vcl destroy @device_adm_user

	if { $count < 2 } {
		set list_count 2
	} elseif { $count > 10 } {
		set list_count 10
	} else {
		set list_count $count
	}

	.device_shell.inbox_rnp.inbox del 0 end
	.device_shell.inbox_rnp.inbox configure -listheight $list_count
	foreach user $users {
		.device_shell.inbox_rnp.inbox add $user
	}

	#
	# Fill in the RNP list
	#
	set files [vcl resource rnp -count count]
	if { $count < 1 } {
		set list_count 1
	} elseif { $count > 10 } {
		set list_count 10
	} else {
		set list_count $count
	}

	.device_shell.inbox_rnp.rnp del 0 end
	.device_shell.inbox_rnp.rnp configure -listheight $list_count
	foreach file $files {
		set rnp [file rootname [file tail $file]]
		.device_shell.inbox_rnp.rnp add $rnp
	}


	#
	# Set the state of the entries
	#
	array set rec [array get device_adm__rec]
	if { $rec(enable) == "true" } {
		.device_shell.enabled.reason.entry configure -state disabled
	} else {
		.device_shell.enabled.reason.entry configure -state normal
	}
	
	if { $rec(accept) == "true" } {
		.device_shell.rreason.entry configure -state disabled
	} else {
		.device_shell.rreason.entry configure -state normal
	}

	if { $rec(send) == "true" } {
		.device_shell.nsreason.entry configure -state disabled
	} else {
		.device_shell.nsreason.entry configure -state normal
	}

	if { $rec(recv) == "true" } {
		.device_shell.receive.reason.entry configure -state disabled
	} else {
		.device_shell.receive.reason.entry configure -state normal
	}
}


# +++PHDR+++
#
# Procedure:	device_adm__OK
#
# Description:	OK button command.
#
#
# Argument		Description
# --------------------	----------------------------------------------------
#
#
# Returns:
#
#
# Notes:
#
# ---PHDR---

proc device_adm__OK {} {
	global device_adm__rec device_adm__name device_adm__done

	if { ${device_adm__name} != "" } {
		@modem_adm update ${device_adm__name} -array device_adm__rec
	} else {
		set name [.device_shell.name.entry get]
		if { $name != "" } {
			@modem_adm add $name -array device_adm__rec
		}
	}

	set device_adm__done 1
}

# +++PHDR+++
#
# Procedure:	device_adm__Cancel
#
# Description:	Cancel button command.
#
#
# Argument		Description
# --------------------	----------------------------------------------------
#
#
# Returns:
#
#
# Notes:
#
# ---PHDR---

proc device_adm__Cancel {} {
	global device_adm__rec device_adm__name device_adm__done

	if { ${device_adm__name} != "" } {
		@modem_adm list ${device_adm__name} -array device_adm__rec
	}

	set device_adm__done 0
}


# +++PHDR+++
#
# Procedure:	device_adm__Reset
#
# Description:	Reset button command.
#
#
# Argument		Description
# --------------------	----------------------------------------------------
#
#
# Returns:	nothing
#
#
# Notes:
#
# ---PHDR---

proc device_adm__Reset {} {
	global device_adm__rec device_adm__name tcl_platform
	
	if { ${device_adm__name} != "" } {
		@modem_adm list ${device_adm__name} -array device_adm__rec
	} else {
		unset device_adm__rec
		set device_adm__rec(name)    ""
		set device_adm__rec(comment) ""
		set device_adm__rec(fim)     "c2"
		if { $tcl_platform(os) == "Windows NT" } {
			set device_adm__rec(device)  "NUL"
		} else {
			set device_adm__rec(device)  "/dev/null"
		}
		set device_adm__rec(modem)   ""
		set device_adm__rec(rnp)     ""
		set device_adm__rec(inbox)   "vsifax"
		set device_adm__rec(speaker) "call"
		set device_adm__rec(speed)   "19200"
		set device_adm__rec(accept)  "true"
		set device_adm__rec(reject)  ""
		set device_adm__rec(enable)  "true"
		set device_adm__rec(disable)  ""
		set device_adm__rec(send)    "true"
		set device_adm__rec(nosend)  ""
		set device_adm__rec(recv)    "true"
		set device_adm__rec(norecv)  ""
	}
}


# +++PHDR+++
#
# Procedure:	device_adm__AdvancedOptions
#
# Description:
#
#
# Argument		Description
# --------------------	----------------------------------------------------
#
#
# Returns:
#
#
# Notes:
#
# ---PHDR---

proc device_adm__AdvancedOptions {} {
	global device_adm__name device_adm__shell

	vclutils__LoadSource device_params__Popup devparam.tcl
	catch { 
		set return_code [device_params__Popup ${device_adm__shell} \
			.device_params ${device_adm__name}] 
	}
}


# +++PHDR+++
#
# Procedure:	device_adm__Edit
#
# Description:	Edit procedure for the "Device Editor" form.
#
#
# Argument		Description
# --------------------	----------------------------------------------------
#
#
# Returns:
#
#
# Notes:
#
# ---PHDR---

proc device_adm__Edit { parent name } {
	global device_adm__done device_adm__shell

	#
	# Build and fill the "Device Editor" form
	#
	device_adm__BuildForm
	device_adm__FillForm $name
	vclutils__CenterDialog ${device_adm__shell} $parent
	vclutils__LockSize ${device_adm__shell}

	#
	# Always update afetr poping up and before setting focus
	#
	grab .device_shell
	update

	#
	# Focus is based on wether this a new device
	#
	if { $name != "" } {
		.device_shell.advanced configure -state normal
		.device_shell.name.entry configure -state disabled
		focus .device_shell.comment.entry
	} else {
		.device_shell.advanced configure -state disabled
		.device_shell.name.entry configure -state normal
		focus .device_shell.name.entry
	}

	#
	# Make the dialog modal
	#
	tkwait variable device_adm__done
	grab release .device_shell
	destroy .device_shell

	return ${device_adm__done}
}
