# +++PHDR+++
#
# Procedure:	class_adm__BuildForm
#
# Description:	Builds the "Class Editor" form
#
#
# Argument		Description
# --------------------	----------------------------------------------------
#
#
# Returns:
#
#
# Notes:
#
# ---PHDR---

proc class_adm__BuildForm { } {
	global class_adm__rec class_adm__shell
	global vsimenu__hostname

	set form ".class_shell"
	set class_adm__shell $form
       	catch { destroy $form}
	toplevel $form

	#
	# Put the title on the shell
	#
	set vtitle "$vsimenu__hostname - Class Editor"
	wm title $form $vtitle


	#
	# Setup a handler for the window manager "Close" function
	#
	wm protocol $form WM_DELETE_WINDOW class_adm__Cancel

	frame $form.topspace -height 16
	pack $form.topspace

	frame $form.name
	label $form.name.label -text "Name:" -width 14 -anchor e
	entry $form.name.entry -relief sunken -state disabled \
		-width 12 -textvariable class_adm__rec(name)
	pack $form.name.label $form.name.entry -side left
	pack $form.name -padx 16 -fill x

	frame $form.comment
	label $form.comment.label -text "Comment:" -width 14 -anchor e
	entry $form.comment.entry -relief sunken \
		-textvariable class_adm__rec(comment)
	pack $form.comment.label -side left
	pack $form.comment.entry -side left -fill x -expand 1
	pack $form.comment -padx 16 -fill x


	frame $form.accept
	frame $form.accept.box
	label $form.accept.box.label -text "Jobs:" -width 14 -anchor e
	radiobutton $form.accept.box.on -text "Accept" \
		-width 8 -var class_adm__rec(accept) -value true \
		-command [list $form.accept.reason.entry \
			configure -state disabled]
	radiobutton $form.accept.box.off -text "Reject" \
		-width 8 -var class_adm__rec(accept) -value false \
		-command [list $form.accept.reason.entry config -state normal]
	pack $form.accept.box.label $form.accept.box.on \
		$form.accept.box.off -side left
	pack $form.accept.box -padx 16 -fill x

	frame $form.accept.reason
	label $form.accept.reason.label -text "Reject Reason:" \
		-width 14 -anchor e
	entry $form.accept.reason.entry -relief sunken \
		-textvariable class_adm__rec(reject)
	pack $form.accept.reason.label -side left 
	pack $form.accept.reason.entry -side left -fill x -expand 1
	pack $form.accept.reason -padx 16 -fill x
	pack $form.accept -pady 12 -fill x


	#
	# Build the member lists
	#
	frame $form.lists
	frame $form.lists.members
	label $form.lists.members.label -text "Members"
	listbox $form.lists.members.list -exportselection false \
		-relief sunken -selectmode browse -width 12 -height 6 \
		-yscrollcommand [ list $form.lists.members.scroll set ]
	scrollbar $form.lists.members.scroll \
		-command [list $form.lists.members.list yview]
	pack $form.lists.members.label -anchor w
	pack $form.lists.members.list -side left
	pack $form.lists.members.scroll -side left -fill y
	pack $form.lists.members -side left

	frame $form.lists.buttons
	button $form.lists.buttons.add -width 2 -text "<" -pady 0 \
		-command [list vclutils__SwapItem \
		$form.lists.available.list $form.lists.members.list]
	button $form.lists.buttons.delete -width 2 -text ">" -pady 0 \
		-command [list vclutils__SwapItem \
		$form.lists.members.list $form.lists.available.list]
	button $form.lists.buttons.addall -width 2 -text "<<" -pady 0 \
		-command [list vclutils__SwapAllItems \
		$form.lists.available.list $form.lists.members.list]
	button $form.lists.buttons.deleteall -width 2 -text ">>" -pady 0 \
		-command [list vclutils__SwapAllItems \
		$form.lists.members.list $form.lists.available.list]
	pack $form.lists.buttons.deleteall $form.lists.buttons.addall \
		$form.lists.buttons.delete $form.lists.buttons.add \
		-side bottom
	pack $form.lists.buttons -side left -padx 10 -fill y -pady 6

	frame $form.lists.available
	label $form.lists.available.label -text "Available" -anchor w
	listbox $form.lists.available.list -exportselection false \
		-relief sunken -selectmode browse -width 12 -height 6 \
		-yscrollcommand [ list $form.lists.available.scroll set ]
	scrollbar $form.lists.available.scroll \
		-command [list $form.lists.available.list yview]
	pack $form.lists.available.label -anchor w
	pack $form.lists.available.list -side left
	pack $form.lists.available.scroll -side left -fill y
	pack $form.lists.available -side left

	pack $form.lists -padx 16

	#
	# Setup a selecting mechanism to move the items between lists
	#
	bind $form.lists.members.list <Double-Button-1> \
		[list vclutils__SwapItem $form.lists.members.list \
		$form.lists.available.list]
	bind $form.lists.available.list <Double-Button-1> \
		[list vclutils__SwapItem $form.lists.available.list \
		$form.lists.members.list]

	#
	# Separate the form from the dialog buttons
	#
	frame $form.spacer
	pack $form.spacer -pady 6
	frame $form.separator -relief groove -borderwidth 1 -height 2
	pack $form.separator -padx 2 -fill x 


	frame $form.buttons
	button $form.buttons.done -width 6 -text "OK" \
		-command class_adm__OK
	button $form.buttons.cancel -width 6 -text "Cancel" \
		-command class_adm__Cancel
	button $form.buttons.reset -width 6 -text "Reset" \
		-command class_adm__Reset
	pack $form.buttons.done $form.buttons.cancel $form.buttons.reset \
		-side left -expand 1
	pack $form.buttons -expand 1 -fill x -padx 16 -ipadx 4 -pady 12
}


# +++PHDR+++
#
# Procedure:	class_adm__FillForm
#
# Description:	Fills in the "Class Editor" form
#
#
# Argument		Description
# --------------------	----------------------------------------------------
#
#
# Returns:
#
#
# Notes:
#
# ---PHDR---

proc class_adm__FillForm { name } {
	global class_adm__rec class_adm__name

	set class_adm__name $name
	class_adm__Reset

	#
	# Set the state of the reject reason
	#
	array set rec [array get class_adm__rec]
	if { $rec(accept) == "true" } {
		.class_shell.accept.reason.entry configure -state disabled
	} else {
		.class_shell.accept.reason.entry configure -state normal
	}
}


# +++PHDR+++
#
# Procedure:	class_adm__FillMemberLists
#
# Description:
#
#
# Argument		Description
# --------------------	----------------------------------------------------
#
#
# Returns:
#
#
# Notes:
#
# ---PHDR---

proc class_adm__FillMemberLists {} {
	global class_adm__rec

	#
	# Clear the lists
	#
	.class_shell.lists.members.list delete 0 end
	.class_shell.lists.available.list delete 0 end

	#
	# Add each member into the members list
	#
	array set rec [array get class_adm__rec]
	foreach member $rec(members) {
		.class_shell.lists.members.list insert end $member
	}

	#
	# Add the available devices into the available list
	#
	set devices [@modem_adm list -senddevices]
	foreach device $devices {
		
		#
		# Add the device only if it is not a member
		#
		set index [lsearch -exact $rec(members) $device]
		if { $index < 0 } {
			.class_shell.lists.available.list insert end $device
		}
	}
}


# +++PHDR+++
#
# Procedure:	class_adm__OK
#
# Description:	OK button command.
#
#
# Argument		Description
# --------------------	----------------------------------------------------
#
#
# Returns:
#
#
# Notes:
#
# ---PHDR---

proc class_adm__OK {} {
	global class_adm__rec class_adm__name class_adm__done

	#
	# Set the rec(members) list
	#
	set class_adm__rec(members) [.class_shell.lists.members.list get 0 end]

	if { ${class_adm__name} != "" } {
		@modem_adm update ${class_adm__name} -array class_adm__rec
	} else {
		set name [.class_shell.name.entry get]
		if { $name != "" } {
			@modem_adm add $name -class -array class_adm__rec
		}
	}

	set class_adm__done 1
}

# +++PHDR+++
#
# Procedure:	class_adm__Cancel
#
# Description:	Cancel button command.
#
#
# Argument		Description
# --------------------	----------------------------------------------------
#
#
# Returns:
#
#
# Notes:
#
# ---PHDR---

proc class_adm__Cancel {} {
	global class_adm__rec class_adm__name class_adm__done

	if { ${class_adm__name} != "" } {
		@modem_adm list ${class_adm__name} -array class_adm__rec
	}

	set class_adm__done 0
}


# +++PHDR+++
#
# Procedure:	class_adm__Reset
#
# Description:	Reset button command.
#
#
# Argument		Description
# --------------------	----------------------------------------------------
#
#
# Returns:	nothing
#
#
# Notes:
#
# ---PHDR---

proc class_adm__Reset {} {
	global class_adm__rec class_adm__name
	
	if { ${class_adm__name} != "" } {
		@modem_adm list ${class_adm__name} -array class_adm__rec
	} else {
		unset class_adm__rec
		set class_adm__rec(name)    ""
		set class_adm__rec(comment) ""
		set class_adm__rec(accept)  "true"
		set class_adm__rec(reject)  ""
		set class_adm__rec(members) ""
	}

	class_adm__FillMemberLists
}


# +++PHDR+++
#
# Procedure:	class_adm__Edit
#
# Description:	Edit procedure for the "Class Editor" form.
#
#
# Argument		Description
# --------------------	----------------------------------------------------
#
#
# Returns:
#
#
# Notes:
#
# ---PHDR---

proc class_adm__Edit { parent name } {
	global class_adm__done class_adm__shell

	#
	# Build and fill the "Class Editor" form
	#
	class_adm__BuildForm
	class_adm__FillForm $name
	vclutils__CenterDialog ${class_adm__shell} $parent
	vclutils__LockSize ${class_adm__shell}

	#
	# Always update afetr poping up and before setting focus
	#
	grab .class_shell
	update

	#
	# Focus is based on wether this a new class
	#
	if { $name != "" } {
		.class_shell.name.entry configure -state disabled
		focus .class_shell.comment.entry
	} else {
		.class_shell.name.entry configure -state normal
		focus .class_shell.name.entry
	}

	#
	# Make the dialog modal
	#
	tkwait variable class_adm__done
	grab release .class_shell
	destroy .class_shell

	return ${class_adm__done}
}
