#!/bin/sh
# ------------------------------------------------------------------------
#
#	Description:
#
#	script to convert inbound faxes to "standard" tiff format and route
#	them to the appropriate inbox
#
#	usage:	<rnp> path dest inbox
#
# ------------------------------------------------------------------------

# ------------------------------------------------------------------------
# Get arguments
#
FILE="$1"
DEST="$2"
INBOX="$3"

TSI="VSI-FAX"
SPAM_USER="vsispam"
SPAM_TSI="spam"

[ "$INBOX" = "" ] && INBOX=vsifax

DIR=`dirname "$FILE"`
cd "$DIR"

# ------------------------------------------------------------------------
# Adjust INBOX & TSI if needed
#
info=`"$VSIFAX/bin/vtifftool" info -F eval "$FILE"`
if [ $? -eq 0 ]
then
	eval $info

	# ----------------------------------------------------------------
	# check if DID extension is present in fax file
	# and, if so, change INBOX to user owning that DID ext
	#
	if [ "$did" != "" ]
	then
		name=`"$VSIFAX/bin/vfxadmin" user -E "$did"`
		[ "$name" = "" ] && name="$did"

		"$VSIFAX/bin/vfxadmin" user -Tq "$name" && INBOX="$name"
	fi

	# ----------------------------------------------------------------
	# If the TSI is empty, it is probably a spam fax.
	# If a spam user is present, route to him.
	#
	if [ "$tsi" = "" ]
	then
		"$VSIFAX/bin/vfxadmin" user -Tq "$SPAM_USER" &&
			INBOX="$SPAM_USER"
		TSI="$SPAM_TSI"
	else
		TSI="$tsi"
	fi
fi

# ------------------------------------------------------------------------
# Add the thumbnails to the file (ignore any error from it)
#
"$VSIFAX/bin/vtifftool" thumb -o "$FILE" "$FILE"

# ------------------------------------------------------------------------
# Run the receive program
#
"$VSIFAX/lbin/vrecv" "$FILE" "$INBOX"

# ------------------------------------------------------------------------
# Run the site RNP if it exists
#
"$VSIFAX/lbin/vnotify" -n -r site "$FILE" "$DEST" "$INBOX" "received"

# ------------------------------------------------------------------------
# If the file still exists,
# check if a specific RNP exists for this destination
# and if so, run it
#
if [ -f "$FILE" ]
then
	RNP=`"$VSIFAX/bin/vfxadmin" device -l -f rnp -F pipe "$DEST"`
	[ "$RNP" = "system" -o "$RNP" = "site" ] && RNP=""

	if [ "$RNP" != "" ]
	then
		"$VSIFAX/lbin/vnotify" -r "$RNP" "$FILE" "$DEST" "$INBOX" \
			"received"
	fi
fi

# ------------------------------------------------------------------------
# Route the file to the appropriate inbox if it still exists
#
"$VSIFAX/lbin/vroute" -r "$FILE" "$TSI" "$INBOX"

exit 0
