#!/bin/sh
# ------------------------------------------------------------------------
#
#	Description:
#
#	This is the default system LNP for all jobs
#
#	usage: <lnp> reqid clientid mailaddr time notify grpid
#				numpgs faxnum lcr
#
# ------------------------------------------------------------------------

# ------------------------------------------------------------------------
# LCR check for regular fax job
#
lcr_check_reg ()
{
	# ----------------------------------------------------------------
	# check if this job should be routed
	#
	if [ "$LCR" = "TRUE" -o "$ALB" = "TRUE" ]
	then
		[ "$LCR" = "TRUE" ] && l_opt=-l
		[ "$ALB" = "TRUE" ] && a_opt=-a

		route=`"$VSIFAX/lbin/vlcrchk" $l_opt $a_opt $REQID`

		if [ "$route" != "" ]
		then
			# ------------------------------------------------
			# route this job
			#
			"$VSIFAX/lbin/vlcrfwd" $route $REQID
			return
		fi
	fi

	# ----------------------------------------------------------------
	# check if this job should be moved to another dest
	#
	dest=`"$VSIFAX/lbin/vdevchk" $REQID`
	if [ "$dest" != "" ]
	then
		# --------------------------------------------------------
		# move this job
		#
		"$VSIFAX/lbin/vlcrfwd" -d "$dest" $REQID
		return
	fi
}

# ------------------------------------------------------------------------
# LCR check for group fax job
#
lcr_check_grp ()
{
	# ----------------------------------------------------------------
	# get coverpage for this group
	#
	faxreq=`"$VSIFAX/lbin/vfaxreq" -F eval g-$GRPID`
	eval $faxreq

	# ----------------------------------------------------------------
	# loop through all members of this group
	#
	mem=0

	while [ $mem -lt $NUM ]
	do
		# --------------------------------------------------------
		# bump the member number
		#
		mem=`expr $mem + 1`

		# --------------------------------------------------------
		# check if this member should be routed
		#
		if [ "$LCR" = "TRUE" -o "$ALB" = "TRUE" ]
		then
			[ "$LCR" = "TRUE" ] && l_opt=-l
			[ "$ALB" = "TRUE" ] && a_opt=-a

			route=`"$VSIFAX/lbin/vlcrchk" $l_opt $a_opt g-$GRPID-$mem`

			if [ "$route" != "" ]
			then
				# ----------------------------------------
				# image the cover for this member if needed
				#
				[ "$cvr" != "" ] &&
					"$VSIFAX/lbin/vcover" "$cvr" g-$GRPID-$mem

				# ----------------------------------------
				# now route it
				#
				"$VSIFAX/lbin/vlcrfwd" $route g-$GRPID-$mem
				continue
			fi
		fi

		# --------------------------------------------------------
		# check if this member should be moved to another dest
		#
		dest=`"$VSIFAX/lbin/vdevchk" g-$GRPID-$mem`
		if [ "$dest" != "" ]
		then
			# ------------------------------------------------
			# move this member
			#
			"$VSIFAX/lbin/vlcrfwd" -d "$dest" g-$GRPID-$mem
			continue
		fi
	done
}

# ------------------------------------------------------------------------
# get all arguments & export them
#
set -a
REQID="$1"
CLIENTID="$2"
MAILADDR="$3"
SENDTIME="$4"
NOTIFY="$5"
GRPID="$6"
NUM="$7"		# for a group, this is num members
FAXNUM="$8"
LCR="$9"
shift
ALB="$9"
shift
USER_LNP="$9"
set +a

# ------------------------------------------------------------------------
# if a reg job, check if it was routed & send a confirmation if it was
#
[ $GRPID -eq 0 ] && "$VSIFAX/lbin/vlcrstat" $REQID

# ------------------------------------------------------------------------
# run the site LNP if it exists
#
"$VSIFAX/lbin/vnotify" -n -l site \
	"$REQID" "$CLIENTID" "$MAILADDR" "$SENDTIME" "$NOTIFY" \
	"$GRPID" "$NUM" "$FAXNUM" "$LCR"
status=$?
[ $status -ne 0 ] && exit $status

# ------------------------------------------------------------------------
# run the <user> LNP if it exists
#
if [ "$USER_LNP" != "" ]
then
	"$VSIFAX/lbin/vnotify" -l "$USER_LNP" \
		"$REQID" "$CLIENTID" "$MAILADDR" "$SENDTIME" "$NOTIFY" \
		"$GRPID" "$NUM" "$FAXNUM" "$LCR"
	status=$?
	[ $status -ne 0 ] && exit $status
fi

# ------------------------------------------------------------------------
# check if this fax should be routed (LCR)
#
if [ "$GRPID" -eq "0" ]
then
	lcr_check_reg
else
	lcr_check_grp
fi

exit 0
