#
#	Description: This is the init script for FaxTCL. It is automatically
#		     called when faxtcl or wfaxtcl starts. It simply prepends
#		     the directory where it was found to TCLs list of auto
#		     load directories.
#

proc init {} {
	global env auto_path
	set dirs {}
	lappend dirs "."
	if [info exists env(VSIFAX)] {
		lappend dirs $env(VSIFAX)/lib/faxtcl/library
	}

	foreach i $dirs {
		if { [file isfile $i/init.tcl] } {
	    		set auto_path [linsert $auto_path 0 $i]
	    		break
		}
	}
}


#
# Call the init proc and then remove the init proc
#
init
rename init {}

