# +++PHDR+++
#
# Procedure:	system_params__BuildMainForm
#
# Description:	Draws the main form for the company info editor
#
#
# Argument		Description
# --------------------	----------------------------------------------------
# form_shell		Pathname of toplevel shell for interface.
#
#
# Returns:	nothing
#
#
# Notes:
#
# ---PHDR---

proc system_params__BuildMainForm { form_shell } {
	global system_params__shell system_params__ini
	global vsimenu__hostname
	global vsimenu__isadmin

	#
	# Get the state for the input controls
	#
	if { $vsimenu__isadmin } {
		set state "normal"
	} else {
		set state "disabled"
	}


	#
	# Create the top level shell if the form_shell is not "."
	#
	if { $form_shell == "." } {
		set form ".frame"
		set system_params__shell ".frame"
		catch { destroy $form }
		frame $form
	} else {
        	catch { destroy $form_shell }
		toplevel $form_shell
		set form $form_shell
		set system_params__shell $form_shell
	}

	#
	# Put the title on the shell
	#
	set vtitle "$vsimenu__hostname - System Parameters"
	wm title $form_shell $vtitle

	#
	# Setup a handler for the window manager "Close" function
	#
	wm protocol $form_shell WM_DELETE_WINDOW system_params__Cancel

	#
	# Create the Debug Logging checkbutton
	#
	checkbutton $form.debug -text "Debug Logging" \
		-justify left -var system_params__ini(VFXSCHED,Debug) \
		-onvalue "on" -offvalue "off" -state $state
	pack $form.debug -padx 16 -pady 16 -anchor w


	#
	# Build the Login and Command port fields
	#
	frame $form.login_port
	label $form.login_port.label -text "Login Port:" -anchor e -width 20
	entry $form.login_port.entry -relief sunken -state $state \
		-width 5 -textvariable system_params__ini(VSINET,Loginport)
	pack $form.login_port.label $form.login_port.entry -side left
	pack $form.login_port -padx 16 -anchor w
	
	frame $form.cmd_port
	label $form.cmd_port.label -text "Command Port:" -anchor e -width 20
	entry $form.cmd_port.entry -relief sunken -state $state \
		-width 5 -textvariable system_params__ini(VSINET,Cmdport)
	pack $form.cmd_port.label $form.cmd_port.entry -side left
	pack $form.cmd_port -padx 16 -anchor w



	#
	# Create the Maximum Group Members Queued field
	#
	frame $form.maxqueued
	label $form.maxqueued.label -text "Maximum Group\nMembers Queued:" \
		-anchor e -justify l -width 20
	entry $form.maxqueued.entry \
		-relief sunken -state $state -width 5 \
		-textvariable system_params__ini(VGSCHED,Maxmembersqueued)
	pack $form.maxqueued.label $form.maxqueued.entry -side left
	pack $form.maxqueued -padx 16 -anchor w
	
	
	#
	# Create the mail host entry
	#
	frame $form.mailhost
	label $form.mailhost.label -text "SMTP server name:" \
		-anchor e -justify l -width 20
	entry $form.mailhost.entry \
		-relief sunken -state $state -width 16 \
		-textvariable system_params__ini(VMAIL,Server)
	pack $form.mailhost.label $form.mailhost.entry -side left
	pack $form.mailhost -padx 16 -anchor w
	
	#
	# Create the mail sender entry
	#
	frame $form.mailsender
	label $form.mailsender.label -text "SMTP from name:" \
		-anchor e -justify l -width 20
	entry $form.mailsender.entry \
		-relief sunken -state $state -width 16 \
		-textvariable system_params__ini(VMAIL,Sender)
	pack $form.mailsender.label $form.mailsender.entry -side left
	pack $form.mailsender -pady 8 -padx 16 -anchor w
	

	
	#
	# Create the pop host entry
	#
	frame $form.pophost
	label $form.pophost.label -text "POP hostname:" \
		-anchor e -justify l -width 20
	entry $form.pophost.entry \
		-relief sunken -state $state -width 16 \
		-textvariable system_params__ini(VPOPD,Hostname)
	pack $form.pophost.label $form.pophost.entry -side left
	pack $form.pophost -padx 16 -anchor w
	
	#
	# Create the pop username entry
	#
	frame $form.popuser
	label $form.popuser.label -text "POP username:" \
		-anchor e -justify l -width 20
	entry $form.popuser.entry \
		-relief sunken -state $state -width 16 \
		-textvariable system_params__ini(VPOPD,Username)
	pack $form.popuser.label $form.popuser.entry -side left
	pack $form.popuser -pady 8 -padx 16 -anchor w
	
	
	#
	# Create the pop password entry
	#
	frame $form.poppasswd
	label $form.poppasswd.label -text "POP password:" \
		-anchor e -justify l -width 20
	entry $form.poppasswd.entry \
		-relief sunken -state $state -width 16 \
		-textvariable system_params__ini(VPOPD,Password) -show "*"
	pack $form.poppasswd.label $form.poppasswd.entry -side left
	pack $form.poppasswd -padx 16 -anchor w
	
	
	
	#
	# Create the Device Parameters button
	#
	button $form.dev_params -text "Set Default Device Parameters..." \
		-command system_params__DeviceParameters
	pack $form.dev_params -pady 8 -padx 32 -anchor w


	#
	# Separate the form from the dialog buttons
	#
	frame $form.dlg_separator -relief groove -borderwidth 1 -height 2
	pack $form.dlg_separator -pady 16 -padx 2 -fill x 
	

	frame $form.buttons
	button $form.buttons.ok -width 6 -text "OK" \
		-command { system_params__OK }
	button $form.buttons.cancel -width 6 -text "Cancel" -state $state \
		-command { system_params__Cancel }
	button $form.buttons.reset -width 6 -text "Reset" -state $state \
		-command { system_params__Reset }
	pack $form.buttons.ok $form.buttons.cancel $form.buttons.reset \
		-side left -expand 1
	pack $form.buttons -expand 1 -fill x -padx 16 -ipadx 4

	frame $form.spacer -height 16
	pack $form.spacer


	catch { pack $form }
	return
}


# +++PHDR+++
#
# Procedure:	system_params__OK
#
# Description:	Callback for the "OK" button. Coomits the addition or 
#               changes to the form.
#
#
# Argument		Description
# --------------------	----------------------------------------------------
# n/a
#
# Returns:	nothing
#
#
# Notes:	
#
# ---PHDR---

proc system_params__OK {} {
	global system_params__done

	set system_params__done 1
	return
}



# +++PHDR+++
#
# Procedure:	 system_params__Cancel
#
# Description:	"Cancel" command proc. Sets the done flag so tkwait returns.
#
#
# Argument		Description
# --------------------	----------------------------------------------------
# n/a
#
#
# Returns:	nothing
#
#
# Notes:
#
# ---PHDR---

proc system_params__Cancel {} {
	global system_params__done

	set system_params__done 0
}


# +++PHDR+++
#
# Procedure:	system_params__Reset
#
# Description:	"Reset" command proc. Resets the edit form to original values.
#
#
# Argument		Description
# --------------------	----------------------------------------------------
# n/a
#
#
# Returns:	nothing
#
#
# Notes:
#
# ---PHDR---

proc system_params__Reset {} {
	global system_params__ini

	catch { @sysparam_ini get -array _params__ini }
}


# +++PHDR+++
#
# Procedure: 	system_params__DeviceParameters
#
# Description:
#
#
# Argument		Description
# --------------------	----------------------------------------------------
#
#
# Returns:
#
#
# Notes:
#
# ---PHDR---

proc system_params__DeviceParameters {} {
	global system_params__shell device_adm__name device_adm__shell
	global vsimenu__isadmin

	#
	# Close the ini file
	#
	catch { vcl destroy @sysparam_ini }

	#
	# Popup the Device parameters interface
	#
	vclutils__LoadSource device_params__Popup devparam.tcl
	catch {device_params__Popup ${system_params__shell} .device_params ""}

	#
	# Reopen the ini file
	#
	if { $vsimenu__isadmin } {
		vcl ini @sysparam_ini -server
	} else {
		vcl ini @sysparam_ini -server -mode r
	}
}


# +++PHDR+++
#
# Procedure:	system_params__Popup
#
# Description:
#
#
# Argument		Description
# --------------------	----------------------------------------------------
#
#
# Returns:
#
#
# Notes:
#
# ---PHDR---

proc system_params__Popup { parent system_params_shell } {
	global system_params__shell system_params__done system_params__ini
	global vsimenu__isadmin

	#
	# Get the device parameters ini object
	#
	catch { vcl destroy @sysparam_ini }

	if { $vsimenu__isadmin } {
		vcl ini @sysparam_ini -server
	} else {
		vcl ini @sysparam_ini -server -mode r
	}

	catch { @sysparam_ini get -array ini_data }

	#
	# Set only the vars we use
	#
	catch { unset system_params__ini }

	if { [info exists ini_data(VFXSCHED,Debug)] } {
		set system_params__ini(VFXSCHED,Debug) \
			$ini_data(VFXSCHED,Debug)
	} else {
	}

	if { [info exists ini_data(VSINET,Loginport)] } {
		set system_params__ini(VSINET,Loginport) \
			$ini_data(VSINET,Loginport)
	} else {
	}

	if { [info exists ini_data(VSINET,Cmdport)] } {
		set system_params__ini(VSINET,Cmdport) \
			$ini_data(VSINET,Cmdport)
	} else {
	}

	if { [info exists ini_data(VGSCHED,Maxmembersqueued)] } {
		set system_params__ini(VGSCHED,Maxmembersqueued) \
			$ini_data(VGSCHED,Maxmembersqueued)
	} else {
	}

	if { [info exists ini_data(VMAIL,Server)] } {
		set system_params__ini(VMAIL,Server) \
			$ini_data(VMAIL,Server)
	} else {
	}

	if { [info exists ini_data(VMAIL,Sender)] } {
		set system_params__ini(VMAIL,Sender) \
			$ini_data(VMAIL,Sender)
	} else {
	}

	if { [info exists ini_data(VPOPD,Hostname)] } {
		set system_params__ini(VPOPD,Hostname) \
			$ini_data(VPOPD,Hostname)
	} else {
	}

	if { [info exists ini_data(VPOPD,Username)] } {
		set system_params__ini(VPOPD,Username) \
			$ini_data(VPOPD,Username)
	} else {
	}

	if { [info exists ini_data(VPOPD,Password)] } {
		set system_params__ini(VPOPD,Password) \
			[vcl decrypt $ini_data(VPOPD,Password) "" ]
	} else {
	}

	catch { unset ini_data }


	#
	# Build and display the form
	#
	system_params__BuildMainForm $system_params_shell
	vclutils__CenterDialog $system_params_shell $parent
	vclutils__LockSize $system_params_shell

	#
	# Make the dialog modal
	#
	update
	grab ${system_params__shell}

	#
	# Set the focus to debug logging
	#
	focus ${system_params__shell}.debug

	#
	# Wait for the dialog to be done
	#
	tkwait variable system_params__done
	grab release ${system_params__shell}

	#
	# Destroy everything we created
	#
	destroy ${system_params__shell}	


	#
	# Save the ini configuration?
	#
	if { ${system_params__done} } {

		if { [info exists system_params__ini(VPOPD,Password)] } {
			set system_params__ini(VPOPD,Password) \
				[vcl encrypt $system_params__ini(VPOPD,Password) ""]
		} else {
		}

		@sysparam_ini set -array system_params__ini 
		@sysparam_ini save
	}

	catch { vcl destroy @sysparam_ini }
}

