# +++PHDR+++
#
# Procedure:	license_adm__BuildMainForm
#
# Description:	Draws the main form for the license database editor
#
#
# Argument		Description
# --------------------	----------------------------------------------------
# shell                 Pathname for toplevel shell
#
#
# Returns:	nothing
#
#
# Notes:
#
# ---PHDR---

proc license_adm__BuildMainForm { shell } {
	global license_adm
	global vsimenu__hostname
	global vsimenu__isadmin

	#
	# Create the top level shell if the shell is not "."
	#
	if { $shell == "." } {
		set form ".frame"
		catch { destroy $form }
		frame $form
	} else {
        	catch { destroy $shell }
		toplevel $shell
		set form $shell
	}
	set license_adm(form)  $form
	set license_adm(shell) $shell

	if { $vsimenu__isadmin } {
		set state "normal"
		set double_click license_adm__Update
	} else {
		set state "disabled"
		set double_click ""
	}

	#
	# Put the title on the shell
	#
	set vtitle "$vsimenu__hostname - License management"
	wm title $shell $vtitle

	#
	# Setup a handler for the window manager "Close" function
	#
	wm protocol $shell WM_DELETE_WINDOW license_adm__Done
	
	#
	# Build scrolled lists that hold the product, description, type,
	# machine, expires, nusers, and nports
	#
	frame $form.lists -highlightthickness 2
	frame $form.lists.prod
	label $form.lists.prod.label -text "Product" 
	listbox $form.lists.prod.list -borderwidth 1 -exportselection false \
		-relief sunken -selectmode browse -width 9 \
		-yscrollcommand [ list $form.lists.actkey.scroll set ] \
		-highlightthickness 0
	pack $form.lists.prod.label 
	pack $form.lists.prod.list -side left
	pack $form.lists.prod -side left

	frame $form.lists.desc -takefocus 0
	label $form.lists.desc.label -text "Description"
	listbox $form.lists.desc.list -borderwidth 1 -exportselection false \
		-relief sunken -selectmode browse -width 22 -takefocus 0 \
		-yscrollcommand [ list $form.lists.actkey.scroll set ] \
		-highlightthickness 0
	pack $form.lists.desc.label 
	pack $form.lists.desc.list -side left
	pack $form.lists.desc -side left

	frame $form.lists.type -takefocus 0
	label $form.lists.type.label -text "Type"
	listbox $form.lists.type.list -borderwidth 1 -exportselection false \
		-relief sunken -selectmode browse -width 5 -takefocus 0 \
		-yscrollcommand [ list $form.lists.actkey.scroll set ] \
		-highlightthickness 0
	pack $form.lists.type.label 
	pack $form.lists.type.list -side left
	pack $form.lists.type -side left

	frame $form.lists.mach -takefocus 0
	label $form.lists.mach.label -text "Machine"
	listbox $form.lists.mach.list -borderwidth 1 -exportselection false \
		-relief sunken -selectmode browse -width 8 -takefocus 0 \
		-yscrollcommand [ list $form.lists.actkey.scroll set ] \
		-highlightthickness 0
	pack $form.lists.mach.label 
	pack $form.lists.mach.list -side left
	pack $form.lists.mach -side left

	frame $form.lists.expires
	label $form.lists.expires.label -text "Expires"
	listbox $form.lists.expires.list -borderwidth 1 \
		-exportselection false -relief sunken -selectmode browse \
		-width 8 -takefocus 0 -highlightthickness 0 \
		-yscrollcommand [ list $form.lists.actkey.scroll set ]
	pack $form.lists.expires.label 
	pack $form.lists.expires.list -side left
	pack $form.lists.expires -side left

	frame $form.lists.nusers -takefocus 0
	label $form.lists.nusers.label -text "Num Users"
	listbox $form.lists.nusers.list -borderwidth 1 -exportselection false \
		-relief sunken -selectmode browse -width 10 -takefocus 0 \
		-yscrollcommand [ list $form.lists.actkey.scroll set ] \
		-highlightthickness 0
	pack $form.lists.nusers.label 
	pack $form.lists.nusers.list -side left
	pack $form.lists.nusers -side left

	frame $form.lists.nports -takefocus 0
	label $form.lists.nports.label -text "Num Ports"
	listbox $form.lists.nports.list -borderwidth 1 -exportselection false \
		-relief sunken -selectmode browse -width 10 -takefocus 0 \
		-yscrollcommand [ list $form.lists.actkey.scroll set ] \
		-highlightthickness 0
	pack $form.lists.nports.label 
	pack $form.lists.nports.list -side left
	pack $form.lists.nports -side left

	#
	# Make a list for actkey but don't show it (don't pack it)
	frame $form.lists.actkey -takefocus 0
	label $form.lists.actkey.label -text ""
	pack $form.lists.actkey.label 

	#
	# Add a scrollbar to the lists
	#
	scrollbar $form.lists.actkey.scroll -takefocus 0 -highlightthickness 0
	pack $form.lists.actkey.scroll -side left -fill y
	pack $form.lists.actkey -side left -fill y

	pack $form.lists -pady 16 -padx 8

	#
	# Bind the lists so they act together
	#
	vclutils__BindMultiScrollbar $form.lists.actkey.scroll \
		$form.lists.prod.list \
		$form.lists.desc.list \
		$form.lists.type.list \
		$form.lists.mach.list \
		$form.lists.expires.list \
		$form.lists.nusers.list \
		$form.lists.nports.list

	vclutils__BindMultiList $double_click \
		$form.lists.prod.list \
		$form.lists.desc.list \
		$form.lists.type.list \
		$form.lists.mach.list \
		$form.lists.expires.list \
		$form.lists.nusers.list \
		$form.lists.nports.list
	
	#
	# Create the dialog buttons
	#
	frame $form.buttons
	button $form.buttons.done -width 8 -height 2 -text "Done" \
		-command license_adm__Done
	button $form.buttons.update -width 8 -height 2 -text "Update" \
		-state $state -command [list license_adm__InputForm 0]
	button $form.buttons.add  -width 8 -height 2 -text "Add" \
		-state $state -command license_adm__Add

	pack $form.buttons.done $form.buttons.update $form.buttons.add \
		-side left -expand 1
	pack $form.buttons -padx 8 -pady 16

	catch { pack $form }
	return
}


# +++PHDR+++
#
# Procedure:	license_adm__FillMainList
#
# Description:
#
#
# Argument		Description
# --------------------	----------------------------------------------------
# n/a
#
#
# Returns: 	nothing
#
#
# Notes:
#
# ---PHDR---

proc license_adm__FillMainList { } {
	global license_adm

	#
	# Clear the current list
	#
	$license_adm(form).lists.prod.list    delete 0 end
	$license_adm(form).lists.desc.list    delete 0 end
	$license_adm(form).lists.type.list    delete 0 end
	$license_adm(form).lists.mach.list    delete 0 end
	$license_adm(form).lists.expires.list delete 0 end
	$license_adm(form).lists.nusers.list  delete 0 end
	$license_adm(form).lists.nports.list  delete 0 end

	set license_adm(serials) {}
	set license_adm(actkeys) {}
	set license_adm(hostnms) {}

        #
        # Get a list of licensed products and fill in the lists
        #
	set num_lics [ @license list -count ]
	for { set i 1 } { $i <= $num_lics } { incr i } {
		@license list -number $i -array rec
		$license_adm(form).lists.prod.list    insert end $rec(name)
		$license_adm(form).lists.desc.list    insert end $rec(desc)
		$license_adm(form).lists.mach.list    insert end $rec(machine)
		$license_adm(form).lists.type.list    insert end $rec(type)
		$license_adm(form).lists.expires.list insert end $rec(expires)
		$license_adm(form).lists.nusers.list  insert end $rec(nusers)
		$license_adm(form).lists.nports.list  insert end $rec(nports)
		
		lappend license_adm(serials) $rec(serial)
		lappend license_adm(actkeys) $rec(actkey)
		lappend license_adm(hostnms) $rec(host)
	}

	return
}

proc license_adm__Add {} {
	license_adm__InputForm 1
}

proc license_adm__Update {} {
	license_adm__InputForm 0
}


proc license_adm__GetHostname {} {
	global license_adm
	global vsimenu__hostname

	set form ".hostname_input"
       	catch { destroy $form }
	toplevel $form

	#
	# Put the title on the shell
	#
	set vtitle "$vsimenu__hostname - License Hostname"
	wm title $form $vtitle

	#
	# Setup a handler for the window manager "Close" function
	#
	wm protocol $form WM_DELETE_WINDOW license_adm__Cancel

	frame $form.hostnm
	label $form.hostnm.label -text "Remote host IP:" \
		-width 15 -anchor e
	entry $form.hostnm.entry -relief sunken -width 16 \
		-textvariable license_adm(hostnm)
	pack $form.hostnm.label -side left
	pack $form.hostnm.entry -side left -fill x -expand 1
	pack $form.hostnm -padx 16 -pady 16 -fill x

	#
	# Separate the form from the dialog buttons
	#
	frame $form.separator -relief groove -borderwidth 1 -height 2
	pack $form.separator -pady 16 -padx 2 -fill x 

	frame $form.buttons
	button $form.buttons.ok -width 6 -text "OK" \
		-command license_adm__OK
	button $form.buttons.cancel -width 6 -text "Cancel" \
		-command license_adm__Cancel
	pack $form.buttons.ok $form.buttons.cancel -side left -expand 1
	pack $form.buttons -expand 1 -fill x -padx 16 -ipadx 4

	frame $form.spacer -height 16
	pack $form.spacer

	vclutils__CenterDialog $form $license_adm(form)
	vclutils__LockSize $form

	#
	# Always update after popping up and before setting focus
	#
	grab $form
	update

	focus $form.hostnm.entry

	#
	# Make the dialog modal
	#
	tkwait variable license_adm(input_done)
	grab release $form
	destroy $form
}

# +++PHDR+++
#
# Procedure:
#
# Description:
#
#
# Argument		Description
# --------------------	----------------------------------------------------
#
#
# Returns:
#
#
# Notes:
#
# ---PHDR---

proc license_adm__InputForm { add_prod } {
	global license_adm
	global vsimenu__hostname

	set form ".license_input"
       	catch { destroy $form }
	toplevel $form

	if { [llength $license_adm(serials)] == 0 } {
		if { [llength $license_adm(actkeys)] == 0 } {
			if { [llength $license_adm(hostnms)] == 0 } {
				set add_prod 1
			}
		}
	} else { set add_prod 0 }
	
	#
	# Put the title on the shell
	#
	if { $add_prod } {
		set vtitle "$vsimenu__hostname - Add License"
		set license_adm(serial) ""
		set license_adm(actkey) ""
		set license_adm(hostnm) ""
	} else {
		set vtitle "$vsimenu__hostname - Update License"

		set selected [vclutils__GetSelected \
			$license_adm(form).lists.prod.list]

		if { $selected == "" } {
			return
		}

		set i [$license_adm(form).lists.prod.list curselection]
		set license_adm(serial) [lindex $license_adm(serials) $i]
		set license_adm(actkey) [lindex $license_adm(actkeys) $i]
		set license_adm(hostnm) [lindex $license_adm(hostnms) $i]
	}

	wm title $form $vtitle
	
	#
	# Setup a handler for the window manager "Close" function
	#
	wm protocol $form WM_DELETE_WINDOW license_adm__Cancel

	frame $form.serial
	label $form.serial.label -text "Serial Number:" -width 15 -anchor e
	entry $form.serial.entry -relief sunken -width 25 \
		-textvariable license_adm(serial)
	pack $form.serial.label $form.serial.entry -side left
	pack $form.serial -padx 16 -pady 16 -fill x

	frame $form.actkey
	label $form.actkey.label -text "Activation Key:" -width 15 -anchor e
	entry $form.actkey.entry -relief sunken -width 16 \
		-textvariable license_adm(actkey)
	pack $form.actkey.label -side left
	pack $form.actkey.entry -side left -fill x -expand 1
	pack $form.actkey -padx 16 -fill x

	if { $license_adm(hostnm) != "" } {
		frame $form.hostnm
		label $form.hostnm.label -text "Remote host IP:" \
			-width 15 -anchor e
		entry $form.hostnm.entry -relief sunken -width 16 \
			-textvariable license_adm(hostnm)
		pack $form.hostnm.label -side left
		pack $form.hostnm.entry -side left -fill x -expand 1
		pack $form.hostnm -padx 16 -fill x
	}

	#
	# Separate the form from the dialog buttons
	#
	frame $form.separator -relief groove -borderwidth 1 -height 2
	pack $form.separator -pady 16 -padx 2 -fill x 

	frame $form.buttons
	button $form.buttons.ok -width 6 -text "OK" \
		-command license_adm__OK
	button $form.buttons.cancel -width 6 -text "Cancel" \
		-command license_adm__Cancel
	pack $form.buttons.ok $form.buttons.cancel -side left -expand 1
	pack $form.buttons -expand 1 -fill x -padx 16 -ipadx 4

	frame $form.spacer -height 16
	pack $form.spacer

	vclutils__CenterDialog $form $license_adm(form)
	vclutils__LockSize $form

	#
	# Always update after popping up and before setting focus
	#
	grab $form
	update

	focus $form.serial.entry

	#
	# Make the dialog modal
	#
	tkwait variable license_adm(input_done)
	grab release $form
	destroy $form

	if { $license_adm(input_done) == 0 } {
		return
	}

	set rc [ catch { @license validate -serial $license_adm(serial) \
		-actkey $license_adm(actkey) } msg ]

	if { $rc == 0 } {
		if { $msg == "true" } {
			license_adm__GetHostname
			if { $license_adm(input_done) == 0 } {
				return
			}
		}

		if { $add_prod == 0 } {
			set rc [ catch { @license update \
				-s $license_adm(serial) \
				-k $license_adm(actkey) \
				-h $license_adm(hostnm) } msg ]
		} else {
			set rc [ catch { @license add \
				-s $license_adm(serial) \
				-k $license_adm(actkey) \
				-h $license_adm(hostnm) } msg ]
		}
	}

	#
	# Let the user know what went wrong
	#
	if { $rc != 0 } {
		tk_messageBox -title $vtitle -type ok -icon error \
			-parent $license_adm(shell) -message $msg
	} else {
		license_adm__FillMainList
	}
}

proc license_adm__Cancel {} {
	global license_adm
	set license_adm(input_done) 0
}


proc license_adm__OK {} {
	global license_adm
	set license_adm(input_done) 1
}

# +++PHDR+++
#
# Procedure:	license_adm__Done
#
# Description:
#
#
# Argument		Description
# --------------------	----------------------------------------------------
# n/a
#
#
# Returns:	nothing
#
#
# Notes:
#
# ---PHDR---

proc license_adm__Done {} {
	global license_adm

	set license_adm(done) 1
}



proc license_adm__Popup { parent shell } {
	global license_adm

	#
	# Get a license admin object
	#
	catch { vcl destroy @license }
	vcl license @license

	#
	# Build and display the Modem database form
	#
	license_adm__BuildMainForm $shell
	license_adm__FillMainList
	vclutils__CenterDialog $shell $parent
	vclutils__LockSize $shell

	vclutils__SetSelected 0 \
		$license_adm(form).lists.prod.list \
		$license_adm(form).lists.desc.list \
		$license_adm(form).lists.mach.list \
		$license_adm(form).lists.type.list \
		$license_adm(form).lists.expires.list \
		$license_adm(form).lists.nusers.list \
		$license_adm(form).lists.nports.list

	#
	# Make the dialog modal
	#
	update
	grab $license_adm(shell)

	#
	# Wait for the dialog to be done
	#
	tkwait variable license_adm(done)
	grab release $license_adm(shell)

	#
	# Destroy the interface and everything else
	#
	catch { vcl destroy @license }
	if { $license_adm(shell) == ".license_adm" } {
		catch { destroy $license_adm(shell) }
	}
}

