# ------------------------------------------------------------------------
#
#	Description:
#
#	This is the default system TNP for all jobs
#
#	usage: <tnp> reqid clientid mailaddr time notify grpid \
#			numpgs faxnum aresult rresult attempt done
#
# ------------------------------------------------------------------------

global argv argc env

# ------------------------------------------------------------------------
# get all arguments
#
set REQID    [lindex $argv 0  ]
set CLIENTID [lindex $argv 1  ]
set MAILADDR [lindex $argv 2  ]
set SENDTIME [lindex $argv 3  ]
set NOTIFY   [lindex $argv 4  ]
set GRPID    [lindex $argv 5  ]
set NUMPGS   [lindex $argv 6  ]
set FAXNUM   [lindex $argv 7  ]
set ARESULT  [lindex $argv 8  ]
set RRESULT  [lindex $argv 9  ]
set ATTEMPT  [lindex $argv 10 ]
set DONE     [lindex $argv 11 ]
set USER_TNP [lindex $argv 12 ]

# ------------------------------------------------------------------------
# user msg file & temp file
#
set VSIFAX	$env(VSIFAX)

# ------------------------------------------------------------------------
# check if LCR notification needed for this job
#
catch { [ exec "$VSIFAX/lbin/vlcrstat" $REQID ] }

# ------------------------------------------------------------------------
# check if print/notification needs to be done
#
catch { [ exec "$VSIFAX/lbin/vsend" $REQID ] }

# ------------------------------------------------------------------------
# run the site TNP if it exists
#
set status [ catch  \
	{ exec "$VSIFAX/lbin/vnotify" -n -t site \
		"$REQID" \
		"$CLIENTID" \
		"$MAILADDR" \
		"$SENDTIME" \
		"$NOTIFY" \
		"$GRPID" \
		"$NUMPGS" \
		"$FAXNUM" \
		"$ARESULT" \
		"$RRESULT" \
		"$ATTEMPT" \
		"$DONE" \
	} ]
if { $status != 0 } {
	exit 1
}

# ------------------------------------------------------------------------
# run the <user> TNP if it exists
#
if { [string compare "$USER_TNP" ""] != 0 } {

	set status [ catch \
		{ exec "$VSIFAX/lbin/vnotify" -t "$USER_TNP" \
			"$REQID" \
			"$CLIENTID" \
			"$MAILADDR" \
			"$SENDTIME" \
			"$NOTIFY" \
			"$GRPID" \
			"$NUMPGS" \
			"$FAXNUM" \
			"$ARESULT" \
			"$RRESULT" \
			"$ATTEMPT" \
			"$DONE" \
		} ]
	if { $status != 0 } {
		exit 1
	}
}

exit 0
