# ------------------------------------------------------------------------
# sys-devfail.tcl
#
#	Description:
#
#	Device failure notification script
#	Log & email notification
#	FoDC Failover procedure
#
# ------------------------------------------------------------------------
set VSIFAX $env(VSIFAX)

# ------------------------------------------------------------------------
# Configurable globals
# ------------------------------------------------------------------------
set FODC_MAIN_DEVICE "FoDC"
set FODC_FAILOVER_DEVICE "FoDC2"
set EMAIL ""

# ------------------------------------------------------------------------
# Get all arguments and setup environment
# ------------------------------------------------------------------------
global argv env
set DEVICE [lindex $argv 0]
set REASON [lindex $argv 1]
set TIMESTAMP [ clock format [ clock seconds ] -format {%Y/%m/%d %H:%M:%S} ]
set FAILOVER_DEVICE ""

# ------------------------------------------------------------------------
# Check if FoDC Failover is enabled and configured
# ------------------------------------------------------------------------
set FODC_MAIN_CONFIGURED ""
set FODC_FAILOVER_CONFIGURED ""
set FODC_FAILOVER_ENABLED "0"
catch {set FODC_FAILOVER_ENABLED [exec "$VSIFAX/bin/vfxadmin" config -slqb -i $FODC_MAIN_DEVICE DEVICE failover]}
catch {set FODC_MAIN_CONFIGURED [exec "$VSIFAX/bin/vfxadmin" config -slq -i $FODC_MAIN_DEVICE DEVICE accountid]}
catch {set FODC_FAILOVER_CONFIGURED [exec "$VSIFAX/bin/vfxadmin" config -slq -i $FODC_FAILOVER_DEVICE DEVICE accountid]}
if {[string compare "$FODC_FAILOVER_ENABLED" "1"] == 0
		&& [string length "$FODC_MAIN_CONFIGURED"] > 0
		&& [string length "$FODC_FAILOVER_CONFIGURED"] > 0 } {
	if {[string compare "$DEVICE" "$FODC_MAIN_DEVICE"] == 0} {
		set FAILOVER_DEVICE "$FODC_FAILOVER_DEVICE"
	} else {
		if {[string compare "$DEVICE" "$FODC_FAILOVER_DEVICE"] == 0} {
			set FAILOVER_DEVICE "$FODC_MAIN_DEVICE"
		}
	}
}

# ------------------------------------------------------------------------
# Update log file & send a notification email
# ------------------------------------------------------------------------
if {[string length "$FAILOVER_DEVICE"] > 0} {
	set ERROR "Device $DEVICE failed: $REASON. Enabling $FAILOVER_DEVICE"
} else {
	set ERROR "Device $DEVICE failed: $REASON."
}

set f [ open $VSIFAX/spool/logs/devfail a+ ]
puts $f "$TIMESTAMP $ERROR"
close $f

if {[string length "$EMAIL"] > 0} {
	#---------------------------------------------------------------------
	# Create email file
	#---------------------------------------------------------------------
	set g [ open $VSIFAX/spool/temp/devfail w+ ]
	puts $g "$TIMESTAMP $ERROR"
	close $g

	#---------------------------------------------------------------------
	# Email notification to specified mail address
	#---------------------------------------------------------------------
	catch {exec "$VSIFAX/lbin/vmime" -t -s $ERROR "$VSIFAX/spool/temp/devfail" | "$VSIFAX/lbin/vmail" -R $EMAIL $EMAIL}
	file delete "$VSIFAX/spool/temp/devfail"
}

# ------------------------------------------------------------------------
# Failover: Issue command to switch on failover device
# ------------------------------------------------------------------------
if {[string length "$FAILOVER_DEVICE"] > 0} {
	catch {exec "$VSIFAX/bin/vfxadmin" enable $FAILOVER_DEVICE}
	catch {puts stdout "Enabling $FAILOVER_DEVICE"}
}

exit 0 
