#!/bin/sh
# ------------------------------------------------------------------------
#
#	Description:
#
#	This is the system GNP for all group jobs
#
#	usage: <gnp> reqid clientid mailaddr time notify grpid \
#				num-mems num-sent num-failed
#
# ------------------------------------------------------------------------

# ------------------------------------------------------------------------
# get all arguments
#
REQID="$1"
CLIENTID="$2"
MAILADDR="$3"
SENDTIME="$4"
NOTIFY="$5"
GRPID="$6"
NUM_MEMS="$7"
NUM_SENT="$8"
NUM_FAIL="$9"
shift
USER_GNP="$9"

# ------------------------------------------------------------------------
# check if any print/email of notification/fax to be done
#
"$VSIFAX/lbin/vsend" g-$GRPID

# ------------------------------------------------------------------------
# run the site GNP if it exists
#
"$VSIFAX/lbin/vnotify" -n -g site \
	"$REQID" "$CLIENTID" "$MAILADDR" "$SENDTIME" "$NOTIFY" \
	"$GRPID" "$NUM_MEMS" "$NUM_SENT" "$NUM_FAIL"
status=$?
[ $status -ne 0 ] && exit $status

# ------------------------------------------------------------------------
# run the <user> GNP if it exists
#
if [ "$USER_GNP" != "" ]
then
	"$VSIFAX/lbin/vnotify" -g "$USER_GNP" \
		"$REQID" "$CLIENTID" "$MAILADDR" "$SENDTIME" "$NOTIFY" \
		"$GRPID" "$NUM_MEMS" "$NUM_SENT" "$NUM_FAIL"
	status=$?
	[ $status -ne 0 ] && exit $status
fi

exit 0
