#!/bin/sh
#
# ------------------------------------------------------------------------
# script to start/stop the vsifax fax server
#
[ ! -f /etc/vsifax.sh ] ||
{
	. /etc/vsifax.sh

	case "$1" in

	# ----------------------------------------------------------------
	# help targets
	#
	'-?'  | -help    | --help | \
	'-??' | -helpall | --helpall)
		echo "Usage: `basename $0` start|stop" ;;

	# ----------------------------------------------------------------
	# version targets
	#
	'-V' | -version | --version)
		echo "`basename $0`: `vfxadmin version`" ;;

	# ----------------------------------------------------------------
	# standard targets
	#
	start)		vfxsched start	;;
	stop)		vfxsched halt	;;

	# ----------------------------------------------------------------
	# HP-specific targets
	#
	start_msg)	echo "Starting the VSI-FAX Fax Server subsystem" ;;
	stop_msg)	echo "Stopping the VSI-FAX Fax Server subsystem" ;;

	esac
}
