#!/bin/sh
#
# ------------------------------------------------------------------------
# script to start/stop the vsifax admin server
#
[ ! -f /etc/vsifax.sh ] ||
{
	. /etc/vsifax.sh

	case "$1" in

	# ----------------------------------------------------------------
	# help targets
	#
	'-?'  | -help    | --help | \
	'-??' | -helpall | --helpall)
		echo "Usage: `basename $0` start|stop" ;;

	# ----------------------------------------------------------------
	# version targets
	#
	'-V' | -version | --version)
		echo "`basename $0`: `vfxadmin version`" ;;

	# ----------------------------------------------------------------
	# standard targets
	#
	start)		vfxsched -a start	;;
	stop)		vfxsched -a stop	;;

	# ----------------------------------------------------------------
	# HP-specific targets
	#
	start_msg)	echo "Starting the VSI-FAX Admin Server subsystem" ;;
	stop_msg)	echo "Stopping the VSI-FAX Admin Server subsystem" ;;

	esac
}
