// +++FHDR+++
//
//
//   Class Name : VxmldTransport
//   Super Class: DocumentTransport
//
//   Description: This class implements a DocumentTransport for transporting
//                XMLF documents to the VSI-FAX xmld daemon.
//
//
//   Notes      : none
//
//
//   Method - Description
//   ------------------------------------------------------------------------
//
//
// ---FHDR---


#include <string.h>

#include "VxmldTransport.h"
#include "Url.h"
#include "TcpSocket.h"



#define DEFAULT_XMLD_PORT 2996
#define XML_READ_BUF_SIZE 16384



// +++PHDR+++
//
//  Method     : VxmldTransport::VxmldTransport()
//
//  Visibility : public
//
//  Description: Default constructor for the VxmldTransport class.
//
//  Parameter       Type                    Description
//  --------------- ----------------------- ----------------------------------
//  none
//
//
//  Returns:   n/a
//
//
//  Notes:     none
//
// ---PHDR---

VxmldTransport::VxmldTransport()
{
}


// +++PHDR+++
//
//  Method     : VxmldTransport::~VxmldTransport()
//
//  Visibility : public
//
//  Description: Destructor for the VxmldTransport class.
//
//  Parameter       Type                    Description
//  --------------- ----------------------- ----------------------------------
//  none
//
//
//  Returns:   n/a
//
//
//  Notes:     none
//
// ---PHDR---

VxmldTransport::~VxmldTransport()
{
}


// +++PHDR+++
//
//  Method     : VxmldTransport::getLastError()
//
//  Visibility : public
//
//  Description: Returns the last error message from the transport.
//
//  Parameter       Type                    Description
//  --------------- ----------------------- ----------------------------------
//  none
//
//
//  Returns:   A char * containing the last error message generated by the
//             transport.
//
//
//  Notes:     none
//
// ---PHDR---

char * VxmldTransport::getLastError ()
{
	return (_err_msg);
}


// +++PHDR+++
//
//  Method     : VxmldTransport::send()
//
//  Visibility : public
//
//  Description: Sends the specified XML data to the specified URL.
//
//  Parameter       Type                    Description
//  --------------- ----------------------- ----------------------------------
//  url_spec        char *                  The URL of the vxmld server
//  xml_data        char *                  the XML data to send
//
//
//  Returns:   The response data returned by the server.
//
//
//  Notes:     none
//
// ---PHDR---

char * VxmldTransport::send (char * url_spec, char * xml_data)
{
	/*
	 * Parse the URL and open a connection to the xmld daemon
	 */
	Url url(url_spec);
	if (url.getPort() < 1) {
		url.setPort(DEFAULT_XMLD_PORT);
	}

	TcpSocket s;
	if (!s.open(url.getHost(), url.getPort())) {
		_err_msg << s.getLastError() << ends;
		return (NULL);
	}


	/*
	 * Write the XML data to the daemon
	 */
	if (!s.ok_to_write()) {
		_err_msg << s.getLastError() << ends;
		return (NULL);
	}
	int len = strlen(xml_data) + 1;
	if (!s.write(xml_data, len)) {
		_err_msg << s.getLastError() << ends;
		s.close();
		return (NULL);
	}

	/*
	 * Now read the response from the server and return it
	 */
	char * buf = s.read();
	if (buf == NULL) {
		_err_msg << s.getLastError() << ends;
	}

	s.close();
	return (buf);
}


// +++PHDR+++
//
//  Method     : VxmldTransport::send()
//
//  Visibility : public
//
//  Description: Sends the data from the specified stream to the specified URL.
//
//  Parameter       Type                    Description
//  --------------- ----------------------- ----------------------------------
//  url_spec        char *                  The URL of the vxmld server
//  xml_stream      istream *               the XML stream to send
//
//
//  Returns:   The response data returned by the server.
//
//
//  Notes:     none
//
// ---PHDR---

char * VxmldTransport::send (char * url_spec, istream * xml_stream)
{
	/*
	 * Parse the URL and open a connection to the xmld daemon
	 */
	Url url(url_spec);
	if (url.getPort() < 1) {
		url.setPort(DEFAULT_XMLD_PORT);
	}

	TcpSocket s;
	if (!s.open(url.getHost(), url.getPort())) {
		_err_msg << s.getLastError() << ends;
		return (NULL);
	}

	/*
	 * Make sure it's ok to write to the socket
	 */
	if (!s.ok_to_write()) {
		_err_msg << s.getLastError() << ends;
		s.close();
		return (NULL);
	}

	/*
	 * Now read and send a chunk at a time
	 */
	char xml_buf[XML_READ_BUF_SIZE];
	while (!xml_stream->eof()) {
		xml_stream->read(xml_buf, XML_READ_BUF_SIZE);
		int len = xml_stream->gcount();
		if (!s.write(xml_buf, len)) {
			_err_msg << s.getLastError() << ends;
			s.close();
			return (NULL);
		}
	}


	/*
	 * Now read the response from the server and return it
	 */
	char * buf = s.read();
	if (buf == NULL) {
		_err_msg << s.getLastError() << ends;
	}

	s.close();
	return (buf);
}

