// +++FHDR+++
//
//
//   Class Name : CmdLine
//   Super Class: n/a
//
//   Description: This class encapsulates the command line passed to
//		  the main() function of an executable. It processes
//		  the arguments in the same way as Unixes getopt().
//
//
//   Notes      : none
//
//
//   Method - Description
//   ------------------------------------------------------------------------
//
//
// ---FHDR---


#ifndef _CMDLINE_H_
#define _CMDLINE_H_


#define CMDLINE_EOF	-1
#define CMDLINE_ERROR	-2


class CmdLine {

  protected:

	int 	_optind;
	int 	_optopt;
	int 	_optsw;
	int 	_charpos;
	char 	_msgbuf[256];
	char * 	_optarg;
	const char *	_optstr;
	const char *	_switches;

	CmdLine () {;}


  public:

	CmdLine (const char * optstr);
	~CmdLine ();

	int 	getOpt (int argc, char **argv, const char *optstr = 0);
	int	getOptIndex ();
	int 	containsArg (int argc, char **argv, int arg);

	char *	getOptArg ();
	char * 	getStringArg (int argc, char **argv, int arg);

	char * 	getErrorMsg ();

	void 	setSwitches (const char *str);
};

#endif //_CMDLINE_H_

