package com.vsi.xmlf.beans;

import javax.swing.*;
import java.awt.*;

/**
 *
 */
public
class Splash extends JFrame implements java.io.Serializable {

	protected transient JLabel _label = null;

	/**
	 * No args constructor.
	 */
	public Splash () {
		super();
	}


	/**
	 *
	 */
	public Splash (String title, String image_filename) {
		super(title);
		drawImage(new ImageIcon(image_filename, title));
	}


	/**
	 *
	 */
	public Splash (String title, String image_filename,
		String icon_filename) {

		super(title);
		drawImage(new ImageIcon(image_filename, title));

		ImageIcon icon = new ImageIcon(icon_filename);
		if (icon != null) {
			setIconImage(icon.getImage());
		}
	}


	/**
	 *
	 */
	public Splash (String title, java.net.URL location) {
		super(title);
		drawImage(new ImageIcon(location, title));
	}


	/**
	 *
	 */
	public Splash (String title, java.net.URL image_location,
		java.net.URL icon_location) {

		super(title);
		drawImage(new ImageIcon(image_location, title));

		ImageIcon icon = new ImageIcon(icon_location);
		if (icon != null) {
			setIconImage(icon.getImage());
		}
	}


	public void setImage (java.net.URL location) {
		drawImage(new ImageIcon(location, getTitle()));
	}

	

	public void setImage (String filename) {
		drawImage(new ImageIcon(filename, getTitle()));
	}

	
	/**
	 *
	 */
	protected void drawImage (ImageIcon image) {
	
		_label = new JLabel(image);
		getContentPane().add(_label, BorderLayout.CENTER);
		int width  = image.getIconWidth();
		int height = image.getIconHeight();
		setSize(width, height);
		Dimension screenSize =
			Toolkit.getDefaultToolkit().getScreenSize();
		setLocation(screenSize.width / 2 - width / 2,
			screenSize.height / 2 - height / 2);
	}


	/**
	 * Shows/hides the splash screen.
	 */
	public void setVisible (boolean flag) {

		super.setVisible(flag);

		if (flag && _label != null) {
			_label.requestDefaultFocus();
		} 

		update(getGraphics());
	}
}

