package com.vsi.xmlf;

/**
 * This class encapsulates the common attributes of all XML-F response objects.
 *
 */
public 
class Response implements XmlfObject {

	protected String _tag = null;

	protected String _cmd_ref  = null;
	protected String _svc_ref  = null;
	protected String _app_ref  = null;
	
	protected RequestResults _request_results = null;


	/**
	 * No args constructor.
	 */
	public Response () {
	}


	/**
	 *
	 */
	public Response (String results_message, String results_status,
		String svc_ref, String app_ref, String cmd_ref) {

		_request_results = new RequestResults(results_message,
						results_status);

		_svc_ref = svc_ref;
		_app_ref = app_ref;
		_cmd_ref = cmd_ref;
	}


	/**
	 * Gets the XML tag for this object. This method is implemented by
         * all classes implementing the XmlfObject interface. The tag is
         * utilized in the toXml() method.
	 *
	 * @return  the tag for this XML object
	 * @see     #setTag
	 * @see     #toXml
	 */
	public synchronized String getTag () {
		return (_tag);
	}


	/**
	 * Sets the XML tag for this object. This method is implemented by
         * all classes implementing the XmlfObject interface.
         *
         * @param  tag  the XML tag name for this object
	 * @see    #getTag
	 */
	public synchronized void setTag (String tag) {
		_tag = tag;
	}


	/**
	 * Assignes the values/attributes in the XML data to this object.
	 *
	 * @param  root_element  the XML data to assign from
	 */
	public void setFromXml (XmlElement root_element) {

		setServiceReference(null);
		setApplicationReference(null);
		setCommandReference(null);
		setRequestResults(null);

		if (root_element == null) {
			return;
		}

		setTag(root_element.getName());

		XmlElement xml[] = root_element.getSubElements();

		setServiceReference(
			XmlElement.getData(xml, "service-reference"));
		setApplicationReference(
			XmlElement.getData(xml, "application-reference"));
		setCommandReference(
			XmlElement.getData(xml, "command-reference"));

		XmlElement results_element =
			root_element.findElement("request-results");
		if (results_element != null) {
			setRequestResults(new RequestResults(results_element));
		}
	}


	/**
	 * Gets a string containing the XML for this object. Use
	 * <code>toXml(String indent)</code> to output indented XML.
	 *
	 * @return  a String containing the XML for this object
	 * @see     #toXml(String indent)
	 */
	public String toXml () {
		return (toXml(""));
	}


	/**
	 * Gets a string containing the indented XML for this object. Use
	 * <code>toXml()</code> to output non-formatted XML.
	 *
	 * @return  a String containing the indented XML for this object
	 * @see     #toXml()
	 */
	public String toXml (String indent) {

		StringBuffer xml = new StringBuffer();

		if (indent == null)
			indent = "";

		xml.append(indent + "<?xml version=\"1.0\"?>\n");
		xml.append(indent + "<" + getTag() + ">\n");

		xml.append(getRequestResultsXml(indent + "\t"));
		xml.append(getReferencesXml(indent + "\t"));
		xml.append(indent + "</" + getTag() + ">\n");

		return (xml.toString());
	}


	/**
	 *
	 */
	protected String getRequestResultsXml (String indent) {

		if (getRequestResults() != null) {
			return (getRequestResults().toXml(indent));
		} else {
			return ("");
		}
	}

 
	/**
	 *
	 */
	protected String getReferencesXml (String indent) {

		StringBuffer xml = new StringBuffer();

		if (indent == null)
			indent = "";

		if (getServiceReference() != null) {
			xml.append(indent + "<service-reference>" +
				getServiceReference() + 
				"</service-reference>\n");
		}
	
		if (getApplicationReference() != null) {
			xml.append(indent + "<application-reference>" +
				getApplicationReference() + 
				"</application-reference>\n");
		}

		if (getCommandReference() != null) {
			xml.append(indent + "<command-reference>" +
				getCommandReference() + 
				"</command-reference>\n");
		}

		return (xml.toString());
	}


	/**
	 *
	 */
	public synchronized RequestResults getRequestResults () {
		return (_request_results);
	}


	/**
	 *
	 */
	public synchronized void setRequestResults (RequestResults results) {
		_request_results = results;
	}


	/**
	 * Get the application reference associated with the request.
	 */
	public synchronized String getApplicationReference () {
		return (_app_ref);
	}


	/**
	 * Set the application reference associated with the request.
	 *
	 * @param  app_ref  the application refernce to assign.
	 */
	public synchronized void setApplicationReference (String app_ref) {
		_app_ref = app_ref;
	}


	/**
	 * Get the command reference associated with the request.
	 */
	public synchronized String getCommandReference () {
		return (_cmd_ref);
	}


	/**
	 * Set the command reference associated with the request.
	 *
	 * @param  cmd_ref  the command refernce to assign.
	 */
	public synchronized void setCommandReference (String cmd_ref) {
		_cmd_ref = cmd_ref;
	}


	/**
	 * Get the service reference associated with the request.
	 */
	public synchronized String getServiceReference () {
		return (_svc_ref);
	}


	/**
	 * Set the service reference associated with the request.
	 *
	 * @param  svc_ref  the service refernce to assign.
	 */
	public synchronized void setServiceReference (String svc_ref) {
		_svc_ref = svc_ref;
	}
}

