package com.vsi.xmlf;

/**
 * 
 *
 */
public
class JobStatus implements XmlfObject {

	protected String _msg = null;
	protected CurrentState _state = null;
	protected Disposition _disposition = null;

	protected String _tag = "job-status";


	/**
	 * No args constructor.
	 */
	public JobStatus () {
	}


	public JobStatus (String msg, CurrentState state, 
		Disposition disposition) {

		_msg   = msg;
		_state = state;
		_disposition = disposition;
	}


	public JobStatus (XmlElement job_element) {
		setFromXml(job_element);
	}


	/**
	 * Gets the XML tag for this object. This method is implemented by
         * all classes implementing the XmlfObject interface. The tag is
         * utilized in the toXml() method.
	 *
	 * @return  the tag for this XML object
	 * @see     #setTag
	 * @see     #toXml
	 */
	public synchronized String getTag () {
		return (_tag);
	}


	/**
	 * Sets the XML tag for this object. This method is implemented by
         * all classes implementing the XmlfObject interface.
         *
         * @param  tag  the XML tag name for this object
	 * @see    #getTag
	 */
	public synchronized void setTag (String tag) {
		_tag = tag;
	}


	/**
	 * Gets a string containing the XML for this object. Use
	 * <code>toXml(String indent)</code> to output indented XML.
	 *
	 * @return  a String containing the XML for this object
	 * @see     #toXml(String indent)
	 */
	public String toXml () {
		return (toXml(""));
	}


	/**
	 * Gets a string containing the indented XML for this object. Use
	 * <code>toXml()</code> to output non-formatted XML.
	 *
	 * @return  a String containing the indented XML for this object
	 * @see     #toXml()
	 */
	public String toXml (String indent) {

		StringBuffer xml = new StringBuffer();

		if (indent == null)
			indent = "";

		xml.append(indent + "<" + getTag());

		if (getCurrentState() != null) {
			xml.append(" current-state=\"" + 
				getCurrentState() + "\"");
		}

		if (getDisposition() != null) {
			xml.append(" disposition=\"" + getDisposition() + "\"");
		}
		xml.append(">\n");

		if (getMessage() != null) {
			xml.append(indent + "\t" + getMessage() + "\n");
		}

		xml.append(indent + "</" + getTag() + ">\n");
		return (xml.toString());
	}


	/**
	 * Assignes the values/attributes in the XML data to this object.
	 *
	 * @param  job_element  the XML data to assign from
	 */
	public void setFromXml (XmlElement job_element) {

		setMessage(null);
		setCurrentState(null);
		setDisposition(null);

		if (job_element == null) {
			return;
		}

		setCurrentState(CurrentState.stringToObject(
			job_element.getAttribute("current-state")));

		setDisposition(Disposition.stringToObject(
			job_element.getAttribute("disposition")));

		setMessage(job_element.getData());
	}


	/**
	 * Gets the message string assigned to the JobStatus object.
	 */
	public synchronized String getMessage () {
		return (_msg);
	}


	/**
	 * Gets the current-state assigned to the JobStatus object.
	 */
	public synchronized CurrentState getCurrentState () {
		return (_state);
	}


	/**
	 * 
	 */
	public synchronized Disposition getDisposition () {
		return (_disposition);
	}



	/**
	 * @param
	 */
	public synchronized void setMessage (String msg) {
		_msg = msg;
	}


	/**
	 * @param
	 */
	public synchronized void setCurrentState (CurrentState state) {
		_state = state;
	}


	/**
	 *
	 */
	public synchronized void setDisposition (Disposition disposition) {
		_disposition = disposition;
	}
}

