package com.vsi.xmlf;

import java.io.File;
import java.io.FileInputStream;


/**
 * This class encapsulates a XMLF body element composed of
 * the data from the specified file.
 *
 */
public 
class FileBody extends Body {


	protected File   _file     = null;


	/**
	 * No args constructor.
	 */
	public FileBody () {
	}


	/**
	 * Constructs an <code>FileBody</code> object pointing to the
	 * specified filename.
	 *
	 * @param  filename  the filename for this <code>FileBody</code> object.
	 */
	public FileBody (String filename) {

		if (filename != null) {
			_file = new File(filename.trim());
		}
	}


	/**
	 * Constructs an <code>FileBody</code> object pointing to the
	 * specified filename.
	 *
	 * @param  file  the <code>File</code> object to use for
	 *               this <code>FileBody</code> object.
	 */
	public FileBody (File file) {

		_file = file;
	}


	/**
	 * Gets the data for the body.<p>
	 *
	 * <B>NOTE:</B> All sub-classes of <code>Body</code> must implement
	 * this method.
	 *
	 * @return  the data for this body element.
	 */
	public String getData () {

		/*
		 * make sure we have a valid file.
		 */
		if (_file == null) {
			return (null);
		}

		if (!_file.isFile() || !_file.canRead()) {
			return (null);
		}

		/*
		 * get an input stream and base64 encode it
		 */
		try {
			FileInputStream in = new FileInputStream(_file);
			byte encoded[] = Base64Codec.encode(in);
			return (new String(encoded));
		} catch (Exception ignore) {
			return (null);
		}
	}


	/**
	 * Get the file name assigned to this InlineBody object.<p>
	 *
	 * <B>NOTE:</B> All sub-classes of <code>Body</code> must implement
	 * this method.
	 */
	public String getFilename () {
		if (_file == null) {
			return (null);
		}

		return (_file.getName());
	}


	/**
	 * Sets the filename for this object.
	 *
	 * @param  filename   the filename for this FileBody object.
	 */
	public void setFilename (String filename) {
		if (filename == null) {
			_file = null;
		} else {
			_file = new File(filename.trim());
		}
	}


	/**
	 * We override this method  because the content-transfer-encoding
	 * is always "base64" for a <code>FileBody</code> object.
	 */
	public String getContentTransferEncoding () {
		return ("base64");
	}
}
