package com.vsi.xmlf;

import java.io.InputStream;


/**
 * The DocumentTransport class is an abstract class that is used as the
 * base class for all XML-F API transports. The DocumentTransport class
 * defines two methods that are used to write XML-F documents to a
 * network fax server.
 *
 */
public
interface DocumentTransport {

	/**
	 * Gets a String containing the last reported error from the transport.
	 *
	 * @return a string containing the last reported error
	 */
	public String getLastError ();


	/**
	 * Writes the specified XML data to the specified URL.
	 *
	 * @param  url_spec  the URL of the vxmld server.
	 * @param  xml_data  the XML data to send.
	 *
	 * @return  an InputStream to read the response from.
	 */
	public InputStream write (String url, String xml_data);


	/**
	 * Writes the data from the specified stream to the specified URL.
	 *
	 * @param  url_spec  the URL of the vxmld server.
	 * @param  xml_stream  the XML stream to send.
	 *
	 * @return  an InputStream to read the response from.
	 */
	public InputStream write (String url, InputStream xml_stream);
}

