package com.vsi.xmlf;

/**
 * The DocumentDecoder class is an abstract class that is used as the
 * base class for all XML-F API document decoders. The DocumentDecoder
 * class takes an XML document (either as a document element or from a stream)
 * and decodes it into an object which is subclassed from XmlfObject.
 *
 */
public
interface DocumentDecoder {

	/**
	 * Create the appropriate XmlfObject for the XML document.
	 *
	 * @para  root_element  The root element for the XML document.
	 * @returns  A XmlfObject representing the XML document contained
	 * by root_element.
	 */
	public XmlfObject createObject (XmlElement root_element);


	/**
	 * Binds this decoder to the TransportManager
	 *
	 * @param  mgr  The TransportManager to bind the decoder to.
	 */
	public void bind (TransportManager mgr);
}

