package com.vsi.xmlf;

/**
 *
 *
 */
public
class Disposition {


	public static final Disposition SUCCESS = new Disposition("success");
	public static final Disposition FAILURE = new Disposition("failure");
	public static final Disposition NA      = new Disposition("n/a");
	public static final Disposition PARTIAL_SUCCESS = 
				new Disposition("partial-success");
	

	private String _value = null;


	/**
	 * Constructors are private since this class is for constants only.
	 */
	private Disposition () {
	}

	private Disposition (String value) {
		_value = value;
	}


	public String toString () {
		return (_value);
	}


	/**
	 * Given a disposition string return the corresponding 
	 * <code>Disposition</code> object.
	 *
	 * @returns  The <code>Disposition</code> object corresponding the the 
	 * given string.
	 */
	public static Disposition stringToObject (String str) {

		if (str == null) {
			return (null);
		}

		if (str.equalsIgnoreCase("success")) {
			return (SUCCESS);
		} else if (str.equalsIgnoreCase("failure")) {
			return (FAILURE);
		} else if (str.equalsIgnoreCase("n/a")) {
			return (NA);
		} else if (str.equalsIgnoreCase("partial-success")) {
			return (PARTIAL_SUCCESS);
		} else {
			return (null);
		}
	}
}

