package com.vsi.xmlf;

/**
 * This class encapsulates a XML-F attempt-status element.
 *
 */
public
class AttemptStatus implements XmlfObject {

	protected Recipient _recipient  = null;
	protected String _date          = null;
	protected String _csi           = null;
	protected AttemptResult _result = null;

	protected String _tag = "attempt-status";



	/**
	 * No args constructor.
	 */
	public AttemptStatus () {
	}


	public AttemptStatus (Recipient recipient, String date, String csi,
		AttemptResult result) {

		_recipient = recipient;
		_date      = date;
		_csi       = csi;
		_result    = result;
	}


	public AttemptStatus (XmlElement attempt_element) {
		setFromXml(attempt_element);
	}


	/**
	 * Gets the XML tag for this object. This method is implemented by
         * all classes implementing the XmlfObject interface. The tag is
         * utilized in the toXml() method.
	 *
	 * @return  the tag for this XML object
	 * @see     #setTag
	 * @see     #toXml
	 */
	public synchronized String getTag () {
		return (_tag);
	}


	/**
	 * Sets the XML tag for this object. This method is implemented by
         * all classes implementing the XmlfObject interface.
         *
         * @param  tag  the XML tag name for this object
	 * @see    #getTag
	 */
	public synchronized void setTag (String tag) {
		_tag = tag;
	}


	/**
	 * Gets a string containing the XML for this object. Use
	 * <code>toXml(String indent)</code> to output indented XML.
	 *
	 * @return  a String containing the XML for this object
	 * @see     #toXml(String indent)
	 */
	public String toXml () {
		return (toXml(""));
	}


	/**
	 * Gets a string containing the indented XML for this object. Use
	 * <code>toXml()</code> to output non-formatted XML.
	 *
	 * @return  a String containing the indented XML for this object
	 * @see     #toXml()
	 */
	public String toXml (String indent) {

		StringBuffer xml = new StringBuffer();

		if (indent == null)
			indent = "";

		xml.append(indent + "<" + getTag() + ">\n");

		if (getRecipient() != null) {
			xml.append(getRecipient().toXml(indent + "\t"));
		}

		if (getDate() != null) {
			xml.append(indent + "\t<date>" + 
				getDate() + "</date>\n");
		}

		if (getCsi() != null) {
			xml.append(indent + "\t<csi>" + getCsi() + "</csi>\n");
		}

		if (getAttemptResult() != null) {
			xml.append(getAttemptResult().toXml(indent + "\t"));
		}


		xml.append(indent + "</" + getTag() + ">\n");
		return (xml.toString());
	}


	/**
	 * Assignes the values/attributes in the XML data to this object.
	 *
	 * @param  attempt_element  the XML data to assign from
	 */
	public void setFromXml (XmlElement attempt_element) {

		setRecipient(null);
		setDate(null);
		setCsi(null);
		setAttemptResult(null);

		if (attempt_element == null) {
			return;
		}

		XmlElement xml[] = attempt_element.getSubElements();

		XmlElement recipient_element =
				XmlElement.findElement(xml, "recipient");
		if (recipient_element != null) {
			setRecipient(new Recipient(recipient_element));
		}

		
		setDate(XmlElement.getData(xml, "date"));
		setCsi(XmlElement.getData(xml, "csi"));

		XmlElement result_element =
				XmlElement.findElement(xml, "result");
		if (result_element != null) {
			setAttemptResult(new AttemptResult(result_element));
		}

	}



	/**
	 * Gets the Recipient object assigned to the AttemptStatus object.
	 */
	public synchronized Recipient getRecipient () {
		return (_recipient);
	}


	/**
	 * Gets the date string assigned to the AttemptStatus object.
	 */
	public synchronized String getDate () {
		return (_date);
	}


	/**
	 * Gets the CSI assigned to the AttemptStatus object.
	 */
	public synchronized String getCsi () {
		return (_csi);
	}


	/**
	 * Gets the AttemptResult object assigned to this AttemptStatus object.
	 *
	 * @return  the contained AttemptResult object.
	 */
	public synchronized AttemptResult getAttemptResult () {
		return (_result);
	}



	/**
	 * Sets the recipient for the attempt.
	 *
	 * @param  recipient  the recipient of the attempt
	 */
	public synchronized void setRecipient (Recipient recipient) {
		_recipient = recipient;
	}


	/**
	 * Sets the date of the attempt.
	 *
	 * @param  date  the date of the attempt
	 */
	public synchronized void setDate (String date) {
		_date = date;
	}


	/**
	 * Sets the CSI (Called Station Id) of the attempt.
	 *
	 * @param  csi  the called station id
	 */
	public synchronized void setCsi (String csi) {
		_csi = csi;
	}


	/**
	 *
	 */
	public synchronized void setAttemptResult (AttemptResult result) {
		_result = result;
	}
}

