#!/bin/sh
#
#+++FHDR+++
#
#	Description:
#
#	final processing for Brooktrout installation
#
#---FHDR---

# ------------------------------------------------------------------------
# check if running in windows
#
in_windows ()
{
	[ -d "c:/" ]
}

# ------------------------------------------------------------------------
# add a directory to the path
#
# Note that the directory is ALWAYS added to the end.
#
addpath ()
{
	dir="$1"

	sep=":"
	arg=""
	if in_windows
	then
		sep=";"
		arg="-i"
	fi

	foo=`echo "$PATH" | egrep $arg "^$dir$sep|$sep$dir$sep|$sep$dir$"`
	if [ $? -eq 0 ]
	then
		echo "$PATH"
	else
		echo "$PATH$sep$dir"
	fi

	unset dir sep arg foo
}

# ------------------------------------------------------------------------
# main()
#
PATH=`addpath "$VSIFAX/bin"`
PATH=`addpath "$VSIFAX/lbin"`

# ------------------------------------------------------------------------
# Now do any setups
#
vsi-boston-setup.sh

# ------------------------------------------------------------------------
# now do any configuration
#
if [ "$QUICK_INSTALL" != "yes" ]
then
	vsi-boston-config.sh
fi

exit 0
