/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 1990-2008 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
/****************************************************************************
*
*   Filename:       kerndep.h
*   %date_modified: Mon Nov 19 17:10:36 2007 %
*   Description:
*
*****************************************************************************/

int kerndep_init(void);
void kerndep_term(void);
int kerndep_chrdev(char *dev_name);
void kerndep_spin_lock_init(void);
void kerndep_init_waitqueue_head(void);
void *kerndep_vmalloc(unsigned size);
void kerndep_vfree(void *ptr);
void *kerndep_kmalloc(unsigned size);
void kerndep_kfree(void *ptr);
void kerndep_printk(char *fmt,unsigned a1,unsigned a2);
void kerndep_unchrdev(int maj_num,char *dev_name);
unsigned kerndep_jiffies(void);
int kerndep_in_interrupt(void);
void *kerndep_current(void);
void kerndep_spin_lock_irqsave(unsigned long *flagptr);
void kerndep_spin_unlock_irqrestore(unsigned long flags);
void kerndep_printk_notice(char *msg);
void kerndep_printk_emerg(char *msg);
void kerndep_delay(int dval);
void *kerndep_wq_lock(void);
void *kerndep_wq_list(int wq_num,int do_init);
unsigned long kerndep_init_waitqueue_entry
    (void *wq,
     unsigned long tmp1,
     int tmp2,
     unsigned long *tmp3,
     unsigned long (*cb_func)(void *wq,
                              void *wait,
                              unsigned long tmp1,
                              int tmp2,
                              unsigned long *tmp3));
void kerndep_set_intr(int interruptible);
void kerndep_add_wait_queue(void *wq,void *wait);
void kerndep_add_wait_queue_excl(void *wq,void *wait);
unsigned long kerndep_schedule_timeout(unsigned long n);
void kerndep_schedule(void);
void kerndep_wake_up_interruptible(void *wq);
void kerndep_remove_wait_queue(void *wq, void *wait);
unsigned cvt_ms_to_ticks(unsigned ms_time);
unsigned cvt_ticks_to_ms(unsigned tick_time);
unsigned cvt_ticks_to_ms_ovfl_ok(unsigned tick_time);
void kerndep_setup_pipr_timer(void (*cb_func)(unsigned long),
                              unsigned long data,
                              unsigned expires);
void kerndep_setup_retry_timer(void (*cb_func)(unsigned long),
                               unsigned long data,
                               unsigned expires);
void kerndep_setup_intr_timer(void (*cb_func)(unsigned long),
                              unsigned long data,
                              unsigned expires);
void kerndep_del_pipr_timer(void);
void kerndep_del_retry_timer(void);
void kerndep_del_intr_timer(void);
void kerndep_queue_task_isa_tq(void);
int kerndep_copy_from_user(void *to,void *from,unsigned long size);
int kerndep_copy_to_user(void *to,void *from,unsigned long size);
void kerndep_wake_up_lock(void);
int kerndep_pci_present(void);
void *kerndep_pci_find_dev(unsigned vend_id,unsigned dev_id,void *dev);
unsigned kerndep_dev_vend_id(void *dev);
unsigned kerndep_dev_dev_id(void *dev);
unsigned kerndep_dev_bus_num(void *dev);
unsigned kerndep_dev_func_num(void *dev);
unsigned kerndep_dev_irq(void *dev);
void kerndep_dev_resource(void *dev,
			  int bar_num,
			  int *is_io,
			  unsigned long *start,
			  unsigned long *end);
unsigned kerndep_func_to_slot(unsigned func);
unsigned kerndep_func_to_func(unsigned func);
int kerndep_pci_read_config_byte(void *dev,unsigned off,void *addr);
int kerndep_pci_read_config_word(void *dev,unsigned off,void *addr);
int kerndep_pci_read_config_dword(void *dev,unsigned off,void *addr);
int kerndep_pci_write_config_byte(void *dev,unsigned off,unsigned char val);
int kerndep_pci_write_config_word(void *dev,unsigned off,unsigned short val);
int kerndep_pci_write_config_dword(void *dev,unsigned off,unsigned long val);
void *kerndep_ioremap(unsigned long off,unsigned long size);
void kerndep_iounmap(void *ptr);
unsigned long kerndep_virt_to_bus(void *ptr);
unsigned long kerndep_get_free_page(void);
void kerndep_free_page(unsigned long addr);
int kerndep_request_irq(unsigned irq_num,
			int (*hdlr)(int irq,void *dev,void *regs),
                        int sharing,char *name,void *dev_id);
void kerndep_free_irq(unsigned irq_num,void *dev_id);
void kerndep_writeb(unsigned val,volatile void *addr);
void kerndep_writew(unsigned val,volatile void *addr);
void kerndep_writel(unsigned val,volatile void *addr);
unsigned kerndep_readb(volatile void *addr);
unsigned kerndep_readw(volatile void *addr);
unsigned kerndep_readl(volatile void *addr);
void kerndep_outb(unsigned val,unsigned addr);
void kerndep_outw(unsigned val,unsigned addr);
void kerndep_outl(unsigned val,unsigned addr);
unsigned kerndep_inb(unsigned addr);
unsigned kerndep_inw(unsigned addr);
unsigned kerndep_inl(unsigned addr);
void kerndep_outsw(unsigned addr,void *ptr,unsigned size);
void kerndep_insw(unsigned addr,void *ptr,unsigned size);
void kerndep_memcpy_toio(volatile void *io_addr,void *mem_addr,unsigned size);
void kerndep_memcpy_fromio(void *mem_addr,volatile void *io_addr,
                           unsigned size);
int kerndep_check_region(unsigned addr,unsigned size);
void *kerndep_request_region(unsigned addr,unsigned size,char *dev_name);
void kerndep_release_region(unsigned addr,unsigned size);

extern unsigned kerndep_HZ;
extern unsigned kerndep_PAGE_SIZE;
extern unsigned kerndep_PAGE_MASK;
extern int kerndep_IRQ_HANDLED;
extern int kerndep_IRQ_NONE;

extern int mill_num_wqs;
int mill_bostonopen(void *inode, void *filp, void **priv);
int mill_bostonclose(void *inode, void *filp, void *priv);
int mill_bostonioctl(void *inode, void *filp,
                     unsigned int cmd, unsigned long arg,
                     void *priv);
int mill_init_module(void);
void mill_cleanup_module(void);
#if 0
void bostonpci_dpc(void *arg);
#endif
void bostonisa_dpc(void *arg);

extern unsigned int nmill;
extern unsigned mill_isa_addrs[8];
extern int mill_isa_hw_int;
extern int mill_isa_dma_chan;
extern unsigned int mill_mphm;
extern unsigned int mill_phy_buf_size;
extern unsigned int mill_app_buf_size;
extern unsigned mill_machine_id;
extern unsigned mill_do_reset;
extern unsigned mill_history_enable;
extern unsigned mill_history_size;
extern unsigned mill_num_hists_phy;
extern unsigned mill_num_hists_apl;
extern unsigned mill_hist_phy_admin_only;
extern unsigned mill_num_I2O_frames_per_module;
extern unsigned mill_fc_interval;
extern unsigned mill_mem_drv_alloc_min;
extern unsigned mill_mem_drv_alloc_quanta;
extern unsigned int mill_num_reserved_modules;
extern struct ser_mod {
    unsigned ser;
    unsigned mod;
} mill_mod_vals[32];
extern unsigned mill_test1, mill_test2, mill_test3;
extern int mill_config_vars_set;


#ifndef KERNEL_VERSION
#define KERNEL_VERSION(vers,rel,seq) (((vers)<<16) | ((rel)<<8) | (seq))
#endif
