/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 1990-2008 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
/****************************************************************************
*
*   Filename:       kerndep.c
*   %date_modified: Mon Nov 19 17:10:37 2007 %
*   Description:    This file contains source code which needs to be compiled
*   on a kernel-dependent basis. It should not be modified.
*
*****************************************************************************/

#if 0
#define USE_SYNC
#endif

#if defined(CONFIG_SMP) && !defined(__SMP__)
#define __SMP__
#endif
#if !defined(CONFIG_SMP) && defined(__SMP__)
#define CONFIG_SMP 1
#endif

#include <linux/module.h>

#include <linux/version.h>

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,0)
/* Turn on version support */
#if defined(CONFIG_MODVERSIONS) && !defined(MODVERSIONS)
#define MODVERSIONS
#endif
#ifdef MODVERSIONS
#include <linux/modversions.h>
#endif
#endif

#include <linux/sched.h>
#include <linux/kernel.h>
#include <linux/fs.h>
#include <linux/errno.h>
//#include <linux/malloc.h>
#include <linux/slab.h>
#include <linux/mm.h>
#include <linux/ioport.h>
#include <linux/interrupt.h>
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,0)
#include <linux/tqueue.h>
#else
#include <linux/workqueue.h>
#endif
#include <asm/io.h>
#include <asm/segment.h>
#include <asm/byteorder.h>

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,0)
/* Declares the copy_from_user, etc. (which is supposed to be in 2.1) */
#include <linux/isdnif.h>
#else
#include <asm/uaccess.h>
#endif

#include <linux/pci.h>

#include <stdarg.h>

#ifndef UTS_RELEASE
#include <linux/utsrelease.h>
#endif

#include "kerndep.h"


/* Declarations */

#define mill_str1(x) #x
#define mill_stringer(x) mill_str1(x)
char mill_driver_sysdep_what_string[] =
    "@(#)BOSTON Driver for Linux "
     "kernel " UTS_RELEASE
     " on arch "
    /* The string descriptions come from the file
       mod_devel_kit/<kver>/arch/i386/config.in for 7.1+ */
    /* The CONFIG_* names are defined for 7.1+; the CPU names are
       defined for 7.0- */
#if defined(CONFIG_M386) || (defined(CPU) && CPU == 386)
    "386";
#elif defined(CONFIG_M486) || (defined(CPU) && CPU == 486)
    "486";
#elif defined(CONFIG_M586) || (defined(CPU) && CPU == 586)
    "586/K5/5x86/6x86/6x86MX";
#elif defined(CONFIG_M586TSC)
    "Pentium-Classic";
#elif defined(CONFIG_M586MMX)
    "Pentium-MMX";
#elif defined(CONFIG_M686) || (defined(CPU) && CPU == 686)
    "Pentium-Pro/Celeron/Pentium-II";
#elif defined(CONFIG_MPENTIUMIII)
    "Pentium-III";
#elif defined(CONFIG_MPENTIUM4)
    "Pentium-4";
#elif defined(CONFIG_MK6)
    "K6/K6-II/K6-III";
#elif defined(CONFIG_MK7)
    "Athlon/Duron/K7";
#elif defined(CONFIG_MCRUSOE)
    "Crusoe";
#elif defined(CONFIG_MWINCHIPC6)
    "Winchip-C6";
#elif defined(CONFIG_MWINCHIP2)
    "Winchip-2";
#elif defined(CONFIG_MWINCHIP3D)
    "Winchip-2A/Winchip-3";
#else
    "unknown";
#endif

/* For recent versions of Linux */
#ifdef MODULE_LICENSE
MODULE_LICENSE("Proprietary");
#endif



/* Variables */

static struct file_operations mill_fops;

#ifdef __SMP__
static spinlock_t mill_spinlock;
#else
static spinlock_t mill_spinlock __attribute__ ((unused));
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,0)
static struct wait_queue *mill_lock_wq;
static struct wait_queue **wq_list;
#else
DECLARE_WAIT_QUEUE_HEAD(mill_lock_wq);
static wait_queue_head_t *wq_list;
#endif

unsigned kerndep_HZ = HZ;
unsigned kerndep_PAGE_SIZE = PAGE_SIZE;
unsigned kerndep_PAGE_MASK = PAGE_MASK;

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0)
int kerndep_IRQ_HANDLED = IRQ_HANDLED;
int kerndep_IRQ_NONE = IRQ_NONE;
#else
int kerndep_IRQ_HANDLED = 1;
int kerndep_IRQ_NONE = 0;
#endif

/* Functions */

static int kerndep_init_module(void)
{
    return(mill_init_module());
}

static void kerndep_cleanup_module(void)
{
    mill_cleanup_module();
}

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0)

module_init(kerndep_init_module);
module_exit(kerndep_cleanup_module);

#else

int
init_module(void)
{
    return(kerndep_init_module());
}

void 
cleanup_module(void)
{
    kerndep_cleanup_module();
}

#endif

int kerndep_init(void)
{
    wq_list = vmalloc(mill_num_wqs * sizeof(*wq_list));
    if (wq_list == NULL)
        return(-1);

    return(0);
}

void kerndep_term(void)
{
    if (wq_list)
        vfree(wq_list);
}

void kerndep_spin_lock_init(void)
{
    spin_lock_init(&mill_spinlock);
}

void kerndep_init_waitqueue_head(void)
{
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,0)
    init_waitqueue_head(&mill_lock_wq);
#endif
}

void *kerndep_vmalloc(unsigned size)
{
    return(vmalloc(size));
}

void kerndep_vfree(void *ptr)
{
    vfree(ptr);
}

void *kerndep_kmalloc(unsigned size)
{
    return(kmalloc(size,GFP_ATOMIC));
}

void kerndep_kfree(void *ptr)
{
    kfree(ptr);
}

void kerndep_printk(char *fmt,unsigned a1,unsigned a2)
{
    printk(fmt,a1,a2);
}

void kerndep_unchrdev(int maj_num,char *dev_name)
{
    unregister_chrdev(maj_num,dev_name);
}

unsigned kerndep_jiffies(void)
{
    return(jiffies);
}

int kerndep_in_interrupt(void)
{
    return(in_interrupt());
}

void *kerndep_current(void)
{
    return((void *)current);
}

void kerndep_spin_lock_irqsave(unsigned long *flagptr)
{
    unsigned long tmp_flags;

    spin_lock_irqsave(&mill_spinlock,tmp_flags);
    *flagptr = tmp_flags;
}

void kerndep_spin_unlock_irqrestore(unsigned long flags)
{
    unsigned long tmp_flags = flags;

    spin_unlock_irqrestore(&mill_spinlock,tmp_flags);
}

void kerndep_printk_notice(char *msg)
{
    printk(KERN_NOTICE "%s",msg);
}

void kerndep_printk_emerg(char *msg)
{
    printk(KERN_EMERG "%s",msg);
}

void kerndep_delay(int dval)
{
    schedule_timeout(dval * kerndep_HZ);
}

void *kerndep_wq_lock(void)
{
    return(&mill_lock_wq);
}

void *kerndep_wq_list(int wq_num,int do_init)
{
    if (do_init)
    {
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,0)
        wq_list[wq_num] = NULL;
#else
        init_waitqueue_head(&wq_list[wq_num]);
#endif
    }

    return(&wq_list[wq_num]);
}

unsigned long kerndep_init_waitqueue_entry
    (void *wq,
     unsigned long tmp1,
     int tmp2,
     unsigned long *tmp3,
     unsigned long (*cb_func)(void *wq,
                              void *wait,
                              unsigned long tmp1,
                              int tmp2,
                              unsigned long *tmp3))
{
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,0)
    struct wait_queue wait = {current,NULL};
#else
    wait_queue_t wait;

    init_waitqueue_entry(&wait,current);
#endif

    return((*cb_func)(wq,&wait,tmp1,tmp2,tmp3));
}

void kerndep_set_intr(int interruptible)
{
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,0)
    set_current_state
        ((interruptible) ? TASK_INTERRUPTIBLE : TASK_UNINTERRUPTIBLE);
#else
    current->state =
        (interruptible) ? TASK_INTERRUPTIBLE : TASK_UNINTERRUPTIBLE;
#endif
}

void kerndep_add_wait_queue(void *wq,void *wait)
{
    add_wait_queue(wq,wait);
}

void kerndep_add_wait_queue_excl(void *wq,void *wait)
{
    add_wait_queue_exclusive(wq,wait);
}

unsigned long kerndep_schedule_timeout(unsigned long n)
{
    return(schedule_timeout(n));
}

void kerndep_schedule(void)
{
    schedule();
}

void kerndep_wake_up_interruptible(void *wq)
{
#ifdef USE_SYNC
    wake_up_interruptible_sync(wq);
#else
    wake_up_interruptible(wq);
#endif
}

void kerndep_remove_wait_queue(void *wq, void *wait)
{
    remove_wait_queue(wq,wait);
}

#if HZ == 1000
#define cvt_ms_to_ticks_macro(ms_time) ms_time
#define cvt_ticks_to_ms_macro(tick_time) tick_time
#define cvt_ticks_to_ms_ovfl_ok_macro(tick_time) tick_time
#elif HZ <= 100
/* For small values of HZ, we do the computations based on the constant
   1000/HZ. This is faster than doing both a mult and division.
   If the value of HZ is too large, we can't do this computation
   because of lost accuracy due to integer division. */
#define cvt_ms_to_ticks_macro(ms_time) \
    ((ms_time >= 0xffffffff - ((1000 / HZ) - 1)) ? 0xffffffff : \
     (ms_time + ((1000 / HZ) - 1)) / (1000 / HZ))
#define cvt_ticks_to_ms_macro(tick_time) \
    ((tick_time >= 0xffffffff / (1000 / HZ)) ? 0xffffffff : \
     tick_time * (1000 / HZ))
#define cvt_ticks_to_ms_ovfl_ok_macro(tick_time) (tick_time * (1000 / HZ))
#else
/* In other cases, we must do the mult and division separately. */
#define cvt_ms_to_ticks_macro(ms_time) \
    ((ms_time >= (0xffffffff - 999) / HZ) ? 0xffffffff : \
     (ms_time * HZ + 999) / 1000)
#define cvt_ticks_to_ms_macro(tick_time) \
    ((tick_time >= (0xffffffff - (HZ + 1)) / 1000) ? 0xffffffff : \
     (tick_time * 1000 + HZ - 1) / HZ)
#define cvt_ticks_to_ms_ovfl_ok_macro(tick_time) \
    ((tick_time * 1000 + HZ - 1) / HZ)
#endif

unsigned cvt_ms_to_ticks(unsigned ms_time)
{
    return(cvt_ms_to_ticks_macro(ms_time));
}

unsigned cvt_ticks_to_ms(unsigned tick_time)
{
    return(cvt_ticks_to_ms_macro(tick_time));
}

unsigned cvt_ticks_to_ms_ovfl_ok(unsigned tick_time)
{
    return(cvt_ticks_to_ms_ovfl_ok_macro(tick_time));
}

static struct timer_list pipr_callback_timer;
static struct timer_list pipr_retry_timer;
static struct timer_list intr_period_timer;

static void kerndep_setup_timer(struct timer_list *timer,
                                void (*cb_func)(unsigned long),
                                unsigned long data,
                                unsigned expires)
{
    init_timer(timer);
    timer->function = cb_func;
    timer->data = data;
    timer->expires = expires;
    add_timer(timer);
}

void kerndep_setup_pipr_timer(void (*cb_func)(unsigned long),
                              unsigned long data,
                              unsigned expires)
{
    kerndep_setup_timer(&pipr_callback_timer,
                        cb_func,data,expires);
}

void kerndep_setup_retry_timer(void (*cb_func)(unsigned long),
                              unsigned long data,
                              unsigned expires)
{
    kerndep_setup_timer(&pipr_retry_timer,
                        cb_func,data,expires);
}

void kerndep_setup_intr_timer(void (*cb_func)(unsigned long),
                              unsigned long data,
                              unsigned expires)
{
    kerndep_setup_timer(&intr_period_timer,
                        cb_func,data,expires);
}

void kerndep_del_pipr_timer(void)
{
    del_timer_sync(&pipr_callback_timer);
}

void kerndep_del_retry_timer(void)
{
    del_timer_sync(&pipr_retry_timer);
}

void kerndep_del_intr_timer(void)
{
    del_timer_sync(&intr_period_timer);
}

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0)
static struct work_struct mill_isa_tq;
static DECLARE_WORK(mill_isa_tq,bostonisa_dpc,NULL);
#else
static struct tq_struct mill_isa_tq = {
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,0)
    NULL,
#else
    {NULL},
#endif
    0,
    bostonisa_dpc,
    NULL
};
#endif

void kerndep_queue_task_isa_tq(void)
{
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0)
    schedule_work(&mill_isa_tq);
#else
    queue_task(&mill_isa_tq,&tq_immediate);
    mark_bh(IMMEDIATE_BH);
#endif
}

#ifndef release_t
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,31)
#define release_t void
#define release_return(x) return
#else
#define release_t int
#define release_return(x) return (x)
#endif
#endif

int bostonopen(struct inode *inode, struct file *filp)
{
    void *priv;
    int tmp;

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0)
      if (!try_module_get(THIS_MODULE))
	return(-ENODEV);
#endif

    tmp = mill_bostonopen(inode,filp,&priv);
    if (tmp == 0)
    {
        filp->private_data = priv;
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,0)
        MOD_INC_USE_COUNT;
#endif
    }
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0)
    else
        module_put(THIS_MODULE);
#endif

    return(tmp);
}

release_t bostonclose(struct inode *inode, struct file *filp)
{
    int tmp = mill_bostonclose(inode,filp,filp->private_data);

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0)
    module_put(THIS_MODULE);
#else
    MOD_DEC_USE_COUNT;
#endif
    release_return(tmp);
}

int bostonioctl(struct inode *inode, struct file *filp,
                unsigned int cmd, unsigned long arg)
{
    return(mill_bostonioctl(inode,filp,cmd,arg,filp->private_data));
}

int kerndep_chrdev(char *dev_name)
{
    mill_fops.open = bostonopen;
    mill_fops.release = bostonclose;
    mill_fops.ioctl = bostonioctl;
    return(register_chrdev(0,dev_name,&mill_fops));
}

int kerndep_copy_from_user(void *to,void *from,unsigned long size)
{
    return(copy_from_user(to,from,size));
}

int kerndep_copy_to_user(void *to,void *from,unsigned long size)
{
    return(copy_to_user(to,from,size));
}

#ifdef USE_SYNC
#ifndef wake_up_sync
#ifdef CONFIG_SMP
#define wake_up_sync(x)   __wake_up_sync((x),TASK_UNINTERRUPTIBLE | TASK_INTERRUPTIBLE, 1)
#else
#define wake_up_sync(x)   __wake_up((x),TASK_UNINTERRUPTIBLE | TASK_INTERRUPTIBLE, 1)
#endif
#endif

void kerndep_wake_up_lock(void)
{
    wake_up_sync(&mill_lock_wq);
}

#else

void kerndep_wake_up_lock(void)
{
    wake_up(&mill_lock_wq);
}
#endif

#ifndef CONFIG_PCI
#error "No PCI support in kernel!"
#endif

int kerndep_pci_present(void)
{
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0)
    return(1);
#else
    return(pci_present());
#endif
}

void *kerndep_pci_find_dev(unsigned vend_id,unsigned dev_id,void *dev)
{
    struct pci_dev *tmp = pci_find_device(vend_id,dev_id,dev);

    if (tmp)
        pci_enable_device(tmp);
    return(tmp);
}

unsigned kerndep_dev_vend_id(void *dev)
{
    return(((struct pci_dev *)dev)->vendor);
}

unsigned kerndep_dev_dev_id(void *dev)
{
    return(((struct pci_dev *)dev)->device);
}

unsigned kerndep_dev_bus_num(void *dev)
{
    return(((struct pci_dev *)dev)->bus->number);
}

unsigned kerndep_dev_func_num(void *dev)
{
    return(((struct pci_dev *)dev)->devfn);
}

unsigned kerndep_dev_irq(void *dev)
{
    return(((struct pci_dev *)dev)->irq);
}

void kerndep_dev_resource(void *dev,
			  int bar_num,
			  int *is_io,
			  unsigned long *start,
			  unsigned long *end)
{
    struct pci_dev *tr_dev = dev;

    *is_io = tr_dev->resource[bar_num].flags & IORESOURCE_IO;
    *start = tr_dev->resource[bar_num].start;
    *end = tr_dev->resource[bar_num].end;
}

unsigned kerndep_func_to_slot(unsigned func)
{
    return(PCI_SLOT(func));
}

unsigned kerndep_func_to_func(unsigned func)
{
    return(PCI_FUNC(func));
}

int kerndep_pci_read_config_byte(void *dev,unsigned off,void *addr)
{
    return(pci_read_config_byte(dev,off,addr));
}

int kerndep_pci_read_config_word(void *dev,unsigned off,void *addr)
{
    return(pci_read_config_word(dev,off,addr));
}

int kerndep_pci_read_config_dword(void *dev,unsigned off,void *addr)
{
    return(pci_read_config_dword(dev,off,addr));
}

int kerndep_pci_write_config_byte(void *dev,unsigned off,unsigned char val)
{
    return(pci_write_config_byte(dev,off,val));
}

int kerndep_pci_write_config_word(void *dev,unsigned off,unsigned short val)
{
    return(pci_write_config_word(dev,off,val));
}

int kerndep_pci_write_config_dword(void *dev,unsigned off,unsigned long val)
{
    return(pci_write_config_dword(dev,off,val));
}

void *kerndep_ioremap(unsigned long off,unsigned long size)
{
    return(ioremap(off,size));
}

void kerndep_iounmap(void *ptr)
{
    iounmap(ptr);
}

unsigned long kerndep_virt_to_bus(void *ptr)
{
    return(virt_to_bus(ptr));
}

unsigned long kerndep_get_free_page(void)
{
    return(__get_free_page(GFP_KERNEL));
}

void kerndep_free_page(unsigned long addr)
{
    free_page(addr);
}

int kerndep_request_irq(unsigned irq_num,
			int (*hdlr)(int irq,void *dev,void *regs),
                        int sharing,char *name,void *dev_id)
{
    return(request_irq
           (irq_num,
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0)
	    (irqreturn_t (*)(int irq,void *dev,struct pt_regs *regs))hdlr,
#else
	    (void (*)(int irq,void *dev,struct pt_regs *regs))hdlr,
#endif
            (sharing) ? SA_SHIRQ : 0,name,dev_id));
}

void kerndep_free_irq(unsigned irq_num,void *dev_id)
{
    free_irq(irq_num,dev_id);
}

void kerndep_writeb(unsigned val,volatile void *addr)
{
    writeb(val,addr);
}

void kerndep_writew(unsigned val,volatile void *addr)
{
    writew(val,addr);
}

void kerndep_writel(unsigned val,volatile void *addr)
{
    writel(val,addr);
}

unsigned kerndep_readb(volatile void *addr)
{
    return(readb(addr));
}

unsigned kerndep_readw(volatile void *addr)
{
    return(readw(addr));
}

unsigned kerndep_readl(volatile void *addr)
{
    return(readl(addr));
}

void kerndep_outb(unsigned val,unsigned addr)
{
    outb(val,addr);
}

void kerndep_outw(unsigned val,unsigned addr)
{
    outw(val,addr);
}

void kerndep_outl(unsigned val,unsigned addr)
{
    outl(val,addr);
}

unsigned kerndep_inb(unsigned addr)
{
    return(inb(addr));
}

unsigned kerndep_inw(unsigned addr)
{
    return(inw(addr));
}

unsigned kerndep_inl(unsigned addr)
{
    return(inl(addr));
}

void kerndep_outsw(unsigned addr,void *ptr,unsigned size)
{
    outsw(addr,ptr,size);
}

void kerndep_insw(unsigned addr,void *ptr,unsigned size)
{
    insw(addr,ptr,size);
}

void kerndep_memcpy_toio(volatile void *io_addr,void *mem_addr,unsigned size)
{
    memcpy_toio(io_addr,mem_addr,size);
}

void kerndep_memcpy_fromio(void *mem_addr,volatile void *io_addr,unsigned size)
{
    memcpy_fromio(mem_addr,io_addr,size);
}

int kerndep_check_region(unsigned addr,unsigned size)
{
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0)
    return(0);
#else
    return(check_region(addr,size));
#endif
}

void *kerndep_request_region(unsigned addr,unsigned size,char *dev_name)
{
    return(request_region(addr,size,dev_name));
}

void kerndep_release_region(unsigned addr,unsigned size)
{
    release_region(addr,size);
}


#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,18)
#define PARM_DECL_INT(v) module_param(v,int,0)
#define PARM_DECL_INT_ARRAY(v) module_param_array(v,int,NULL,0)
#define PARM_DECL_INT_ARRAY_8 PARM_DECL_INT_ARRAY
#define PARM_DECL_INT_ARRAY_64 PARM_DECL_INT_ARRAY
#elif LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0)
#define PARM_DECL_INT(v) module_param(v,int,0)
#define PARM_DECL_INT_ARRAY(v) \
    int size_##v; module_param_array(v,int,size_##v,0)
#define PARM_DECL_INT_ARRAY_8 PARM_DECL_INT_ARRAY
#define PARM_DECL_INT_ARRAY_64 PARM_DECL_INT_ARRAY
#else
#define PARM_DECL_INT(v) MODULE_PARM(v,"i")
#define PARM_DECL_INT_ARRAY_8(v) MODULE_PARM(v,"1-8i")
#define PARM_DECL_INT_ARRAY_64(v) MODULE_PARM(v,"1-64i")
#endif

PARM_DECL_INT(nmill);
PARM_DECL_INT_ARRAY_8(mill_isa_addrs);
PARM_DECL_INT(mill_isa_hw_int);
PARM_DECL_INT(mill_isa_dma_chan);
PARM_DECL_INT(mill_mphm);
PARM_DECL_INT(mill_phy_buf_size);
PARM_DECL_INT(mill_app_buf_size);
PARM_DECL_INT(mill_machine_id);
PARM_DECL_INT(mill_do_reset);
PARM_DECL_INT(mill_history_enable);
PARM_DECL_INT(mill_history_size);
PARM_DECL_INT(mill_num_hists_phy);
PARM_DECL_INT(mill_num_hists_apl);
PARM_DECL_INT(mill_hist_phy_admin_only);
PARM_DECL_INT(mill_num_I2O_frames_per_module);
PARM_DECL_INT(mill_fc_interval);
PARM_DECL_INT(mill_mem_drv_alloc_min);
PARM_DECL_INT(mill_mem_drv_alloc_quanta);
PARM_DECL_INT(mill_num_reserved_modules);
PARM_DECL_INT_ARRAY_64(mill_mod_vals);
PARM_DECL_INT(mill_test1);
PARM_DECL_INT(mill_test2);
PARM_DECL_INT(mill_test3);
PARM_DECL_INT(mill_config_vars_set);
