#!/bin/sh
#
# ------------------------------------------------------------------------
# script to start/stop the Brooktroot TR1034 drivers
#
BOSTON_DIR="/usr/sys/boston"
BRKTD_LICENSE_FILE="/usr/sys/boston"
export BRKTD_LICENSE_FILE
[ ! -x /etc/startbost ] ||
{
	case "$1" in

	# ----------------------------------------------------------------
	# help targets
	#
	'-?'  | -help    | --help | \
	'-??' | -helpall | --helpall)
		echo "Usage: `basename $0` start|stop" ;;

	# ----------------------------------------------------------------
	# version targets
	#
	'-V' | -version | --version)
		echo "`basename $0`: `vfxadmin version`" ;;

	# ----------------------------------------------------------------
	# standard targets
	#
	start)		/etc/startbost
			if [ -x $BOSTON_DIR/Bostsrv ]
			then
				 $BOSTON_DIR/Bostsrv -c $BOSTON_DIR/btcall.cfg -f $BOSTON_DIR/fw -D
				sleep 5
			fi
			;;

	stop)		if [ -x $BOSTON_DIR/Bostsrv -a -a /var/run/Bostsrv.pid ]
			then
				$BOSTON_DIR/Bostsrv -k
				i="1"
				while [ $i -lt 10 -a -a /var/run/Bostsrv.pid ]
				do
					i=`expr $i + 1`
					sleep 2
				done
			fi
			/etc/startbost -r

			;;

	# ----------------------------------------------------------------
	# HP-specific targets
	#
	start_msg)	echo "Starting the VSI-FAX Brooktroot TR1034 drivers subsystem" ;;
	stop_msg)	echo "Stopping the VSI-FAX Brooktroot TR1034 drivers subsystem" ;;

	esac
}
