// +++FHDR+++
//
//
//   Class Name : Transportmanager
//   Super Class: n/a
//
//   Description:
// 	The TransportManager class manages the transports that are available
//	for sending XML-F requests to the network fax server. Transports can
//	be added at runtime by binding a transport protocol name to a
//	transporting object. All transports must be sub-classed from the
//	DocumentTransport class. Currently the HTTP transport is implemented
//	and automatically bound when the TransportManager class is initialized. 
//
// 	Additionally, the TransportManager class manages XML document decoders.
//	These document decoders take an XML document and map it into an object
//	which represents that document. Document decoders must be sub-classed
//	from the DocumentDecoder class. Document decoders are provided for the
//	three XML-F response documents (fax-submit-response,
//	fax-status-response, and fax-cancel-response documents).
//
//
//   Notes	: none
//
//
//   Method - Description
//   ------------------------------------------------------------------------
//
//
// ---FHDR---

#include "Registry.h"
#include "XmlfObject.h"
#include "Response.h"
#include "DocumentDecoder.h"
#include "DocumentTransport.h"
#include "OutputString.h"

class TransportManager {

  private:

  protected:

	OutputString _err_msg;

	char * _default_protocol;

	Registry * _transports;
	Registry * _decoders;

	static TransportManager * _manager;

  public:

	TransportManager ();
	~TransportManager ();

	char * getLastError ();

	char * getDefaultTransport ();
	void setDefaultTransport (char * protocol);
	
	int bindDecoder (char * doc_type, DocumentDecoder * decoder);
	int bindTransport (char * protocol, DocumentTransport * transporter);

	int unbindDecoder (char * doc_type);
	int unbindTransport (char * protocol);

	char ** listDecoders ();
	char ** listTransports ();

	DocumentDecoder * lookupDecoder (char * doc_type);
	DocumentTransport * lookupTransport (char * protocol);

	char * send (char * url, char * xml_data);
	char * send (char * url, istream * xml_stream);
	Response * send (char * url, XmlfObject * obj);

	Response * decode (char * xmlf_data);
};

