package com.vsi.xmlf.beans;

import javax.swing.JComponent;


import java.awt.*;
import java.util.Vector;
import java.util.Enumeration;


class LabeledPairLayout implements LayoutManager, java.io.Serializable {

	protected Vector _labels = new Vector();
	protected Vector _fields = new Vector();
  
	protected int _y_spacing = 2;
	protected int _x_spacing = 2;

	protected int _margin_width = 8;
	protected int _margin_height = 8;


	public void setMarginWidth (int width) {
		_margin_width = width;
	}

	public void setMarginHeight (int height) {
		_margin_height = height;
	}


	public void setXSpacing (int x_spacing) {
		_x_spacing = x_spacing;
	}


	public void setYSpacing (int y_spacing) {
		_y_spacing = y_spacing;
	}


	public void addLayoutComponent(String s, Component c) {
		if (s.equals("label")) {
			_labels.addElement(c);
		}  else {
			_fields.addElement(c);
		}
	}


  	public void layoutContainer (Container c) {
  		Insets insets = c.getInsets();
  
  		int labelWidth = 0;
  		Enumeration labelIter = _labels.elements();
  		while(labelIter.hasMoreElements()) {
	      		JComponent comp = (JComponent)labelIter.nextElement();
	      		labelWidth = Math.max(labelWidth,
				comp.getPreferredSize().width);
  		}

  		int y = insets.top + _margin_height;

  		Enumeration fieldIter = _fields.elements();
  		labelIter = _labels.elements();
  		while(labelIter.hasMoreElements() && 
			fieldIter.hasMoreElements()) {

	      		JComponent label = (JComponent)labelIter.nextElement();
	      		JComponent field = (JComponent)fieldIter.nextElement();
	      		int height = Math.max(label.getPreferredSize().height,
				field.getPreferredSize().height);
	      		label.setBounds(_margin_width + insets.left, 
				y, labelWidth, height); 
	      		field.setBounds(_margin_width + insets.left + 
				labelWidth + _x_spacing, y, 
		 		c.getSize().width - 2 * _margin_width -
				(labelWidth + _x_spacing + insets.left + 
				insets.right), height); 
			y += (height + _y_spacing);
		}
	}


	public Dimension minimumLayoutSize(Container c) {
  		Insets insets = c.getInsets();
	  
  		int labelWidth = 0;
  		Enumeration labelIter = _labels.elements();
  		while(labelIter.hasMoreElements()) {
		      	JComponent comp = (JComponent)labelIter.nextElement();
	 	     	labelWidth = Math.max(labelWidth, 
				comp.getPreferredSize().width);
	  	}

	  	int y = _margin_height + insets.top;

	  	labelIter = _labels.elements();
	  	Enumeration fieldIter = _fields.elements();
	  	while(labelIter.hasMoreElements() &&
			fieldIter.hasMoreElements()) {

	  		JComponent label = (JComponent)labelIter.nextElement();
  			JComponent field = (JComponent)fieldIter.nextElement();
	  		int height = Math.max(label.getPreferredSize().height,
				field.getPreferredSize().height);
	  		y += (height + _y_spacing);
	 	}

	 	return new Dimension(labelWidth * 3 + 2 * _margin_width, 
			y + _margin_height);
	}

  
	public Dimension preferredLayoutSize(Container c) {
	 	return (minimumLayoutSize(c));
	}

   
	public void removeLayoutComponent(Component c) {
	}
}

