package com.vsi.xmlf;

/**
 * This is the base class for all XML-F obects.
 *
 */
public
interface XmlfObject {

	/**
	 * Gets a string containing the XML for this object. Use
	 * <code>toXml(String indent)</code> to output indented XML.
	 *
	 * @return  a String containing the XML for this object
	 * @see     #toXml(String indent)
	 */
	public String toXml ();


	/**
	 * Gets a string containing the indented XML for this object. Use
	 * <code>toXml()</code> to output non-formatted XML.
	 *
	 * @return  a String containing the indented XML for this object
	 * @see     #toXml()
	 */
	public String toXml (String indent);


	/**
	 * Gets the XML tag for this object. The tag is
         * utilized in the toXml() method.
	 *
	 * @return  the tag for this XML object
	 * @see     #setTag
	 * @see     #toXml
	 */
	public String getTag ();


	/**
	 * Sets the XML tag for this object.
         *
         * @param  tag  the XML tag name for this object
	 * @see    #getTag
	 */
	public void setTag (String tag);
}

