package com.vsi.xmlf;

import java.util.Vector;

/**
 *
 *
 */
public
class StatusResponse extends Response {


	protected JobStatus _job_status = null;
	protected Vector _attempts = new Vector();


	/**
	 * No args constructor.
	 */
	public StatusResponse () {
		setTag("fax-status-response");
	}


	/**
	 *
	 */
	public StatusResponse (String results_message, String results_status,
		String svc_ref, String app_ref, String cmd_ref) {

		super(results_message, results_status, 
			svc_ref, app_ref, cmd_ref);
		setTag("fax-status-response");
	}


	/**
	 *
	 */
	public StatusResponse (XmlElement element) {
		setFromXml(element);
		setTag("fax-status-response");
	}


	/**
	 * Gets a string containing the XML for this object. Use
	 * <code>toXml(String indent)</code> to output indented XML.
	 *
	 * @return  a String containing the XML for this object
	 * @see     #toXml(String indent)
	 */
	public String toXml () {
		return (toXml(""));
	}


	/**
	 * Gets a string containing the indented XML for this object. Use
	 * <code>toXml()</code> to output non-formatted XML.
	 *
	 * @return  a String containing the indented XML for this object
	 * @see     #toXml()
	 */
	public String toXml (String indent) {

		StringBuffer xml = new StringBuffer();

		if (indent == null)
			indent = "";

		xml.append(indent + "<?xml version=\"1.0\"?>\n");
		xml.append(indent + "<" + getTag() + ">\n");

		xml.append(getRequestResultsXml(indent + "\t"));

		/*
		 * output the status elements
		 */
		if (getAttemptsCount() < 1) {
			xml.append(indent + "\t<short-status>\n");

			if (getJobStatus() != null) {
				xml.append(getJobStatus().toXml(
					indent + "\t\t"));
			}

			xml.append(indent + "\t</short-status>\n");
		} else {
			xml.append(indent + "\t<full-status>\n");

			if (getJobStatus() != null) {
				xml.append(getJobStatus().toXml(
					indent + "\t\t"));
			}

			AttemptStatus attempts[] = getAttempts();
			for (int i = 0; i < attempts.length; i++) {
				xml.append(attempts[i].toXml(indent + "\t\t"));
			}

			xml.append(indent + "\t</full-status>\n");
		}

		xml.append(getReferencesXml(indent + "\t"));
		xml.append(indent + "</" + getTag() + ">\n");

		return (xml.toString());
	}


	/**
	 * Assignes the values/attributes in the XML data to this object.
	 *
	 * @param  root_element  the XML data to assign from
	 */
	public void setFromXml (XmlElement root_element) {

		setJobStatus(null);
		_attempts.setSize(0);

		super.setFromXml(root_element);

		XmlElement job_element = null;
		XmlElement short_element = 
			root_element.findElement("short-status");
		if (short_element != null) {
			job_element = short_element.findElement("job-status");
		}

		XmlElement full_element = 
			root_element.findElement("full-status");
		if (full_element != null) {
			job_element = full_element.findElement("job-status");

			XmlElement attempts[] = full_element.getSubElements();
			for (int i = 0; i < attempts.length; i++) {

				if (attempts[i].getName().equalsIgnoreCase(
				    "attempt-status")) {

					AttemptStatus attempt = 
						new AttemptStatus(attempts[i]);
					_attempts.addElement(attempt);
				}
			}
		}


		if (job_element != null) {
			setJobStatus(new JobStatus(job_element));
		}
	}


	/**
	 *
	 */
	public synchronized JobStatus getJobStatus () {
		return (_job_status);
	}


	/**
	 *
	 */
	public synchronized void setJobStatus (JobStatus job_status) {
		_job_status = job_status;
	}



	/**
	 *
	 */
	public synchronized int getAttemptsCount () {
		return (_attempts.size());
	}


	public synchronized AttemptStatus getAttempts (int index)
		throws ArrayIndexOutOfBoundsException {

		if (index < 0 || index >= getAttemptsCount()) {
			throw new ArrayIndexOutOfBoundsException();
		}

		return ((AttemptStatus)_attempts.elementAt(index));
	}


	public synchronized AttemptStatus [] getAttempts () {

		AttemptStatus list[] = new AttemptStatus[getAttemptsCount()];
		_attempts.copyInto(list);
		return (list);
	}


	public synchronized void setAttempts (int index, AttemptStatus attempt)
		throws ArrayIndexOutOfBoundsException {

		if (index < 0 || index >= getAttemptsCount()) {
			throw new ArrayIndexOutOfBoundsException();
		}

		_attempts.setElementAt(attempt, index);
	}


	/**
	 * Sets the attempt status list to contain the array of 
	 * AttemptStatus objects.
	 *
	 * @param  list  the array of <code>Body</code> objects.
	 */
	public synchronized void setAttempts (AttemptStatus list[]) {

		int num_attempts = list.length;

		_attempts.setSize(num_attempts);

		for (int i = 0; i < num_attempts; i++) {
			try {
				setAttempts(i, list[i]);
			} catch (ArrayIndexOutOfBoundsException e) {
			}
		}
	}
}

