package com.vsi.xmlf;

/**
 *
 *
 */
public
class Resolution {


	public static final Resolution STD  = new Resolution("std");
	public static final Resolution FINE = new Resolution("fine");

	private String _value = null;

	/**
	 * Constructors are private since this class is for constants only.
	 */
	private Resolution () {
	}

	private Resolution (String value) {
		_value = value;
	}


	public String toString () {
		return (_value);
	}


	/**
	 * Given a resolution string return the corresponding 
	 * <code>Resolution</code> object.
	 *
	 * @return  the <code>Resolution</code> object corresponding the the 
	 * given string
	 */
	public static Resolution stringToObject (String str) {

		if (str == null) {
			return (null);
		}

		if (str.equalsIgnoreCase("std")) {
			return (STD);
		} else if (str.equalsIgnoreCase("fine")) {
			return (FINE);
		} else {
			return (null);
		}
	}
}

