package com.vsi.xmlf;

/**
 * This class encapsulates a XML-F fax-cancel request.
 *
 */
public
class CancelRequest extends Request {


	protected String _tag = "fax-cancel";
	

	/**
	 * No args constructor.
	 */
	public CancelRequest() {
	}


	/**
	 * This constructor creates a <code>CancelRequest</code> object
	 * from the passed in XML.
	 *
	 * @param  the XML to use in constructing the object
	 */
	public CancelRequest (XmlElement element) {
		setFromXml(element);
	}


	/**
	 * Gets the XML tag for this object. This method is implemented by
         * all classes implementing the XmlfObject interface. The tag is
         * utilized in the toXml() method.
	 *
	 * @return  the tag for this XML object
	 * @see     #setTag
	 * @see     #toXml
	 */
	public synchronized String getTag () {
		return (_tag);
	}


	/**
	 * Sets the XML tag for this object. This method is implemented by
         * all classes implementing the XmlfObject interface.
         *
         * @param  tag  the XML tag name for this object
	 * @see    #getTag
	 */
	public synchronized void setTag (String tag) {
		_tag = tag;
	}


	/**
	 * Gets a string containing the XML for this object. Use
	 * <code>toXml(String indent)</code> to output indented XML.
	 *
	 * @return  a String containing the XML for this object
	 * @see     #toXml(String indent)
	 */
	public String toXml () {
		return (toXml(""));
	}

	
	/**
	 * Gets a string containing the indented XML for this object. Use
	 * <code>toXml()</code> to output non-formatted XML.
	 *
	 * @return  a String containing the indented XML for this object
	 * @see     #toXml()
	 */
	public String toXml (String indent) {
		
		StringBuffer xml = new StringBuffer();

		if (indent == null)
			indent = "";

		xml.append(indent + "<?xml version=\"1.0\"?>\n");

		xml.append(indent + "<" + getTag());
		if (getResponseFormat() != null) {
			xml.append(" response-format=\"" +
				getResponseFormat() + "\"");
		}
		xml.append(">\n");

		xml.append(getAccount().toXml(indent + "\t"));


		if (getServiceReference() != null) {
			xml.append(indent + "\t<service-reference>" +
				getServiceReference() + 
				"</service-reference>\n");
		}

		if (getApplicationReference() != null) {
			xml.append(indent + "\t<application-reference>" +
				getApplicationReference() + 
				"</application-reference>\n");
		}

		if (getCommandReference() != null) {
			xml.append(indent + "\t<command-reference>" +
				getCommandReference() + 
				"</command-reference>\n");
		}

		xml.append(indent + "</"  + getTag()      + ">\n");
		return (xml.toString());
	}
}
